/* dhry_os2.c
 *
 * Author:  Kai Uwe Rommel <rommel@ars.de>
 * Created: Thu Dec 21 1995
 */
 
static char *rcsid =
"$Id$";
static char *rcsrev = "$Revision$";

/*
 * $Log$ 
 */

#define INCL_DOS
#define INCL_DOSDEVICES
#define INCL_DOSDEVIOCTL
#define INCL_DOSERRORS
#define INCL_NOPM
#include <os2.h>

extern unsigned long Number_Of_Runs;

VOID APIENTRY timer_thread(ULONG nArg)
{
  DosSleep(nArg);
  Number_Of_Runs = 1;
  DosExit(EXIT_THREAD, 0);
}

QWORD nStart, nStop;

ULONG start_timer(ULONG nSeconds)
{
  ULONG nPost;
  APIRET rc;
  TID tid;

  DosCreateThread(&tid, timer_thread, nSeconds * 1000, 0, 8192);

  if (DosTmrQueryTime(&nStart))
    return printf("Timer error.\n"), -1;

  nPost = 0;

  return 0;
}

ULONG stop_timer(int accuracy)
{
  ULONG nFreq;

  if (DosTmrQueryTime(&nStop))
    return printf("Timer error.\n"), -1;
  if (DosTmrQueryFreq(&nFreq))
    return printf("Timer error.\n"), -1;

  nFreq = (nFreq + accuracy / 2) / accuracy;

  return (nStop.ulLo - nStart.ulLo) / nFreq;
}

/* end of dhry_os2.c */
