/*                   Install the Audio-CD-Folder 
 *
 *                   (C) Chris Wohlgemuth 1999
*/

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

 call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
 call SysLoadFuncs

'cls'
say ''
Say 'About to install the Audio-CD-Creator'
Say '(c) Chris Wohlgemuth 1998-99'
say 'This program and all files are released under the GPL'
say 'See file ''Copying'' for information.'
say ''

say 'Press <ENTER> to install or Ctrl-c to abort now.'
say ''
say '>'
parse value SysCurPos() with aktzeile aktspalte
newposition=SysCurPos(aktzeile-1,2)
pull

/* Clear screen */
'cls'

/* Get curent directory */
curdir = directory()

say 'Current directory is' curdir
say ''

/* Query bootdrive */
say 'Quering boot drive...'
parse upper value VALUE('PATH',,'OS2ENVIRONMENT') with '\OS2\INSTALL' -2 boot +2
parse upper value VALUE('PATH',,'OS2ENVIRONMENT') with '\OS2\SYSTEM' -2 boot2 +2
say ''
if boot=boot2 then say 'Bootdrive seems to be' boot
say 'Enter ''y'' to confirm or the real bootdrive letter'
say ''
say '>'
parse value SysCurPos() with aktzeile aktspalte
newposition=SysCurPos(aktzeile-1,2)
parse pull in

if in='y'|in='Y'  then boot=boot
else boot=in':'


/* Clear screen */
'cls'

/* Build help destination path */
helppath=boot'\os2\help\aucdfldr.hlp'
helpsource=curdir'\aucdfldr.hlp'

progfolderdll=curdir'\progfldr.dll'
boot=boot'\os2\dll\progfldr.dll' /* Build destination path */
say ''
say 'Copying progfldr.dll to 'boot
say ''

/*result=*/
copy progfolderdll boot
say ''

say 'Registering class ''CWProgFolder''...'

if SysRegisterObjectClass("CWProgFolder",'progfldr')<>1 then
	do	 	
                say ''
		say 'Error while registering class ''CWProgFolder'''
		del boot
		say 'Exiting...'
		exit 	
	end 

audiofolderdll=curdir'\aucdfldr.dll'

say 'Registering class ''CWAudioFolder''...'
if SysRegisterObjectClass("CWAudioFolder",audiofolderdll)<>1 then
	do	 	
                say ''
		say 'Error while registering class ''CWAudioFolder'''
		say 'Deregistering class ''CWProgFolder'''
		if SysDeregisterObjectClass("CWProgFolder") <>1 then
			say 'Error while deregistering class ''CWProgFolder'''
		del boot
		say 'Exiting...'
		say 'After reboot delete file 'boot
		exit 	
	end 

say 'Copying help file...'
copy helpsource helppath

say 'Customizing the template in the templates folder...'
if SysCreateObject("CWAudioFolder","Audio-CD-Creator","<WP_TEMPS>","OBJECTID=<AUDIOCD_CREATOR>;FLDRWRITEFLAGS=11","update")<>1 then
             say '     Can''t update the template.'

say 'Creating a CD-Writing folder on the desktop...'
if SysCreateObject("WPFolder","CD-Writing Utilities","<WP_DESKTOP>","OBJECTID=<CD_WRITING>","update")<>1 then
             do
                say ''
                say 'Can''t create the folder. Exciting...'
		say 'You''ll find a template in your templates folder.'
		exit
             end

setupstring='EXENAME='curdir'\cdrtools.exe;STARTUPDIR='curdir

say 'Creating an object for CDRTools...'
if SysCreateObject("WPProgram","CDR-Tools","<CD_WRITING>",setupstring,"update")<>1 then
		do
              say ''
              say 'Can''t create a program object for CDRTools.exe.'
              say 'You can find CDRTools in 'curdir
              say '' 
            end

say 'Creating shadows for the Readme files...'
setupstring='SHADOWID='curdir'\Readme.CDRTools'

if SysCreateObject("WPShadow","Readme.CDRTools","<CD_WRITING>",setupstring,"update")<>1 then
	do
              say 'Can''t create the shadow for Readme.CDRTools.'
	      say 'Perhaps on FAT-Drive not HPFS...'
	end
setupstring='SHADOWID='curdir'\Readme.Creator'

if SysCreateObject("WPShadow","Readme.Creator","<CD_WRITING>",setupstring,"update")<>1 then
	do
              say 'Can''t create the shadow for Readme.Creator.'
	      say 'Perhaps on FAT-Drive not HPFS...'
	end
setupstring='SHADOWID='curdir'\Copying'

if SysCreateObject("WPShadow","Copying","<CD_WRITING>",setupstring,"update")<>1 then
	do
              say 'Can''t create the shadow for file COPYING.'
	      
	end



say 'Creating a shadow of the Audio-CD-Creator in the CD-Writing folder...'
if SysCreateObject("WPShadow","Audio-CD-Creator","<CD_WRITING>","SHADOWID=<AUDIOCD_CREATOR>","update")<>1 then
              say 'Can''t create the shadow.'

/* Open the CD-writing folder */
rc=SysSetObjectData("<CD_WRITING>","OPEN=DEFAULT")

say ''
say 'The Audio-CD-Creator was installed succesful.'
say 'You''ll find a template in your templates folder for creating'
say 'Audio-CD projects.'
say ''
say 'Have fun :-) !!'

say ''
say ''
say 'Press <ENTER>'
say ''
say '>'
parse value SysCurPos() with aktzeile aktspalte
newposition=SysCurPos(aktzeile-1,2)
pull

exit

