/*
   Script to Update PMNapster Files.
   By: Ricardo Mayrink - 21/02/2001
*/

/* Loading REXXUTIL Functions */
ok = RxFuncAdd( 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs' )
ok = SysLoadFuncs()

rc = SysCLS()

rc = SysCurPos(6, 1)
rc = Center("Updating PMNapster for OS/2 and eComStation", 80)
say

PMNDir = Directory()
File = "pmnupdate.zip"

say "Testing Zip File..."
/* Testing Zip File */
'@unzip -t '||File
if rc <> 0 then
   say "Error in Zip File! Retry Automatic Update again or try manual download from PMNapster Homepage."
else do
   say "Zip File OK. Unzipping..."
   /* Unzipping PMNapster Update Package */
   '@unzip -o '||File
   rcz = rc
end

if rcz = 0 then
  Say "PMNapster Update sucessful."
else
  say "PMNapster Update Fail! Try "Unzip -o pmnupdate.zip" to manual update."

/* Updating PMNapster Object to Default */
call SysCreateObject "WPProgram", "PMNapster - Debug", "<NAPSTEROS2FOLDER>","OBJECTID=<NAPSTEROS2DBG>;EXENAME="PMNDir"\napster.exe;STARTUPDIR=" || PMNDir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;PARAMETERS=debug;", "U"
call SysSetObjectData "<NAPSTEROS2DBG>", "Title=PMNapster 3 Update - Debug"
call SysCreateObject "WPProgram", "PMNapster", "<NAPSTEROS2FOLDER>","OBJECTID=<NAPSTEROS2OBJ>;EXENAME="PMNDir"\napster.exe;STARTUPDIR=" || PMNDir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;", "U"
call SysSetObjectData "<NAPSTEROS2OBJ>", "Title=PMNapster 3 Update"

rc = Center("Automatic Update complete. Starting PMNapster.EXE...", 80)
rc = SysSleep(5)

'@Start napster.exe'

Exit 0

