/* example of using mpg123.dll in C - Samuel Audet <guardia@cam.org> */

#define INCL_DOS
#include <os2.h>
#include <stdio.h>
#include "mp123.h"

int main(int argc, char *argv[])
{
   FileInfo fileinfo;
   decoderParms playinfo;
   BOOL finished, played;
   char *filename;

   if(argc < 2) return 1;

   filename = argv[1];

   decoderInit();

   decoderFileInfo(filename,&fileinfo);
   printf("%d\n", fileinfo.mpeg);
   printf("%d\n", fileinfo.layer);
   printf("%d\n", fileinfo.freq);
   printf("%s\n", modes[fileinfo.mode]);
   printf("%d\n", fileinfo.modext);
   printf("%d\n", fileinfo.bpf);
   printf("%d\n", fileinfo.channel);
   printf("%d\n", fileinfo.bitrate);
   printf("%d\n", fileinfo.extention);
   printf("%d\n", fileinfo.junklength);
   printf("%d\n", fileinfo.songlength);


   playinfo.filename = filename;
   playinfo.volume = 100;
   playinfo.flushbuffers = 1;
   playinfo.lockdevice = 0;
   playinfo.force8bit = 0;
   playinfo.forcemono = 0;
   playinfo.downsample = 0;
   playinfo.device = 0;
   playinfo.numbuffers = 32;
   playinfo.boostclass = 3;
   playinfo.boostdelta = 0;
   playinfo.normalclass = 2;
   playinfo.normaldelta = 31;
   playinfo.proxyurl = NULL;
   playinfo.httpauth = NULL;

   decoderCmd(MP123_SETUP,&playinfo);
   decoderCmd(MP123_PLAY,&playinfo);

   finished = 0;
   played = 0;

   do
   {
      if(decoderPlaying())
      {
         printf("\r%d seconds played  %d total seconds",
                decoderTime(PLAYEDSECS), decoderTime(TOTALSECS));
         fflush(stdout);
         played = 1;
      }
      else if(played)
         finished = 1;

      DosSleep(1000);
   }
   while(!finished);

   decoderUnInit();

   return 0;
}
