/* Install.CMD: Install MiniMixer 2.0 for Pas16 */

'@Echo Off'

/* Initialize object title and program name(s) */

Title = 'MiniMixer 2.0'
Pgmname.0 = 6
Pgmname.1 = 'MiniMix.exe'
Pgmname.2 = 'CMDLINE.exe'
Pgmname.3 = 'Folder.Ico'
Pgmname.4 = 'Install.Cmd'
Pgmname.5 = 'DOC.Ico'
Pgmname.6 = 'MM21.Ico'

Docfile.0 = 4
DocFile.1 = 'Register.Txt'
DocFile.2 = 'ReadMe'
DocFile.3 = 'Whats.New'
Docfile.4 = 'MiniMix.Doc'


/* Load REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialize */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installing ' Title
Say ''


/* Verify the existence of the component files. */

i = 1
Do until i > Pgmname.0
   Result = SysFileTree( Pgmname.i, 'Files', 'F' )
   If Files.0 = 0 Then
   Do
     Say 'ERROR:' Pgmname.i' not found!'
     Signal DONE
   End
   i = i + 1
End

i = 1
Do until i > Docfile.0
   Result = SysFileTree( DocFile.i, 'Files', 'F' )
   If Files.0 = 0 Then
   Do
     Say 'ERROR: 'DocFile.i' not found!'
     Signal DONE
   End
   i = i + 1
End


/* Find out where we are. */

curdir = directory()

/* Ask for the target directory name. */

Say 'Please enter the full name of the directory in which'
Say '  you want' Title' installed (default: 'curdir'): '
Pull InstDir
If InstDir = "" Then
   InstDir = curdir


/* Create the target directory if necessary. */

Result = SysFileTree(InstDir, 'Dirs', 'D')
If Dirs.0 = 0 Then
  Do
    Result = SysMkDir(InstDir)
    If Result = 0 Then
       Say 'Directory' InstDir ' was created...'
    Else
      Do
	Say 'ERROR: Unable to create target directory.'
	Signal DONE
      End
   End
Result =SysFileTree(InstDir"\ZAP", 'Dirs', 'D')
if Dirs.0 = 0 Then
    Do
    Result = SysMkDir(InstDir"\ZAP")
    If Result = 0 Then
      Say 'Directory 'InstDir'\ZAP was created...'
    Else
      Do
	Say 'ERROR: Unable to create target directory.'
	Signal DONE
      End
  End
Say ''


/* Perform the installation. */
Say 'Attaching icons ...'
x = SysSetIcon(Pgmname.1, "MM21.ICO")
i = 1
Do until i > DocFile.0
    x = SysSetIcon(DocFile.i, "DOC.Ico")
    i = i + 1
End
 
if InstDir <> curdir then
  Do

    i = 1
    Do until i > Pgmname.0
      Say 'Copying' Pgmname.i 'to' InstDir '...'
      Copy Pgmname.i  InstDir  '>NUL'
      i = i + 1
    End
    i = 1
    Do until i > DocFile.0
      Say 'Copying' DocFile.i 'to' InstDir '...'
      Copy DocFile.i  InstDir  '>NUL'      
      i = i + 1
    End
  End

Folder = '<MIXFold>'
Say 'Removing old Folder and Objects...'
Call SysDestroyObject(Folder)

Say 'Creating program folder...'

x = SysCreateObject("WPFolder",,
		    "MiniMixer 2.0",,
		    "<WP_DESKTOP>",,
		    "OBJECTID=<MIXFold>;ICONFILE="||InstDir||"\Folder.Ico",,
		    "replace")
If x <> 1 Then
  Do
    Say 'ERROR: Folder not created.'
    Signal DONE
  End

Say 'Creating program objects for MiniMixer 2.0 ...'
Type = 'WPProgram'
Parms = "EXENAME="InstDir"\MiniMix.Exe;STARTUPDIR="InstDir
x = SysCreateObject(Type,"MiniMixer",Folder,Parms,"replace")
If x <> 1 Then
   Do
     Say 'ERROR: Object not created.'
     Signal DONE
   End

Parms = "EXENAME="InstDir"\MiniMix.Exe;STARTUPDIR="InstDir"\ZAP"

x = SysCreateObject(Type,"Zapper^Setup",Folder,Parms,"replace")

If x <> 1 Then
   Do
     Say 'ERROR: Object not created.'
     Signal DONE
   End

Parms = "EXENAME="InstDir"\CMDLINE.EXE;STARTUPDIR="InstDir"\ZAP;PARAMETERS="InstDir"\zap\minimix.ini;MINIMIZED=YES"

x = SysCreateObject(Type,"Volume^Zapper",Folder,Parms,"replace")

If x <> 1 Then
   Do
     Say 'ERROR: Object not created.'
     Signal DONE
   End

i = 1
Do until i > DocFile.0
   Say 'Creating 'DocFile.i' object...'
   x = SysCreateObject("WPShadow",,
			DocFile.i,,
			Folder,,
			"SHADOWID="||InstDir||"\"DocFile.i";ICONFILE="||InstDir||"\DOC.Ico",,
			"replace")
   If x <> 1 Then
      Say 'ERROR: Shadow of 'DocFile.i' not created.'
   i = i + 1
End

ver = SysOS2Ver()
If ver > '2.11' Then
   Do
      i = 1
      Do until i > DocFile.0
          x = SysOpenObject(InstDir"\"DocFile.i,Default,0)
          i = i + 1
      End
   End

say 'Install completed.'
Signal DONE

FAILURE:
Say 'REXX failure.'
Signal DONE

HALT:
Say 'REXX halt.'
Signal DONE

SYNTAX:
Say 'REXX syntax error.'
Signal DONE

DONE:
Exit
