/* 

LBMix - A mixer for Crystal Semiconductor IOCTL90 by Lesha Bogdanow
Copyright (C) 1999-2000  Lesha Bogdanow

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#define MIN_CELLS_IN_LINE 1
#define DEF_CELLS_IN_LINE 8
#define MAX_CELLS_IN_LINE 16

#define EMPTY_W	90	// Window width/height when no controls are active
#define EMPTY_H	90

#define SLIDER_W_S 24	 	// slider width - standard
#define SLIDER_W_N640	8	 // slider width - narrow (640x480 and below)
#define SLIDER_W_N800	10	 // slider width - narrow (800x600)
#define SLIDER_W_N1024	12	 // slider width - narrow (1024x768)
#define SLIDER_W_N1152	14	 // slider width - narrow (1152x864)
#define SLIDER_W_N1280	16	 // slider width - narrow (1280x1024)
#define SLIDER_W_N1600	20	 // slider width - narrow (1600x1200 and above)
#define SLIDER_H_N 124   // slider height - normal (1600 - 124 min)
#define SLIDER_H_S 74    // slider height - short (1600 - 74 min)

#define BOX_W_O  0	// box minimal width = BOX_W_O + fontw*BOX_W_D/BOX_W_D + (text width)
#define BOX_W_M  1
#define BOX_W_D  1

#define LIST_W_O 20	// list width = LIST_W_O + LIST_W_M*fontw
#define LIST_W_M 12

#define CHECK_W_O  20   // checkbox width = CHECK_W_O + fontw*CHECK_W_M/CHECK_W_D + (text width)
#define CHECK_W_M  1
#define CHECK_W_D  4

#define DESC_W_O  4     // description width = DESC_W_O + fontw*DESC_W_M/DESC_W_D) + (text width)
#define DESC_W_M  0
#define DESC_W_D  3

#define CHECK_H_D  5	// checkbox/description height = max(CHECK_H_MIN,fonth*(1+1/CHECK_H_D)
#define CHECK_H_MIN 16

#define SPACE_X_O 0 // x spacing = SPACE_X_O + fontw/SPACE_X_D
#define SPACE_X_D 8 

#define SPACE_Y_O 2 // y spacing = SPACE_Y_O + fonth/SPACE_Y_D
#define SPACE_Y_D 10

#define CELLSP_X_O 0	// x cell spacing = CELLSP_X_O + fontw*CELLSP_X_M/CELLSP_X_D
#define CELLSP_X_M 0
#define CELLSP_X_D 1

#define CELLSP_Y_O 0	// y cell spacing = CELLSP_Y_O + fonth*CELLSP_Y_M/CELLSP_Y_D
#define CELLSP_Y_M 1
#define CELLSP_Y_D 3

#define FIELD_X_O 0 	// left/right fields = FIELD_X_O + fontw*FIELD_X_M/FIELD_X_D
#define FIELD_X_M 1
#define FIELD_X_D 2

#define FIELD_Y_O 0 	// top/bottom fields = FIELD_Y_O + fontw*FIELD_Y_M/FIELD_Y_D
#define FIELD_Y_M 1
#define FIELD_Y_D 2

#define INTER_X_O 2 	// interior left/right fields = INTER_X_O + fontw*INTER_X_M/INTER_X_D
#define INTER_X_M 1
#define INTER_X_D 1

#define INTER_T_O 0 	// interior top field = INTER_T_O + fonth*INTER_T_M/INTER_T_D
#define INTER_T_M 3
#define INTER_T_D 2

#define INTER_B_O 0 	// interior bottom field = INTER_B_O + fonth*INTER_B_M/INTER_B_D
#define INTER_B_M 1
#define INTER_B_D 4
