/* REXX */
/*
   A mini pipe mixer control REXX script (second edition) based on work of
   Lesha Bogdanow.
   Works at least with my cheap noname Crystal-PCI-CS4614 Sound-Card.
   Mix90.exe or 'lbmix -ps' or something like this has to run in background
   to be able to use this script.

   Usable keys: Cursor up/down left/right,
                Ctrl + Cursor up/down,
                Ctrl + Cursor left/right,
                TAB, Shift+TAB,
                SPACE, m, q.

   copyright:   >freeware< If you like this little script, find a bug
                or have a good idea to enhance it, you can send email to
                fbakan@gmx.net    Franz Bakan, 4. 5. 2000
*/

CALL RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
CALL SysLoadFuncs

ESC = "1B"x||"["
no  = ESC||"44;0;37m" /* normal */
bd  = ESC||"1m"       /* bold   */
reverse  = ESC||"7m"
muted    = reverse
red      = ESC||"31;1m" /* bold red */
selected = ESC||"44;37;1m"

pipe="\PIPE\MIXER"

controls = 5
lc = controls - 1  /* last control */
/*         Name      ; query-string    ; set-string */
ctrl.0.n = " Master" ; ctrl.0.q = "11" ; ctrl.0.set = "01"
ctrl.1.n = "  Mic  " ; ctrl.1.q = "62" ; ctrl.1.set = "42"
ctrl.2.n = "  Line " ; ctrl.2.q = "63" ; ctrl.2.set = "43"
ctrl.3.n = "   CD  " ; ctrl.3.q = "64" ; ctrl.3.set = "44"

/* increase number of controls and enter additional lines here. For example: */
/* ctrl.4.n = "  AUX  " ; ctrl.4.q = "66" ; ctrl.4.set = "46" */
/* see ioctl90.h or http://www.pompano.net/~joenord/ioctl90/ for details */

ctrl.lc.n = "  "||red||"Rec  " ; ctrl.lc.q = "6F" ; ctrl.lc.set = "4F"

idx = 2 /* Default to Line */
MODE controls*8 3
cls
CALL SysCurState(OFF)

/* query status */
DO i = 0 to controls-1
  CALL queryvolume i
  ctrl.i.atr = no /* text atribut */
  rc = SysCurPos(1,i*8)
  IF ctrl.i.s THEN DO
    IF ctrl.i.mute == 0 THEN SAY FORMAT(ctrl.i.left,3) FORMAT(ctrl.i.right,3)
    ELSE SAY muted||FORMAT(ctrl.i.left,3) FORMAT(ctrl.i.right,3)||no
    END
END

ctrl.idx.atr = selected
rc = SysCurPos(2,0)
rc = CHAROUT(, ' 'bd||'m'||no||'=toggle_mute ' bd||'q'||no||'=quit')

CALL output

DO FOREVER
  key=SysGetKey(NOECHO)
    SELECT
      WHEN key == "09"x THEN DO /* select source */
        ctrl.idx.atr = no
        idx = idx + 1
        IF idx == controls THEN idx = 0
        ctrl.idx.atr = selected
        CALL output
      END /* tab */

    WHEN (key == 'm' | key == ' ') & idx <> 0 THEN DO /* toggle mute */
      IF ctrl.idx.mute == 1 THEN ctrl.idx.mute = 0
      ELSE ctrl.idx.mute = 1
      CALL changevolume
    END /* m */

    WHEN key == 'q' THEN DO
      'mode 80 25'
      SAY no
      CLS
      EXIT(0)
    END /* q */

    WHEN key == "00"x | key == "E0"x THEN DO  /* Function Keys */
      key2 = SysGetKey(NOECHO)
      SELECT
        WHEN C2D(key2) == 15 | C2D(key2) == 75 THEN DO /* select source */
          ctrl.idx.atr = no
          idx = idx -1
          IF idx == -1 THEN idx = controls-1
          ctrl.idx.atr = selected
          CALL output
        END /* shift tab  cursor left */
 
        WHEN C2D(key2) == 77 THEN DO /* select source */
          ctrl.idx.atr = no
          idx = idx +1
          IF idx == controls THEN idx = 0
          ctrl.idx.atr = selected
          CALL output
        END /*  cursor right */

        WHEN C2D(key2) == 72 THEN DO /* Cursor up: increase volume */
          IF ctrl.idx.left < 100 THEN ctrl.idx.left = ctrl.idx.left + 1
          IF ctrl.idx.right < 100 THEN ctrl.idx.right = ctrl.idx.right + 1
          CALL changevolume
        END /* 72 */

        WHEN C2D(key2) == 141 THEN DO /* Cursor up: increase volume +10 */
          ctrl.idx.left = ctrl.idx.left + 10
          IF ctrl.idx.left > 100 THEN ctrl.idx.left = 100
          ctrl.idx.right = ctrl.idx.right + 10
          IF ctrl.idx.right > 100 THEN ctrl.idx.right = 100
          CALL changevolume
        END /* 141 */

        WHEN C2D(key2) == 80 THEN DO /* Cursor down: decrease volume */
          IF ctrl.idx.left > 0 THEN ctrl.idx.left = ctrl.idx.left - 1
          IF ctrl.idx.right > 0 THEN ctrl.idx.right = ctrl.idx.right - 1
          CALL changevolume
        END /* 80 */

        WHEN C2D(key2) == 145 THEN DO /* Cursor down: decrease volume -10 */
          ctrl.idx.left = ctrl.idx.left - 10
          IF ctrl.idx.left < 0 THEN ctrl.idx.left = 0
          ctrl.idx.right = ctrl.idx.right - 10
          IF ctrl.idx.right < 0 THEN ctrl.idx.right = 0
          CALL changevolume
        END /* 145 */

        WHEN C2D(key2) == 115 & idx <> 7 THEN DO /* Ctrl+Cursor left: balance to left */
          IF ctrl.idx.left < 100 THEN ctrl.idx.left = ctrl.idx.left +1
          IF ctrl.idx.right > 0 THEN ctrl.idx.right = ctrl.idx.right -1
          CALL changevolume
        END /* 75 */

        WHEN C2D(key2) == 116 & idx <> 7 THEN DO /* Ctrl+Cursor right: balance to right */
          IF ctrl.idx.left > 0 THEN ctrl.idx.left = ctrl.idx.left -1
          IF ctrl.idx.right < 100 THEN ctrl.idx.right = ctrl.idx.right +1
          CALL changevolume
        END /* 77 */

      otherwise
        nop     
      END /* select key2 */
    END /* function Key */

    otherwise
      nop
  END /* select key */
END

EXIT

topipe:
  IF STREAM(pipe,'c','OPEN') <> 'READY:' THEN DO
    SAY 'Unable to connect to pipe for write' pipe
    EXIT -1
  END
  IF lineout(pipe, dataout) <> 0 THEN DO
    SAY 'Unable to write to pipe' pipe
    EXIT -2
  END
  datain = ''
  DO ii=1 to 16
    data.ii = CHARIN(pipe)
  END
  IF STREAM(pipe,'c','CLOSE') <> 'READY:' THEN DO
    SAY 'Unable to close pipe' pipe
    EXIT -3
  END
  DO ii = 1 to 16
    datain = datain||data.ii
  END
  CALL SysSleep 0.01
RETURN

output:
  rc = SysCurPos(0,0)
  CALL SysCurState(OFF)
  DO i = 0 to controls - 1
    rc = CHAROUT(, ctrl.i.atr||ctrl.i.n||no||' ')
  END 
RETURN

changevolume:
  dataout = ctrl.idx.set ctrl.idx.left ctrl.idx.right ctrl.idx.mute
  rc = SysCurPos(1,idx*8)
  IF ctrl.idx.s THEN DO
    IF ctrl.idx.mute == 0 THEN SAY FORMAT(ctrl.idx.left,3) FORMAT(ctrl.idx.right,3)
                      ELSE SAY muted||FORMAT(ctrl.idx.left,3) FORMAT(ctrl.idx.right,3)||no
    END
  CALL topipe
RETURN

queryvolume:
  ARG idx
  dataout = ctrl.idx.q
  CALL topipe
  IF datain == "" THEN datain = "xx 50 50 0" /* in case query status fails */
  ctrl.idx.left = word(datain,2) /* volume left  */
  ctrl.idx.right = word(datain,3) /* volume right */
  ctrl.idx.mute = word(datain,4) /* mute         */
  IF datatype(ctrl.i.left)='NUM' THEN ctrl.i.s = 1 /* supported    */
  ELSE DO 
     ctrl.i.s     = 0 
     ctrl.i.left  = 0
     ctrl.i.right = 0
     ctrl.i.mute  = 0
  END
RETURN
