/* 

Pipe Mixer for IOCTL90 API by Lesha Bogdanow
Copyright (C) 1999-2000  Lesha Bogdanow

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#define USE_OS2_TOOLKIT_HEADERS
#define INCL_MCIOS2
#define INCL_OS2MM
#define INCL_DOSDEVICES

#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <os2.h>
#include <os2me.h>
#include <audio.h>

#include "call32.h"
#include "ioctl90.h"
#include "mixerapi.h"
#include "PipeMixPvt.h"

#define DEF_INFO_BUF_SIZE 128

const char szLogo[]="PipeMixer demon for IOCTL90 API. v.0.03";

unsigned char ApiMap[256];
MIXSTRUCT Master={0,100,100};
int MasterOn=FALSE;		// Enable master volume control

// Initialize mixer. Return TRUE if Ok
int MixerInit(int argc, char *argv[]) {
   int DriverInfo;
   MIXSTRUCT dummymix;
   MIXMSGBUF MixMsgBuf;
   ULONG Level;
   int i;


   for (i=1;i<argc;i++) {
     if (!stricmp(argv[i],"-d"))  {
        i++;
        if (i==argc) return FALSE;		// Syntax error
        strcpy(szPddName,"\\DEV\\");
        strncpy(szPddName+5,argv[i],8);
        strupr(szPddName);
        }
     else if (!stricmp(argv[i],"-mv")) MasterOn=TRUE;
     else return FALSE;				// Syntax error
     }

   if (mixerapiInit(NULL)) return FALSE;
   if (mixerapiIOCTL90(GETAPIMAP,ApiMap,256)) return FALSE;
   if (!mixerapiIOCTL90(APILEVELQUERY,&Level,sizeof(ULONG))) ApiLevel=Level;
   if (ApiMap[MSGBUF]) {
      MixMsgBuf.pBuffer=0;
      MixMsgBuf.ulSize=0;
      MixMsgBuf.fClear=FALSE;
      if (!mixerapiIOCTL90(MSGBUF,&MixMsgBuf,sizeof(MIXMSGBUF))) {
         InfoBufSize=MixMsgBuf.ulSize;
         InfoBuf=malloc(InfoBufSize);
         MixMsgBuf.pBuffer=(ULONG)InfoBuf;
         MixMsgBuf.ulSize=InfoBufSize;
         MixMsgBuf.fClear=FALSE;
         if (!mixerapiIOCTL90(MSGBUF,&MixMsgBuf,sizeof(MIXMSGBUF))) {
            DriverInfo=TRUE;
            }
         else free(InfoBuf);
         }
      }
   if (!DriverInfo) {
      InfoBufSize=DEF_INFO_BUF_SIZE;
      InfoBuf=malloc(InfoBufSize);
      strcpy(InfoBuf,"Driver does not return info.");
      strcat(InfoBuf,"\nAPI Level: ");
      _itoa(ApiLevel,InfoBuf+strlen(InfoBuf),10);
      }
   if (Debug) printf("Device: %s, API Level: %d\nDriver Info: \n%s\n",szPddName,
                     ApiLevel,InfoBuf);
   return TRUE;
   }

// Deinitialize mixer
void MixerClose() {
   mixerapiDeInit();
   }

// Set Master volume/balance (0-0x7FFF) by calling PDD IOCTL
static int MasterSetVB(unsigned short vol, unsigned short bal) {
   MCI_TRACK_INFO TrackInfo;
   MCI_AUDIO_CHANGE AudioChange;
   MCI_AUDIO_CONTROL AudioCtl;
   ULONG ulSize,ulRC;
   void * _Seg16 pul16;                   // defines a 16:16 pointer
   extern HFILE hDriver;

   TrackInfo.usMasterVolume=vol;
   TrackInfo.usDitherPct=0;		// ???
   TrackInfo.usMasterVolumeDelay=0;
   TrackInfo.usMasterBalance=bal;
   TrackInfo.usMasterBalanceDelay=0;
   pul16=(void * _Seg16)FlatToSel((unsigned long)(&TrackInfo));
   AudioChange.pvDevInfo=pul16;
   AudioChange.prMoreInputs=NULL;
   AudioChange.prMoreOutputs=NULL;
   AudioChange.pvModeInfo=NULL;
   AudioCtl.usIOCtlRequest=AUDIO_CHANGE;
   pul16=(void * _Seg16)FlatToSel((unsigned long)(&AudioChange));
   AudioCtl.pbRequestInfo=pul16;
   AudioCtl.ulPosition=0;

   ulSize=sizeof(AudioCtl);
   ulRC = DosDevIOCtl(hDriver,AUDIO_IOCTL_CAT,AUDIO_CONTROL,
                         NULL,0,NULL,&AudioCtl,ulSize,&ulSize);
   return ulRC;
   }

// Calculate value for master volume/balance
static unsigned short MasterVal(int v) {
   unsigned short rc;

   if (v<0) v=0;
   rc=(v<<15)/100;
   if (rc>0x7FFF) rc=0x7FFF;
   return rc;
   }

// Set Master volume by calling PDD IOCTL
static int MasterSet(MIXSTRUCT *MixStruct) {
   int v,b;

   if (MixStruct->VolumeL>MixStruct->VolumeR) v=MixStruct->VolumeL;
   else v=MixStruct->VolumeR;
   b=(100+MixStruct->VolumeL-MixStruct->VolumeR)/2;	// Balance
   return MasterSetVB(MasterVal(v),MasterVal(b));
   }

/* Process a command. Buff is an output buffer, the function number and
   a trailing space are already there. tokens - number of command tokens
   cmd - command, p1, p2, p3 - parameters. If some of them are not specified
   then default values (p1=100, p2=p1, p3=0) are supplied
*/
int ProcessCmd(char *Buff, int tokens, int cmd, int p1, int p2, int p3) {
   MIXSTRUCT MixStruct;

   if ((cmd==0x01)&&MasterOn) {			// Master set
      Master.VolumeL=p1;
      Master.VolumeR=p2;
      if (!MasterSet(&Master)) {
         strcat(Buff,REP_OK);
         }
      else strcat(Buff,REP_FAILED);
      }
   else if ((cmd==0x11)&&MasterOn)		// Master query
      sprintf(Buff+strlen(Buff),"%d %d %x",Master.VolumeL,Master.VolumeR,Master.Mute);
   else if (ApiMap[cmd]&&((cmd&0xF0)==0x40)) {	// Set command
      MixStruct.VolumeL=p1;
      MixStruct.VolumeR=p2;
      MixStruct.Mute=p3;
      if (!mixerapiIOCTL90(cmd,&MixStruct,sizeof(MIXSTRUCT))) {
         strcat(Buff,REP_OK);
         }
      else strcat(Buff,REP_FAILED);
      }
   else if (ApiMap[cmd]&&((cmd&0xF0)==0x60)) {	// Query command
      if (!mixerapiIOCTL90(cmd,&MixStruct,sizeof(MIXSTRUCT))) {
         sprintf(Buff+strlen(Buff),"%d %d %x",MixStruct.VolumeL,MixStruct.VolumeR,MixStruct.Mute);
         }
      else strcat(Buff,REP_FAILED);
      }
   else strcat(Buff,REP_UNSUPPORTED);
   return TRUE;
   }
