/* A sample pipe mixer control REXX script by Lesha Bogdanow */

pipe="\PIPE\MIXER"
REP_UNSUPPORTED="UNSUPPORTED"
REP_OK="OK"
REP_FAILED="FAILED"

call RxFuncAdd 'SysSleep','RexxUtil','SysSleep'

call Help
do until left(word(data,1),1)='Q'
   call charout ,':'
   PULL data
   data=translate(data)
   if left(word(data,1),1)='?' then call Help
   else if left(word(data,1),1)='F' then do	/* Supported functions */
      say "             Supported functions:"
      say
      say " 80 - Query API level      83 - Get message buffer"
      say
      data='11'
      call Cmd
      call SysSleep 0.05
      if datatype(word(data,2))='NUM' then
         say ' 01 - Set Master volume    11 - Query Master volume'
      do i=0 to 15
         data='6'd2x(i)
         call Cmd
         call SysSleep 0.05
         if datatype(word(data,2))='NUM' then do 
            select 
               when i=0 then  dsc='MonoIn     '
               when i=1 then  dsc='Phone      '
               when i=2 then  dsc='Mic        '
               when i=3 then  dsc='Line       '
               when i=4 then  dsc='CD         '
               when i=5 then  dsc='Video      '
               when i=6 then  dsc='Aux        '
               when i=11 then dsc='Tone       '
               when i=12 then dsc='3D         '
               when i=13 then dsc='DAC Volume '
               when i=14 then dsc='Record src '
               when i=15 then dsc='Record gain'
               otherwise
                              dsc='Unknown ctl'
               end
            say ' 4'd2x(i) '- Set' dsc '     6'd2x(i) '- Query' dsc
            end
         end
      end
   else if left(word(data,1),1)<>'Q' then do	/* Mixer command */
      cmd=word(data,1)
      if (datatype(cmd,X)=0)|(length(cmd)<>2) then say "Invalid command."
      else do
         call Cmd
         odata=''
         EOL=''
         do i=1 to length(data)
            c=substr(data,i,1)
            if (EOL='')&((c=D2C(13))|(c=D2C(10))) then EOL=c
            if (EOL<>'')&(c=EOL) then do
               say odata
               odata=''
               end
            else if (C2D(c)>=32)|(c=D2C(9)) then odata=insert(odata,c)
            end
         if (word(odata,1)<>'') then say odata
         end
      end
   end
exit
Help:
   say "Sample REXX Pipe Mixer control script."
   say "? - help, q - quit, f - list supported functions"
   say "<fn> [par1 [par2 [par3]]] - call mixer function"
   return
Cmd:
   if stream(pipe,'c','open')<>'READY:' then do
      say 'Unable to connect to pipe' pipe
      exit
      end
   call lineout pipe,data
   data=charin(pipe,,2047)
   call stream pipe,'c','close'
   return
