#	whereis.csh, Release 2.2
# 	Copyright (c) 1988-1991 by Hamilton Laboratories.  All rights reserved.

#	Look through the directories on the search path for any files corresponding
#	to the command name given, reporting anything that's found.  If no .ext
#	file type extension is given as part of the name, try each of the four
#	possibilities, .csh, .exe, .com and .cmd, in each directory.

#	This is an example of a self-loading procedure.  The first time
#	it is referenced, it runs as a .csh script, defining and running
#	the whereis proc.  Successive calls directly invoke the pre-compiled
#	procedure and will run slightly faster. (View this file with TABS=3.)

proc whereis(name)
	local i, j
	if (name =~ "*.*") then
		foreach i ($path)
			if (i =~ "*\") then
				if (-e $i$name) echo $i$name
			else
				if (-e $i\$name) echo $i\$name
			end
		end
	else
		if (os2version >= 2.0) then
			foreach i ($path)
				if (i =~ "*\") then
					foreach j (.csh .exe .com .cmd .bat)
						if (-e $i$name$j) echo $i$name$j
					end
				else
					foreach j (.csh .exe .com .cmd .bat)
						if (-e $i\$name$j) echo $i\$name$j
					end
				end
			end
		else
			foreach i ($path)
				if (i =~ "*\") then
					foreach j (.csh .exe .com .cmd)
						if (-e $i$name$j) echo $i$name$j
					end
				else
					foreach j (.csh .exe .com .cmd)
						if (-e $i\$name$j) echo $i\$name$j
					end
				end
			end
		end
	end
end

whereis $argv
