#!/bin/sh -
#
# bashbug - create a bug report and mail it to the bug address
#
# The bug address depends on the release status of the shell.  Versions
# with status `alpha' or `beta' mail bug reports to chet@po.cwru.edu.
# Other versions send mail to bug-bash@prep.ai.mit.edu.
#
# configuration section:
#	these variables are filled in by the make target in cpp-Makefile
#
MACHINE="i386"
OS="os2"
CC="gcc"
CFLAGS=" -DPROGRAM='bash' -DHOSTTYPE='i386' -DOSTYPE='os2' -DMACHTYPE='i386-ibm-os2' -DSHELL -DHAVE_CONFIG_H   -I. -I. -I./lib -Isupport/i386-ibm-os2 -g -O2"
RELEASE="2.0"
PATCHLEVEL="0"
RELSTATUS="release"
MACHTYPE="i386-ibm-os2"

PATH=/bin:/usr/bin:/usr/local/bin:$PATH
export PATH

TEMP=/tmp/bashbug.$$

case "$RELSTATUS" in
alpha*|beta*)	BUGBASH=chet@po.cwru.edu ;;
*)		BUGBASH=bug-bash@prep.ai.mit.edu ;;
esac

BUGADDR=${1-$BUGBASH}

: ${EDITOR=emacs}

: ${USER=${LOGNAME-`whoami`}}

trap 'rm -f $TEMP $TEMP.x; exit 1' 1 2 3 13 15
trap 'rm -f $TEMP $TEMP.x' 0

UN=
if (uname) >/dev/null 2>&1; then
	UN=`uname -a`
fi

if [ -f /usr/lib/sendmail ] ; then
	RMAIL="/usr/lib/sendmail"
elif [ -f /usr/sbin/sendmail ] ; then
	RMAIL="/usr/sbin/sendmail"
else
	RMAIL=rmail
fi

cat > $TEMP <<EOF
From: ${USER}
To: ${BUGADDR}
Subject: [50 character or so descriptive subject here (for reference)]

Configuration Information [Automatically generated, do not change]:
Machine: $MACHINE
OS: $OS
Compiler: $CC
Compilation CFLAGS: $CFLAGS
uname output: $UN
Machine Type: $MACHTYPE

Bash Version: $RELEASE
Patch Level: $PATCHLEVEL
Release Status: $RELSTATUS

Description:
	[Detailed description of the problem, suggestion, or complaint.]

Repeat-By:
	[Describe the sequence of events that causes the problem
	to occur.]

Fix:
	[Description of how to fix the problem.  If you don't know a
	fix for the problem, don't include this section.]
EOF

chmod u+w $TEMP
cp $TEMP $TEMP.x

# Figure out how to echo a string without a trailing newline
N=`echo 'hi there\c'`
case "$N" in
*c)	n=-n c= ;;
*)	n= c='\c' ;;
esac

trap '' 2		# ignore interrupts while in editor

until $EDITOR $TEMP; do
	echo "$0: editor \`$EDITOR' exited with nonzero status."
	echo "$0: Perhaps it was interrupted."
	echo "$0: Type `y' to give up, and lose your bug report;"
	echo "$0: type `n' to re-enter the editor."
	echo $n "$0: Do you want to give up? $c"

	read ans
	case "$ans" in
	Yy]*) exit 1 ;;
	esac
done

trap 'rm -f $TEMP $TEMP.x; exit 1' 2	# restore trap on SIGINT

if cmp -s $TEMP $TEMP.x
then
	echo "File not changed, no bug report submitted."
	exit
fi

${RMAIL} $BUGADDR < $TEMP || {
	cat $TEMP >> $HOME/dead.bashbug
	echo "$0: mail failed: report saved in $HOME/dead.bashbug" >&2
}

exit 0
