#! /bin/sh
#
# psize.sh -- determine this system's pipe size, and write a define to
#             pipesize.h so ulimit.c can use it.

echo "/*"
echo " * pipesize.h"
echo " *"
echo " * This file is automatically generated by psize.sh"
echo " * Do not edit!"
echo " */"
echo ""

./psizeaux 2>/tmp/pipesize | sleep 3

if [ -s /tmp/pipesize ]; then
	echo "#define PIPESIZE `cat /tmp/pipesize`"
else
	echo "#define PIPESIZE 512"
fi

rm -f /tmp/pipesize

exit 0
