/* Package of proceedures which are most likely to require 
   modification in case the object system is changed
*/
#define INCL_DOSFILEMGR
#define INCL_BASE
#include <os2.h>
#include "os2getch.h"

static KBDINFO		initialStatus;
static KBDINFO		newStatus;
static int			rd_ahead;
static int			screen_row,
					screen_col;

/* *************************** CH_RET ****************************** */
/* Return a character to the input queue */

void		ch_ret(ch)
int			ch;
{
rd_ahead = ch;
return;
}

/* *************************** RD_NO  ****************************** */

/* read a character from the keyboard without wait.  Returns the
   pending character or zero.  On the IBM PC extended characters
   have bit zero of the high order bit set.
*/
int		rd_no()
{int		ret_val;
KBDKEYINFO inRecord;

if(rd_ahead != 0)
	{ret_val = rd_ahead;
	rd_ahead = 0;
	return(ret_val);
	}
KbdPeek(&inRecord, 0);
if(!inRecord.fbStatus)
	return(0);
return(rd_wait());
/*
if(kbhit() == 0)	return(0);
return(rd_wait());
*/
}

/* *************************** RD_WAIT ***************************** */

/* read a character from the keyboard with wait.  Treatment of extended
   characters is the same as read_no().
*/
int		rd_wait()
{
KBDKEYINFO		keyBuffer;
int				r_val;

if(rd_ahead != 0)
	{r_val = rd_ahead;
	rd_ahead = 0;
	return(r_val);
	}
KbdCharIn(&keyBuffer, 0, 0);
r_val = keyBuffer.chChar? keyBuffer.chChar: keyBuffer.chScan+0x100;
if(!(r_val &0x100))
	return r_val;
/* we have a special key.  Map this key into a predefined set of keys
*/
switch(r_val)
	{
case CHAR_LEFT:
	return 2;
case START_SCREEN:
	return 1;
case DEL_CURSOR:
	return 4;
case END_SCREEN:
	return 5;
case CHAR_RIGHT:
	return 6;
case LINE_DOWN:
	return 14;
case LINE_UP:
	return 16;
case 0x177:					/* ^Home - reverse-search-history */
	return 18;
case 0x175:					/* ^End - forward-search-history */
	return 19;
/* the following functions are bound to an escape sequence.  Push
   the second keystroke onto the stack and return ESCAPE
*/
case 0x173:					/* *<- - backward word */
	rd_ahead = 'b';
	break;
case PAGE_UP:				/* beginning-if-history */
	rd_ahead = '<';
	break;
case PAGE_DOWN:				/* end-of-history */
	rd_ahead = '>';
	break;
case 0x174:					/* ^-> - forward-word */
	rd_ahead = 'f';
	break;
case 0x17f:
	rd_ahead = 'd';
	break;
default:
	return(r_val & 0xff);
	}
return ESCAPE_KEY;
}

/* ************************** TR_INIT ******************************** */
void		tr_init(row, col)
int			*row,
			*col;
{VIOMODEINFO	vInfo;

initialStatus.cb = sizeof(KBDINFO);
newStatus.cb = sizeof(KBDINFO);
KbdGetStatus(&initialStatus, 0);
KbdGetStatus(&newStatus, 0);
newStatus.fsMask &= 0xf7;		/* mask out ANSI mode */
newStatus.fsMask |= 0x4;		/* set binary mode */
KbdSetStatus(&newStatus, 0);
vInfo.cb = sizeof(vInfo);
VioGetMode(&vInfo, 0);
screen_row = vInfo.row;
screen_col = vInfo.col;
*row = screen_row;
*col = screen_col-1;
return;
}
/* ************************** TR_REST ******************************** */
void		tr_rest()
{
KbdSetStatus(&initialStatus, 0);
return;
}
