/* sys/spawnve.c (emx+gcc) -- Copyright (c) 1992-1993 by Eberhard Mattes */

#define INCL_DOSPROCESS

#include <sys/emx.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <errno.h>
#include <os2emx.h>
#include "syscalls.h"
#include <stdio.h>

#if defined(__DEBUG__)
extern FILE		*debugFile;
#define DEBUG_OUT writeDebugInfo
#else
#define DEBUG_OUT
#endif

char	*findExecutable(char *, int *);

#define ADD(n)  \
  while (arg_size + n > arg_alloc) \
    { \
      arg_alloc += 512; \
      arg_buf = realloc (arg_buf, arg_alloc); \
      if (arg_buf == NULL) \
        { \
          errno = ENOMEM; \
          return (-1); \
        } \
      arg_ptr = arg_buf + arg_size; \
    } \
arg_size += n;				/* 10/93 ROB */

int __spawnve (struct _new_proc *np)
{
  ULONG rc;
  ULONG exec_flag;
  RESULTCODES res;
  char obj[40], *arg_ptr, *arg_buf;
  char *pgm_name;
  const char *src;
  size_t arg_size, arg_alloc, len;
  int i, quote, bs, pid;

  arg_buf = NULL; arg_alloc = 0; arg_size = 0; arg_ptr = NULL;
  switch (np->mode & 0xff)
    {
    case P_WAIT:
      exec_flag = EXEC_SYNC;
      break;
    case P_NOWAIT:
      exec_flag = EXEC_ASYNCRESULT;
      break;
    case P_OVERLAY:
      exec_flag = EXEC_ASYNC;
		exec_flag = EXEC_ASYNCRESULT;
      break;
    default:
      errno = EINVAL;
      return (-1);
    }
arg_buf = findExecutable( (char *)np->fname_off, &arg_alloc);
if(arg_buf == NULL)
	return -1;
arg_size = arg_alloc;
arg_ptr = arg_buf + arg_size;
pgm_name = alloca(strlen(arg_buf)+1);
  strcpy (pgm_name, (const char *)arg_buf);
  src = (const char *)np->arg_off;
  if (np->arg_count > 0)
    {
      ++src;                    /* skip flags byte */
      len = strlen (src) + 1;
#if 0							/* 10/93 ROB */
      ADD (len);
      memcpy (arg_ptr, src, len);
      arg_ptr += len; 
#endif
	src += len;
    }
  for (i = 1; i < np->arg_count; ++i)
    {
      if (i > 1)
        {
          ADD (1);
          *arg_ptr++ = ' ';
        }
      ++src;                    /* skip flags byte */
      quote = (*src == 0 || strpbrk (src, " \t") != NULL);
      if (quote)
        {
          ADD (1);
          *arg_ptr++ = '"';
        }
      bs = 0;
      while (*src != 0)
        {
          if (*src == '"')
            {
              ++bs;
              ADD (bs);
              memset (arg_ptr, '\\', bs);
              bs = 0;
            }
          else if (*src == '\\')
            ++bs;
          else
            bs = 0;
          ADD (1);
          *arg_ptr++ = *src;
          ++src;
        }
      if (quote)
        {
          ADD (1+bs);
          memset (arg_ptr, '\\', bs);
          arg_ptr += bs;
          *arg_ptr++ = '"';
        }
      ++src;
    }
  ADD (1);
  *arg_ptr++ = 0;
#if defined(__DEBUG__)
fseek(debugFile, 0, SEEK_END);
DEBUG_OUT("spawnve: %s-mode=%d, oldPid=%d, ", pgm_name, np->mode, getpid());
#endif
  rc = DosExecPgm (obj, sizeof (obj), exec_flag, arg_buf,
                   (const char *)np->env_off, &res, pgm_name);
  if (arg_buf != NULL)
    free (arg_buf);
#if defined(__DEBUG__)
fseek(debugFile, 0, SEEK_END);
DEBUG_OUT("new pid=%d\n", res.codeTerminate);
#endif
  if (rc != 0)
    {
      _sys_set_errno (rc);
      return (-1);
    }
  switch (np->mode & 0xff)
    {
    case P_WAIT:
	/* these modifications allow spawn to always return the pid of the
	   spawned process, thereby giving a consistent interface to the
	   procedure */
	pid = res.codeTerminate;
/*		rc = DosWaitChild(DCWA_PROCESS, DCWW_WAIT, &res, &i,
			 res.codeTerminate);
*/
	return pid;
      return (res.codeResult);
    case P_NOWAIT:
      return (res.codeTerminate);
    case P_OVERLAY:
		rc = DosWaitChild(DCWA_PROCESS, DCWW_WAIT, &res, &i,
			 res.codeTerminate);
      while (1)
        DosExit (EXIT_PROCESS, (int)res.codeResult);
    default:
      errno = EINVAL;
      return (-1);
    }
}
