/* command.c, created from command.def. */
#line 23 "(null)command.def"

#line 32 "(null)command.def"

#include "../shell.h"

static void restore_path ();
static char *get_standard_path ();

/* Run the commands mentioned in LIST without paying attention to shell
   functions. */
int
command_builtin (list)
     WORD_LIST *list;
{
  int result;
  int use_standard_path = 0;
  char *old_path;

  while (list)
    {
      if (strcmp (list->word->word, "-p") == 0)
	{
	  use_standard_path = 1;
	  list = list->next;
	}
      else if (strcmp (list->word->word, "--") == 0)
	{
	  list = list->next;
	  break;
	}
      else if (*list->word->word == '-')
	{
	  bad_option (list->word->word);
	  return (EXECUTION_FAILURE);
	}
      else
	break;
    }

  if (!list)
    return (EXECUTION_SUCCESS);

  begin_unwind_frame ("command_builtin");

  /* We don't want this to be reparsed (consider command echo 'foo &'), so
     just make a simple_command structure and call execute_command with it. */
  {
    COMMAND *command;
    extern COMMAND *make_bare_simple_command ();
    extern WORD_LIST *copy_word_list ();
    extern void dispose_command ();

    if (use_standard_path)
      {
	char *standard_path;

	old_path = get_string_value ("PATH");
	if (old_path)
	  old_path = savestring (old_path);
	else
	  old_path = savestring ("");
	add_unwind_protect ((Function *)restore_path, old_path);

	standard_path = get_standard_path ();
	bind_variable ("PATH", standard_path);
	free (standard_path);
      }
    command = make_bare_simple_command ();
    command->value.Simple->words = (WORD_LIST *)copy_word_list (list);
    command->value.Simple->redirects = (REDIRECT *)NULL;
    command->flags |= (CMD_NO_FUNCTIONS | CMD_INHIBIT_EXPANSION);
    command->value.Simple->flags |= (CMD_NO_FUNCTIONS | CMD_INHIBIT_EXPANSION);
    add_unwind_protect ((char *)dispose_command, command);
    result = execute_command (command);
  }

  run_unwind_frame ("command_builtin");

  return (result);
}

/* Restore the value of the $PATH variable after replacing it when
   executing `command -p'. */
static void
restore_path (var)
     char *var;
{
  bind_variable ("PATH", var);
  free (var);
}

/* Return a value for PATH that is guaranteed to find all of the standard
   utilities.  This uses Posix.2 configuration variables, if present.  It
   uses a value defined in config.h as a last resort. */
static char *
get_standard_path ()
{
#if defined (_CS_PATH) && !defined (HPUX_70)
  char *p;
  size_t len;

  len = (long) confstr (_CS_PATH, (char *)NULL, (size_t)0);
  p = xmalloc ((int)len + 2);
  (void) confstr (_CS_PATH, p, len);
  return (p);
#else /* !_CSPATH || HPUX_70 */
#  if defined (CS_PATH)
  return (savestring (CS_PATH));
#  else
  return (savestring (STANDARD_UTILS_PATH));
#  endif /* !CS_PATH */
#endif /* !_CS_PATH || HPUX_70 */
}
