/*
 * main.c -- Sample mainline showing how to call a REXX macro.
 *
 */

#define INCL_DOS

#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "subcom.h"

static void Usage( char *argv[] );

/*
 * main -- Main entry point.  First argument is the name of the
 *         macro file to run.
 */

int main( int argc, char *argv[] )
  {
    PSZ  argstring = NULL;
    PPIB pib;
    PTIB tib;

    /* Need at least one argument! */

    if( argc < 2 ){
        Usage( argv );
    }

    /* Register the handlers before running the macro... */

    RegisterREXXHandlers();

    /* Get the argument string... because we're running the macro as
       a command we only pass it a single argument, so we need to look
       up the real command line stored in the process information
       block */

    if( argc > 2 ){
        DosGetInfoBlocks( &tib, &pib );

        argstring = pib->pib_pchcmd;

        /* Skip over command name and then the filename... */

        while( *argstring != '\0' ) ++argstring;
        ++argstring;

        while( isspace( *argstring ) ) ++argstring;
        while( *argstring != '\0' && !isspace( *argstring ) ) ++argstring;
        while( isspace( *argstring ) ) ++argstring;
    }

    /* Now run the macro... */

    RunMacro( argv[1], argstring, ( argstring ? strlen( argstring ) : 0 ),
              "TEST" );

    DeregisterREXXHandlers();

    return( 0 );
  }

/*
 * Usage
 */

static void Usage( char *argv[] )
  {
    printf( "Usage: %s macro [args...]\n", argv[0] );

    exit( -1 );
  }

