/*
 * llist.c -- Generic linked-list package
 */

#include <stddef.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#define EXTERN
#include "llist.h"

/*
 * LListNew -- Start a new list.
 */

void LListNew( llist_header_p top )
  {
    top->first = NULL;
    top->last  = NULL;
  }

/*
 * LListPrefix -- Add an entry to the start of a list.
 */

void LListPrefix( llist_header_p top, void *entry )
  {
    ((llist_link_p) entry)->prev = NULL;
    ((llist_link_p) entry)->next = top->first;

    if( top->first )
        top->first->prev = (llist_link_p) entry;

    top->first = (llist_link_p) entry;

    if( !top->last )
        top->last = (llist_link_p) entry;
  }

/*
 * LListSuffix -- Add an entry to the end of a list.
 */

void LListSuffix( llist_header_p top, void *entry )
  {
    ((llist_link_p) entry)->prev = top->last;
    ((llist_link_p) entry)->next = NULL;

    if( top->last )
        top->last->next = (llist_link_p) entry;

    top->last = (llist_link_p) entry;

    if( !top->first )
        top->first = (llist_link_p) entry;
  }

/*
 * LListDelete -- Remove an entry from the list.  Returns the entry.
 */

void *LListDelete( llist_header_p top, void *entry )
  {
    if( !entry )
        return( NULL );

    if( ((llist_link_p) entry)->next )
        ((llist_link_p) entry)->next->prev = ((llist_link_p) entry)->prev;

    if( ((llist_link_p) entry)->prev )
        ((llist_link_p) entry)->prev->next = ((llist_link_p) entry)->next;

    if( entry == (void *) top->first )
        top->first = ((llist_link_p) entry)->next;

    if( entry == (void *) top->last )
        top->last = ((llist_link_p) entry)->prev;

    ((llist_link_p) entry)->next = NULL;
    ((llist_link_p) entry)->prev = NULL;

    return( (void *) entry );
  }

/*
 * LListInsert -- Insert an entry into a list.
 */

void LListInsert( llist_header_p top, void *next, void *entry )
  {
    if( top->first == NULL || top->first == next )
        LListPrefix( top, entry );
    else if( next == NULL )
        LListSuffix( top, entry );
    else
      {
        ((llist_link_p) entry)->prev       = ((llist_link_p) next)->prev;
        ((llist_link_p) entry)->next       = (llist_link_p) next;

        ((llist_link_p) next)->prev->next  = (llist_link_p) entry;
        ((llist_link_p) next)->prev        = (llist_link_p) entry;
      }
  }

/*
 * LListKill -- Remove an entire list.
 */

void LListKill( llist_header_p top, void (*fn_free)( void * ) )
  {
    llist_link_p curr, next;

    for( curr = top->first; curr != NULL; curr = next )
      {
        next = curr->next;
        (*fn_free)( (void *) curr );
      }

    LListNew( top );
  }
