/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
        call VROptions 'NoEchoQuit'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         DC_1_ClientListen
*/
DC_1_ClientListen: 
    hConn = VRInfo( "DAHandle");
    Listen = VRInfo( "Start");
    if Listen then
        str = hconn "Starts listening"
    else
        str = hconn "Stops listening"
    position = VRMethod( "LB_1", "AddString", str,  )
    ok = VRMethod( "DC_1", "SendData", "0", "Hello there, how are you?", 0, hconn, 0, 0);
return

/*:VRX         DC_1_Connect
*/
DC_1_Connect: 
    hconn = VRInfo( "DAHandle");
    str = hconn "connected"
    position = VRMethod( "LB_1", "AddString", str,  )
    ok = VRMethod( "DC_1", "SendData", "0", "Hello there, how are you?", 0, hconn, 0, 0);
return

/*:VRX         DC_1_CSError
*/
DC_1_CSError: 
    hconn = VRInfo( "DAHandle");
    errno = VRInfo( "ErrNum");
    errsev = VRInfo( "ErrSev");
    errstr = VRInfo( "ErrMsg");
    str = hconn "error" errno '('errsev')' errstr
    position = VRMethod( "LB_1", "AddString", str,  )

return

/*:VRX         DC_1_DataReady
*/
DC_1_DataReady: 
    hconn = VRInfo( "DAHandle");
    rspid = VRInfo( "RespID");
    com = VRInfo( "CmdID");
    dta = VRInfo( "Data");
    str = hconn 'sent ('com 'id' rspid')' dta
    if com = 'STOP_LISTEN' then
        msg = 'OK, bye for now...'
    else
        msg = "I got your message" rspid
    ok = VRMethod( "DC_1", "SendData", com, msg, rspid, hconn, 0, 0);
    position = VRMethod( "LB_1", "AddString", str,  )
return

/*:VRX         DC_1_Disconnect
*/
DC_1_Disconnect: 
    hconn = VRInfo( "DAHandle");
    str = hconn "disconnected"
    position = VRMethod( "LB_1", "AddString", str,  )
return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         idm_close_Click
*/
idm_close_Click: 
    selectedstring = VRGet( "LB_1", "SelectedString" )
    if selectedstring = '' then
        return;
    hConn = word( selectedstring, 1)
    ok = VRMethod( "DC_1", "StopListen", hConn);
return

/*:VRX         idm_conn_Click
*/
idm_conn_Click: 
    selectedstring = VRGet( "LB_1", "SelectedString" )
    if selectedstring = '' then
        return;
    hConn = word( selectedstring, 1)
    ok = VRMethod( "DC_1", "CloseConnection", hConn);
return

/*:VRX         idm_details_Click
*/
idm_details_Click: 
    selectedstring = VRGet( "LB_1", "SelectedString" )
    if selectedstring = '' then
        return;
    hConn = word( selectedstring, 1)
    ok = VRMethod( "DC_1", "GetClientData", hConn, "ConnData.");
    if ok then do
        msg.0 = 3
        msg.1 = 'Client Handle =' hConn
        if ConnData.2 then
            msg.2 = 'Client is listening'
        else
            msg.2 = 'Client is not listening'
        msg.3 = ConnData.3

        id = VRMessageStem( VRWindow(), "msg.", "Client Connection Details", "None", , ,  )
    end
return

/*:VRX         idm_message_Click
*/
idm_message_Click: 
    selectedstring = VRGet( "LB_1", "SelectedString" )
    if selectedstring = '' then
        return;
    hConn = word( selectedstring, 1)
    window = VRLoadSecondary( "SW_1", "W" )
return

/*:VRX         Init
*/
Init:
/*    call VRRedirectStdIO 'off'
*/
    window = VRWindow()
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         LB_1_ContextMenu
*/
LB_1_ContextMenu: 
    ok = VRMethod( "Menu1", "Popup", , , "", "" )
return

/*:VRX         LB_1_DoubleClick
*/
LB_1_DoubleClick: 
    selectedstring = VRGet( "LB_1", "SelectedString" )
    if selectedstring <> '' then do
        hConn = word( selectedstring, 1)
        ok = VRMethod( "DC_1", "SendData", "0", "Hi there" hConn, 0, hConn, 0, 0);
    end
return

/*:VRX         PB_1_Click
*/
PB_1_Click: 
    value = VRGet( "EF_1", "Value" )
    ok = VRMethod( "DC_1", "SendData", ASYNCH, value, 0, hConn, 0, 0 );
    call SW_1_Close
return

/*:VRX         PB_2_Click
*/
PB_2_Click: 
    call SW_1_Close
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         SW_1_Close
*/
SW_1_Close: 
    call SW_1_Fini
return

/*:VRX         SW_1_Create
*/
SW_1_Create: 
    call SW_1_Init
return

/*:VRX         SW_1_Fini
*/
SW_1_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_1_Init
*/
SW_1_Init: 
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

/*:VRX         Window1_KeyPress
*/
Window1_KeyPress: 
    key = VRGet( "Window1", "keyString");
    if key = '{Del}' then
        ok = VRMethod( "LB_1", "Clear" )
return

