/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
        call VROptions 'NoEchoQuit'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         DC_1_ClientListen
*/
DC_1_ClientListen: 
    ok = VRSet( "EF_2", "Value", "Server stops listen thread" )
    ok = VRSet( "PB_3", "Enabled", 1 )
    ok = VRSet( "PB_2", "Enabled", 0 )
return

/*:VRX         DC_1_CSError
*/
DC_1_CSError: 
    dah = VRInfo( "DAHandle");
    ErrNo = VRInfo( "ErrNum");
    ErrSev = VRInfo( "ErrSev");
    ErrMsg = VRInfo( "ErrMsg");
    call VRMethod "DC_1", "ErrorMessage"    
return

/*:VRX         DC_1_DataReady
*/
DC_1_DataReady: 
    hConn = VRInfo( "DAHandle");
    CmdID = VRInfo( "CmdID");
    RespID = VRInfo( "RespID");
    Data = VRInfo( "Data");
    ok = VRSet( "EF_2", "Value", data )
    if CmdID = "STOP_LISTEN" then do
        ok = VRSet( "PB_3", "Enabled", 1 )
        ok = VRSet( "PB_2", "Enabled", 0 )
    end
return

/*:VRX         DC_1_Disconnect
*/
DC_1_Disconnect: 
    call VRSet "PB_4", "Caption", "Connect..."
    ok = VRSet( "PB_2", "Enabled", 1 )
    ok = VRSet( "PB_3", "Enabled", 0 )
    ok = VRSet( "EF_2", "Value", "Server closed connection" )
return

/*:VRX         dumpvars
*/
dumpvars: 
say '9020 VRXDA_INVALID_HANDLE' VRXDA_INVALID_HANDLE
say '9024 VRXDA_ERROR_NAME' VRXDA_ERROR_NAME
say '1411 VRXDA_ALREADY_IDENTIFIED' VRXDA_ALREADY_IDENTIFIED
say '1418 VRXDA_OPEN_TIMED_OUT' VRXDA_OPEN_TIMED_OUT
say '1419 VRXDA_CLOSED_MAY_REUSE' VRXDA_CLOSED_MAY_REUSE
say '1420 VRXDA_INVALID_REUSE' VRXDA_INVALID_REUSE
say '1421 VRXDA_STATE_CHECK' VRXDA_STATE_CHECK
say '2023 VRXDA_MOD_LOAD_FAILED' VRXDA_MOD_LOAD_FAILED
say '2024 VRXDA_ERR_ENTRY_POINT' VRXDA_ERR_ENTRY_POINT
say '2025 VRXDA_ERR_START_PARTNER' VRXDA_ERR_START_PARTNER
say '2027 VRXDA_PARTNER_CLOSED' VRXDA_PARTNER_CLOSED
say '2028 VRXDA_INVALID_PARTNER' VRXDA_INVALID_PARTNER
say '2029 VRXDA_ERR_CP_PAIRING' VRXDA_ERR_CP_PAIRING
say '2030 VRXDA_ERR_CHAR_TABLE' VRXDA_ERR_CHAR_TABLE
say '2031 VRXDA_ERR_CHAR_CONVERT' VRXDA_ERR_CHAR_CONVERT
say '2032 VRXDA_PROFILE_MISMATCH' VRXDA_PROFILE_MISMATCH
say '2100 VRXDA_ERR_APPC' VRXDA_ERR_APPC
say '2200 VRXDA_ERR_NP' VRXDA_ERR_NP
say '2300 VRXDA_ERR_NETBIOS' VRXDA_ERR_NETBIOS
say '2301 VRXDA_SHORT_ON_NB_RESOURCES' VRXDA_SHORT_ON_NB_RESOURCES
say '3001 VRXDA_INVALID_FILE_OK' VRXDA_INVALID_FILE_OK
say '3002 VRXDA_INVALID_FILE' VRXDA_INVALID_FILE
say '3003 VRXDA_NO_ENTRY' VRXDA_NO_ENTRY
say '3004 VRXDA_ERR_MEMORY' VRXDA_ERR_MEMORY
say '3005 VRXDA_ERR_WRITE' VRXDA_ERR_WRITE
say '3006 VRXDA_ERR_READ' VRXDA_ERR_READ
say '3007 VRXDA_BAD_SYMBOLIC_NAME' VRXDA_BAD_SYMBOLIC_NAME
say '3100 VRXDA_ERR_SERVER_THREAD' VRXDA_ERR_SERVER_THREAD
say '3101 VRXDA_ERR_CLIENT_THREAD' VRXDA_ERR_CLIENT_THREAD
say '3102 VRXDA_ALREADY_CONNECTED' VRXDA_ALREADY_CONNECTED

say '0 RETURN_CODE_OK' RETURN_CODE_OK
say '1 RETURN_CODE_WARNING' RETURN_CODE_WARNING
say '2 RETURN_CODE_ERROR_OK' RETURN_CODE_ERROR_OK
say '3 RETURN_CODE_ERROR' RETURN_CODE_ERROR

return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:

    call VRRedirectStdIO 'off'
    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
    ok = VRMethod( "DC_1", "LoadVars");
    if \VRGet( "DC_1", "Connected") then do
        call VRSet "PB_4", "Caption", "Connect..."
        ok = VRSet( "PB_2", "Enabled", 1 )
        ok = VRSet( "PB_3", "Enabled", 0 )
    end
    else
        ok = VRMethod( "DC_1", "SetClientData", "Captain Hook or Peter Pan?");
return

/*:VRX         PB_1_Click
*/
PB_1_Click: 
    str = VRGet( "EF_1", "Value" )
    value = VRGet( "EF_3", "Value" )
    set = VRGet( "CB_1", "Set" )
    ok = VRMethod( "DC_1", "SendData", value, str, 0, 0, 1, set);
return

/*:VRX         PB_2_Click
*/
PB_2_Click: 
    ok = VRMethod( "DC_1", "StopListen")
    if ok then do
        ok = VRSet( "PB_3", "Enabled", 1 )
        ok = VRSet( "PB_2", "Enabled", 0 )
    end
return

/*:VRX         PB_3_Click
*/
PB_3_Click: 
    ok = VRMethod( "DC_1", "StartListen")
    if ok then do
        ok = VRSet( "PB_2", "Enabled", 1 )
        ok = VRSet( "PB_3", "Enabled", 0 )
    end
return

/*:VRX         PB_4_Click
*/
PB_4_Click: 
    if VRGet( "DC_1", "Connected") then do
        ok = VRMethod( "DC_1", "CloseConnection");
        call VRSet "PB_4", "Caption", "Connect..."
        ok = VRSet( "PB_2", "Enabled", 1 )
        ok = VRSet( "PB_3", "Enabled", 0 )
    end
    else do
        ok = VRMethod( "DC_1", "OpenConnection");
        call VRSet "PB_4", "Caption", "Disconnect..."
        call PB_3_Click
        ok = VRMethod( "DC_1", "SetClientData", "Captain Hook or Peter Pan?");
    end
return

/*:VRX         Quit
*/
Quit:
    if VRGet( "DC_1", "Connected") then
        call VRMethod "DC_1", "CloseConnection"

    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

