/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
        call VROptions 'NoEchoQuit'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         idm_center_Click
*/
idm_center_Click: 
    call VRSet TTm, "Justification", "Centered"
return

/*:VRX         idm_left_Click
*/
idm_left_Click: 
    call VRSet TTm, "Justification", "Left"
return

/*:VRX         idm_right_Click
*/
idm_right_Click: 
    call VRSet TTm, "Justification", "Right"
return

/*:VRX         Init
*/
Init:
    call VRRedirectStdIO "off"
    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"

    TTm = 'TT_3';
    Left = VRGet( "GB_1", "Left");
    Top = VRGet( "GB_1", "Top");
    vinc = format( VRGet( window, "InteriorHeight") / 100,,0);
    hinc = format( VRGet( window, "InteriorWidth") / 100,,0);

    horz_pos = 100;
    vert_pos = 100;

    drop window
return

/*:VRX         LI_1_Click
*/
LI_1_Click: 
    TTm = VRInfo( "Object");
    call Reset_scroll
return

/*:VRX         LI_2_Click
*/
LI_2_Click: 
    TTm = VRInfo( "Object");
    call Reset_scroll
return

/*:VRX         LI_3_Click
*/
LI_3_Click: 
    TTm = VRInfo( "Object");
    call Reset_scroll
return

/*:VRX         LI_4_Click
*/
LI_4_Click: 
    TTm = VRInfo( "Object");
    call Reset_scroll
return

/*:VRX         PB_1_Click
*/
PB_1_Click: 
    call Quit
return

/*:VRX         PB_1_ContextMenu
*/
PB_1_ContextMenu: 
    TTm = VRInfo( "Object");
    call Reset_scroll
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Reset_Scroll
*/
Reset_Scroll: 
    ok = VRSet( "SCR_3", "Value", 100 )
    ok = VRSet( "SCR_4", "Value", 100 )
    horz_pos = 100;
    vert_pos = 100;
return

/*:VRX         SCR_1_Change
*/
SCR_1_Change: 
    pos = (VRGet( "SCR_1", "value") - 50) * vinc;
    ok = VRSet( "GB_1", "Top", top - pos);
return

/*:VRX         SCR_1_Track
*/
SCR_1_Track: 
    pos = (VRGet( "SCR_1", "value") - 50) * vinc;
    ok = VRSet( "GB_1", "Top", top - pos);
return

/*:VRX         SCR_2_Change
*/
SCR_2_Change: 
    pos = (VRGet( "SCR_2", "value") - 50) * hinc;
    ok = VRSet( "GB_1", "Left", left - pos);
return

/*:VRX         SCR_2_Track
*/
SCR_2_Track: 
    pos = (VRGet( "SCR_2", "value") - 50) * hinc;
    ok = VRSet( "GB_1", "Left", left - pos);
return

/*:VRX         SCR_3_Change
*/
SCR_3_Change: procedure expose vert_pos TTm
    pos = VRGet( "SCR_3", "value")
    inc = (pos - vert_pos) * 10;
    x = VRGet( TTm, "Top");
    call VRSet TTm, "Top", x + inc
    vert_pos = pos
return

/*:VRX         SCR_3_Track
*/
SCR_3_Track: procedure expose vert_pos TTm
    pos = VRGet( "SCR_3", "value")
    inc = (pos - vert_pos) * 10;
    x = VRGet( TTm, "Top");
    call VRSet TTm, "Top", x + inc
    vert_pos = pos
return

/*:VRX         SCR_4_Change
*/
SCR_4_Change: procedure expose horz_pos TTm
    pos = VRGet( "SCR_4", "value")
    inc = (pos - horz_pos) * 10;
    x = VRGet( TTm, "Left");
    call VRSet TTm, "Left", x + inc
    horz_pos = pos
return

/*:VRX         SCR_4_Track
*/
SCR_4_Track: procedure expose horz_pos TTm
    pos = VRGet( "SCR_4", "value")
    inc = (pos - horz_pos) * 10;
    x = VRGet( TTm, "Left");
    call VRSet TTm, "Left", x + inc
    horz_pos = pos
return

/*:VRX         TT_2_Click
*/
TT_2_Click: 
    TTm = VRInfo( "Object");
    call Reset_scroll
return

/*:VRX         TT_2_ContextMenu
*/
TT_2_ContextMenu: 
    ok = VRMethod( "Menu1", "Popup")
    TTm = VRInfo( "Source");
return

/*:VRX         TT_3_Click
*/
TT_3_Click: 
    TTm = VRInfo( "Object");
    call Reset_scroll
return

/*:VRX         TT_3_ContextMenu
*/
TT_3_ContextMenu: 
    ok = VRMethod( "Menu1", "Popup")
    TTm = VRInfo( "Source");
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

/*:VRX         Window1_Resize
*/
Window1_Resize: 
    ok = VRMethod( "TT_2", "Refresh" )
    ok = VRMethod( "TT_3", "Refresh" )
return

