/* REXX */
/* Procedure to call Naval Observatory and set System Time  */
/* Author: Jerry am Ende, Compuserve 73237,131              */
/* Date  : 08/09/92                                         */
/*                                                          */
/* Notes: Change Year to Current Year                       */
/*        Change offset for Daylight Savings Time           */
/*        This version is setup for COM2 change to COM1 if  */
/*          needed                                          */
/*                                                          */
/* -------------------------------------------------------- */
/*   Update by M.R.Allen 26Sep93  Verison 1.1               */
/*     1) Changed COM read loop to look for two "UTC" then  */
/*        use what is inbetween to set the time.            */
/*     2) Changed Date set routine to only reset the date if*/
/*        the date is different than current system date    */
/*     3) Added defaults section                            */
/*     4) added range check for year,GMT offset, ComPort    */
/*     5) Changed GMT offset to Negative values for time    */
/*        zones West of GMT                                 */
/*     6) Changed Self Doc to call subroutine               */
 
TRACE E

parse arg year offset PhoneNumber ComPort

 Default_Speed = "1200"
 Default_COM   = "COM2"
 Default_Phone = "1-202-653-0351"
 Default_GMT_Offset = -5
 Default_Connect_Wait = 45
 /* Set default ARGS */
if offset == ""      then  offset = Default_GMT_Offset

if PhoneNumber == "" then  PhoneNumber = Default_Phone

if ComPort == ""     then  ComPort = Default_COM

/* test for ARG within bounries */
if (year = "" | DATATYPE(year) \= "NUM") then do
   CALL Parm_Doc
   say " Year "year" is invalid"
   return
   end
if (DATATYPE(offset) \= "NUM" |  offset < -12 | offset > 12 ) then do
   CALL Parm_Doc
   say " GMT offset "offset" is invalid"
   return
   end
if pos(ComPort,"COM1COM2COM3COM4com1com2com3com4") = 0 then do
   CALL Parm_Doc
   say "COM Port "ComPort" is invalid"
   return
   end

modays.1 = 31           /* initialize days in each month */
modays.2 = 28
modays.3 = 31
modays.4 = 30
modays.5 = 31
modays.6 = 30
modays.7 = 31
modays.8 = 31
modays.9 = 30
modays.10 = 31
modays.11 = 30
modays.12 = 31

if ((year // 4) == 0) then    /* Check for Leap Year */
   modays.2 = 29

CrLf = X2C("0D0A")

State = STREAM(ComPort,"C","OPEN")
"@MODE" ComPort":"Default_Speed",E,7,1 > NUL"
 
CALL LINEOUT ComPort, "ATX3DT"PhoneNumber||CrLf    /* Dial In */
StartTime = time('E')
TRACE E
ReturnStuff = " "
UTCcount = 0
pos_start = 1
DO WHILE (UTCcount < 2) 
  ReturnStuff = ReturnStuff||CHARIN(ComPort)
  if (pos('BUSY',ReturnStuff) <> 0) then do    /* Check for Busy */
     CALL LINEOUT ComPort,"ATH"CrLf            /* Hang Up */
     State = STREAM(ComPort,"C","CLOSE")
     Say "Line Busy, Please Try Again..."
     return
     end
   /* say "ReturnStuff="ReturnStuff   */

  if (pos('UTC',ReturnStuff,pos_start) \= 0) then do  
    UTCcount = UTCcount + 1
    pos_start = pos('UTC',ReturnStuff,pos_start) + 1
    end

   /* Check for timeout */ 
   if ((time('E') - StartTime) > Default_Connect_Wait) then do   
     CALL LINEOUT ComPort,"ATH"CrLf            /* Hang Up */
     State = STREAM(ComPort,"C","CLOSE")
     Say "Sorry, Timeout..."
     return
     end
END
TRACE E
NavalString = Right(ReturnStuff,20)    /* Retrieve the time/date string */
CALL LINEOUT ComPort,"ATH"CrLf         /* Hang Up */

State = STREAM(ComPort,"C","CLOSE")
parse var NavalString . doy time .

/* Say "NavalString="NavalString  " doy="doy " time="time */
/* Say "ReturnStuff="ReturnStuff */

OldTime = Time()
OldDate = Date()

/* Convert time to HH:MM:SS */
hour = right(left(time,2) + offset,2,'0')
if (hour < 0) then do
   hour = hour + 24
   doy = doy - 1
   end
minute = right(substr(time,3,2),2,'0')
second = right(substr(time,5,2),2,'0')
TimeString = hour || ':' || minute || ':' || second
"@TIME" TimeString

if date('D') \= doy then do 
   /* Convert doy to MM-DD-YY format */
   month = 0
   SumDays = 0
   do while (SumDays < doy)
       month = month + 1
       SumDays = SumDays + modays.month
     end
   SumDays = SumDays - modays.month
   Day = doy - Sumdays
   DateString = right(Month,2,'0') || '-' || right(Day,2,'0') || '-' || Year
   "@DATE" DateString
 end

/* Say Date & Time  */

Say "Date & Time was             " OldDate OLdTime
Say "Date & Time has been Set to:" Date() Time()

return

Parm_Doc:
   "CLS"                   /* Clear Screen */
   say " "
   say " Usage is:"
   say "     TIMESET <year> <GMT_offset> <Phone_Number> <ComPort_Number> ";
   say "          <year>            = 2 digit year (e.g. 1992 = 92)";
   say "                              Nodefault, Must be coded";
   say "          <GMT_offset>      = Hours from Greenwich Mean time.";
   say "                                Central Daylight Time = -5";
   say "                                "Default_GMT_Offset" is default";
   say "          <Phone_Number>    = Phone Number of Naval Observatory";
   say "                                "Default_Phone" is default";
   say "          <ComPort_Number>  = ComPort where modem is connected";
   say "                                 "Default_COM" is default";
   return
