/** AddrBook.cmd **/
/**********************************************/
/*                                            */
/* Command line syntax:                       */
/*                                            */
/* AddrBook db_path user_password user_name   */
/*                                            */
/*                                            */
/**********************************************/
ARG db_path user_pw user_name
'@echo off'
'@cls'
Say 'RexxVIM Address Book Demonstration Program'
Say

/* Unload the function upon error */
SIGNAL ON ERROR NAME done

/* Prompt for the parameters if not passed on the */
/* command line                                   */
if LENGTH(STRIP(db_path)) = 0 then do
   Say 'Enter Postoffice Directory -'
   PARSE PULL db_path .
   Say
   Say 'Enter User Name -'
   PARSE PULL user_name
   Say 'Enter Password -'
   PARSE PULL user_pw
end  /* Do */


/* Load the RexxVIM extensions to Rexx */
rc = RxFuncAdd('RxVIMLoadFuncs', 'REXXVIM', 'RxVIMLoadFuncs')
if rc <> 0 then do
   Say
   Say 'RexxVIM failed to load, return code' rc
   Say
   Say 'Functions have been released.  Retry program.'
   signal done
end  /* Do */
call RxVIMLoadFuncs
Say 'Functions are now loaded'
Say


/* Initialize the VIM subsystem */
rc = RxVIMInitialize()
if (rc > 0) then call vimerr

/* Open a session with the postoffice using the parameters */
/* provided by the user                                    */
rc = RxVIMOpenSession(db_path,user_name,user_pw,Session)
if (rc > 0) then call vimerr


     /* Enumerate the addressbooks */
     pos = ''                           /* Start at the beginning */
     skipcnt = 1                        /* Move forward one at a time */
     acount  = 1                        /* Retrieve 1 addressbook for each call */
     more    = ''                       /* Set the value of more to nul */
     action  = 'N'                      /* Set the value of repeat loop indicator to N */

     AttrDesc.0 = 2                               /* Retrieve 2 attributes for each addressbook */
     AttrDesc.1.Selector = 'VIMSEL_NAME'          /* 1st attribute is the addressbook name */
     AttrDesc.1.Buffer   = 'AddrName'             /* store results in this stem variable */
     AttrDesc.2.Selector = 'VIMSEL_TOTAL_ENTRIES' /* 2nd attribute is total entries */
     AttrDesc.2.Buffer   = 'AddrTotal'            /* store results in this stem variable */

     do until TRANSLATE(SUBSTR(action,1,1)) = 'X'

          /* Continue retrieving addressbook info until user enters N */

          rc = RxVIMEnumerateAddressBooks(Session,'pos',skipcnt,'AttrDesc','acount','more')
          if (rc > 0) then call vimerr

          /* Display results */
         'cls'
          Say 'RexxVIM - (c) Innovative Business Technologies, Inc'
          Say
          Say 'Address Book Demo'
          Say
          Say '--------------------------------------------------------'
          Say '    Address Book Name =' AddrName.1
          Say '    Total Entries     =' AddrTotal.1
          Say '--------------------------------------------------------'
          Say
          Say
          Say 'Select an action for this message'
          Say
          Say '   N - Go to next Address Book'
          Say '   D - Display each of the Address Book entries'
          Say '   G - Get the current subtree name'
          Say '   X - Exit demo now'
          Say
          Say 'Enter your selection below:'
          PULL action

          /* Process the selection entered.  X will fall through the select statement */
          select
             when TRANSLATE(SUBSTR(action,1,1)) = 'N' then do
                /* Go to the next address book */
                /* Nothing to do.....loop will pull next address book */
             end  /* Do */
             when TRANSLATE(SUBSTR(action,1,1)) = 'G' then do

                /* Open the current address book */
                rc = RxVIMOpenAddressBook(Session,AddrName.1,'AddrBkPtr')
                if (rc > 0) then call vimerr

                /* Get the subtree of the address book */
                Subtree = ''
                SubRefNo = ''

                rc = RxVIMGetCurrentSubtree(AddrBkPtr,'SubRefNo','Subtree')
                if (rc > 0) then call vimerr

                /* Close the  address book */
                rc = RxVIMCloseAddressBook(AddrBkPtr)
                if (rc > 0) then call vimerr

                Say '--------------------------------------------------------'
                Say '    Current Subtree  =' Subtree
                Say '--------------------------------------------------------'
                'pause'

             end  /* Do */
             when TRANSLATE(SUBSTR(action,1,1)) = 'D' then do

                /* Open the current address book */
                rc = RxVIMOpenAddressBook(Session,AddrName.1,'AddrBkPtr')
                if (rc > 0) then call vimerr

                /* Enumerate the addressbook entries */                                                             
                epos = ''                           /* Start at the beginning */                                    
                eskipcnt = 1                        /* Move forward one at a time */                                
                eacount  = 1                        /* Retrieve 1 addressbook for each call */                      
                efilter  = 'VIMSEL_NO_FILTER'       /* no filtering */
                efdata   = ''                       /* no filter data */
                emore    = ''                       /* Set the value of more to nul */                              
                eaction  = 'N'                      /* Set the value of repeat loop indicator to N */               
                                                                                                                    
                ItemDesc.0 = 3                               /* Retrieve 3 attributes for each entry */
                ItemDesc.1.Selector = 'VIMSEL_REF'           /* 1st attribute is the reference number */
                ItemDesc.1.Buffer   = 'ABE_Ref'              /* store results in this stem variable */
                ItemDesc.2.Selector = 'VIMSEL_NAME'          /* 2nd attribute is entry name */
                ItemDesc.2.Buffer   = 'ABE_Name'             /* store results in this stem variable */
                ItemDesc.3.Selector = 'VIMSEL_ADDRESS'       /* 3rd attribute is entry address */
                ItemDesc.3.Buffer   = 'ABE_Address'          /* store results in this stem variable */
                                                                                                                    
                do until TRANSLATE(SUBSTR(eaction,1,1)) = 'X'                                                       
                                                                                                                    
                     /* Continue retrieving addressbook info until user enters X */                                 
                                                                                                                    
                     rc = RxVIMEnumerateAddressBookEntries(AddrBkPtr,'epos',eskipcnt,,
                                           'ItemDesc','eacount',efilter,efdata,'emore')
                     if (rc > 0) then call vimerr                                                                   
                                                                                                                    
                     /* Display results */                                                                          
                    'cls'                                                                                           
                     Say 'RexxVIM - (c) Innovative Business Technologies, Inc'                                      
                     Say                                                                                            
                     Say 'Address Book Demo with entry information'                                                 
                     Say                                                                                            
                     Say '--------------------------------------------------------'                                 
                     Say '    Address Book Name =' AddrName.1                                                       
                     Say '    Total Entries     =' AddrTotal.1                                                      
                     Say '--------------------------------------------------------'                                 
                     Say '    Name =   ' ABE_Name.1
                     Say '    Address =' ABE_Address.1
                     Say '    Ref No  =' ABE_Ref.1
                     Say '--------------------------------------------------------'                                 
                     Say                                                                                            
                     Say                                                                                            
                     Say 'Select an action for this message'                                                        
                     Say                                                                                            
                     Say '   N - Go to next Address Book entry'                                                     
                     Say '   X - Exit to the main screen'                                                           
                     Say                                                                                            
                     Say 'Enter your selection below:'                                                              
                     PULL eaction                                                                                   

                     select
                        when TRANSLATE(SUBSTR(eaction,1,1)) = 'N' then do
                           /* Go to the next address book entry */
                           /* Nothing to do.....will loop to the next entry */
                        end  /* Do */
                     otherwise
                     end  /* select */

                     /* End the loop if no more entries */
                     if emore = 'False' then do
                        Say 'All entries for this address book have been retrieved'
                        eaction = 'X'
                     end  /* Do */
                                                                                                                    
                end /* Do */

                /* Close the  address book */                                                            
                rc = RxVIMCloseAddressBook(AddrBkPtr)
                if (rc > 0) then call vimerr

             end  /* Do */
          otherwise
          end  /* select */

          if more = 'False' then do
             Say 'All Address Books have been retrieved'
             action = 'X'
          end  /* Do */

     end /* do */

/* Close the session with the postoffice */
rc = RxVIMCloseSession(Session)
if (rc > 0) then call vimerr


/* Terminate the active VIM subsystem connection */
rc = RxVIMTerminate()
if (rc > 0) then call vimerr
signal done


/***** VIMErr *******/

/* If an error occurs, this function will return the text */
/* associated with the error.  Extended text may be       */
/* displayed if it exists for the specified error.        */

VIMERR:

erc = RxVIMStatusText(Session,rc,'Status')
Say
Say '|-Error Information ------------------------------------|'
Say '  Error Text -' status.1
Say
Say '  Ext Status -' status.2
rc = RxVIMTerminate()
signal done


/* The done section will unload the RexxVIM extensions */
/* and exit the program                                */
DONE:
/*** Drop all of the external functions ***/
call RxVIMDropFuncs
Say '|-------------------------------------------------------|'
Say 'Demo Complete.  All functions released'
'pause'
exit
