/***********************************************************************
 * dbheader.h - include database and platform specific header file
 ***********************************************************************
 *
 * REXX/SQL. A REXX interface to SQL databases.
 * Copyright Mark Hessling, 1994-1997.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to 
 * address below.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                    Email:       M.Hessling@qut.edu.au
 * PO Box 203                       Phone:              +617 3802 0800
 * Bellara                          http://www.lightlink.com/hessling/
 * QLD 4507                         **** Author of THE & Rexx/SQL ****
 * Australia                        ****** Maintainer PDCurses *******
 *
 */

#ifndef REXXSQL_DBHEADER_H
#define REXXSQL_DBHEADER_H

#if defined(__OS2__)
# define REXXSQL_SS_NO_SQLDRIVERCONNECT
#endif

#if defined(__WATCOMC__) && defined(__NT__)
# define SS_WINDOWS
# include <windows.h>
# include <stdio.h>
#endif

#if defined(__WATCOMC__) && defined(__WINDOWS__)
# define SS_WINDOWS
# include <windows.h>
# include <stdio.h>
#endif

#if defined(_MSC_VER) && defined(WIN32)
# define SS_WINDOWS
# include <windows.h>
# include <stdio.h>
#endif

#if defined(SS_UNIX)
# define REXXSQL_SS_NO_SQLDRIVERCONNECT
#endif

#define REXXSQL_SS_NO_SQLGETFUNCTIONS

#include <cli0defs.h>
#include <cli0core.h>
#include <cli0ext1.h>

#if defined(USE_REGINA) && !defined(SS_UNIX)
# define UCHAR_TYPEDEFED
#endif

#endif
