/**/
Parse Arg os db .
If os = '' Then
  Do
     Say 'MUST supply os2 or w32'
     Exit 1
  End
ver = 2.3
os = Translate(os)
rexxsqldir.w32 = 'e:\rexxsql'
rexxsqldir.os2 = 'h:\rexxsql'
distdir = rexxsqldir.os||'\dist'

If os = 'W32' Then
  Do
    database.1 = "Oracle"
    database.2 = "SQLAnyWhere"
    database.3 = "MS ODBC 3.0+"
    database.4 = "mSQL 2.0"
    database.5 = "Solid Server"
    database.6 = "DB2/NT"
    database.7 = "Openlink UDBC"

    interpreter.1 = "IBM Object Rexx"
    interpreter.2 = "Enterprise Rexx"
    interpreter.3 = "Regina 0.08e"
    interpreter.4 = "Quercus Personal Rexx"

    ints = 'O W R Q'
    dirs1 = 'ora saw odbc min2 sol db2 udbc'
    dirs2 = 'orexx winrexx regina quercus'
  End
Else
  Do
    database.1 = "Oracle"
    database.2 = "SQLAnyWhere"
    database.3 = "Intersolv ODBC"
    database.4 = "mSQL 1.0.16"
    database.5 = "mSQL 2.0"
    database.6 = "Solid Server"
    database.7 = "Openlink UDBC"
    database.8 = "DB2/2"

    dirs1 = 'ora saw odbc min min2 sol udbc' /* db2 */
  End

dotversion = ver
version = Changestr('.',ver,'')

src.=''

files = 'README README.rexxsql file_id.diz'

If db \= '' Then
  Do
     pos = Wordpos(db,dirs1)
     If pos = 0 Then
       Do
         Say 'Optional database must be one of' dirs1
         Exit 1
       End
     start = pos
     end = pos
  End
Else
  Do
     start = 1
     end = Words(dirs1)
  End

Do i = 1 To Words(files)
   infile = Word(files,i)||'.tmpl.'||os
   j = 0
   Do While(Lines(infile)>0)
      j = j + 1
      src.j = Linein(infile)
   End
   src.0 = j
   Do k = start To end
     If os = 'W32' Then
       Do l = 1 To Words(dirs2)
         outdir = Word(dirs1,k)'\'Word(dirs2,l)
         outfile = outdir'\'Word(files,i)
         Address System 'del' outfile
         Address System 'copy COPYING' outdir
         Address System 'copy tester.cmd' outdir
         Address System 'copy README.'Word(dirs1,k)'.'os outdir||'\README.'Word(dirs1,k)
         Do m = 1 To src.0
            line = ProcessLine(src.m)
            rc = Lineout(outfile,line)
         End
         rc = Stream(outfile,'C','CLOSE')
       End
     Else
       Do
         outdir = Word(dirs1,k)
         outfile = outdir'\'Word(files,i)
         Address System 'del' outfile
         Address System 'copy COPYING' outdir
         Address System 'copy tester.cmd' outdir
         Say 'copy README.'Word(dirs1,k) outdir||'\README.'Word(dirs1,k)
         Address System 'copy README.'Word(dirs1,k)'.'os outdir||'\README.'Word(dirs1,k)
         Do m = 1 To src.0
            line = ProcessLine(src.m)
            rc = Lineout(outfile,line)
         End
         rc = Stream(outfile,'C','CLOSE')
       End
   End
End

Do i = start To end
  If os = 'W32' Then
    Do j = 1 To Words(dirs2)
       outdir = distdir'\'Word(dirs1,i)'\'Word(dirs2,j)
       rc = chdir(outdir)
       zipfile = 'rxsql'version||Word(ints,j)'_'Word(dirs1,i)'_w32.zip'
       Address System 'del' zipfile
       Address System 'zip' zipfile '*'
       Address System 'copy' zipfile distdir
    End
  Else
    Do
    trace o
       outdir = distdir'\'Word(dirs1,i)
       rc = chdir(outdir)
       zipfile = 'rxsql'version'_'Word(dirs1,i)'_os2.zip'
       Address System 'del' zipfile
       Address System 'zip' zipfile '*'
       Address System 'copy' zipfile distdir
    trace o
    End
End
Return
ProcessLine:
Parse Arg myline
myline = Changestr('[*database*]',myline,database.k)
If os = 'W32' Then myline = Changestr('[*interpreter*]',myline,interpreter.l)
Else myline = Changestr('[*interpreter*]',myline,"OS/2 Rexx or Object Rexx")
myline = Changestr('[*DB*]',myline,Translate(Word(dirs1,k)))
If os = 'W32' Then myline = Changestr('[*INT*]',myline,Word(ints,l))
Else myline = Changestr('[*INT*]_',myline,"")
myline = Changestr('[*version*]',myline,version)
myline = Changestr('[*dotversion*]',myline,dotversion)
If Substr(myline,1,1) = '+' Then myline = Center(Strip(Substr(myline,2)),75)
Return myline
