/***********************************************************************
 * rexxsql.h - Rexx/SQL common includes
 ***********************************************************************
 *
 * Rexx/SQL. A Rexx interface to SQL databases.
 * Copyright Mark Hessling, 1994-1997.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to 
 * address below.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                    Email:       M.Hessling@qut.edu.au
 * PO Box 203                       Phone:              +617 3802 0800
 * Bellara                          http://www.lightlink.com/hessling/
 * QLD 4507                         **** Author of THE & Rexx/SQL ****
 * Australia                        ****** Maintainer PDCurses *******
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <assert.h>
#include <sys/stat.h>
#include "hash.h"

#define INCL_RXSHV	/* Shared variable support */
#define INCL_RXFUNC	/* External functions support */
#define INCL_RXSYSEXIT	/* System exit support */

#if !defined(__EMX__)
# if defined(USE_QUERCUS)
#  include <windows.h>
#  include <wrexx32.h>
# elif defined(USE_WINREXX)
#  include <windows.h>
#  include <wrexx32.h>
# elif defined(USE_OREXX)
#  include <rexx.h>
# else
#  include <rexxsaa.h>
# endif
#endif

#if defined(__OS2__)
# define OS2 3
# include <os2.h>
#endif

#if defined(UNIX)
# if defined(USE_AIXREXX)
#  define RXSQL_PUCHAR     PSZ
#  define RXSQL_PCSZ       PSZ
#  define RXSQL_PSZ        PSZ
#  define RXSQL_RXSTRPTR   PUCHAR
#  define RXSQL_PRXFUNC    PRXFUNC
# elif defined(USE_OREXX)
#  define RXSQL_PUCHAR     PUCHAR
#  define RXSQL_PCSZ       PSZ
#  define RXSQL_PSZ        PSZ
#  define RXSQL_RXSTRPTR   PSZ
#  define RXSQL_PRXFUNC    PFN
# else
#  define RXSQL_PUCHAR     PSZ
#  define RXSQL_PCSZ       PSZ
#  define RXSQL_PSZ        PSZ
#  define RXSQL_RXSTRPTR   PSZ
#  define RXSQL_PRXFUNC    PFN
# endif
#endif

#if defined(__OS2__)
# define HAVE_SIZE_T
# define HAVE_STRERROR
# if defined(__EMX__)
#  define RXSQL_PUCHAR     PCSZ
#  define RXSQL_PCSZ       PCSZ
#  define RXSQL_PSZ        PSZ
#  define RXSQL_RXSTRPTR   PSZ
#  define RXSQL_PRXFUNC    RexxFunctionHandler *
# else
#  define RXSQL_PUCHAR     PSZ
#  define RXSQL_PCSZ       PSZ
#  define RXSQL_PSZ        PSZ
#  define RXSQL_RXSTRPTR   PSZ
#  define RXSQL_PRXFUNC    PFN
# endif
#endif

#if defined(WIN32)
# define HAVE_STRERROR
# if defined(USE_OREXX)
#  define RXSQL_PUCHAR     PUCHAR
#  define RXSQL_PCSZ       PSZ
#  define RXSQL_PSZ        PSZ
#  define RXSQL_RXSTRPTR   PSZ
#  define RXSQL_PRXFUNC    PFN
# elif defined(USE_REGINA)
#  define RXSQL_PUCHAR     PSZ
#  define RXSQL_PCSZ       PSZ
#  define RXSQL_PSZ        PSZ
#  define RXSQL_RXSTRPTR   PSZ
#  define RXSQL_PRXFUNC    PFN
# elif defined(USE_WINREXX)
#  define RXSQL_PUCHAR     PSZ
#  define RXSQL_PCSZ       PSZ
#  define RXSQL_PSZ        PSZ
#  define RXSQL_RXSTRPTR   PSZ
#  define RXSQL_PRXFUNC    PFNRXFUNC
# elif defined(USE_QUERCUS)
#  define RXSQL_PUCHAR     PSZ
#  define RXSQL_PCSZ       PSZ
#  define RXSQL_PSZ        PSZ
#  define RXSQL_RXSTRPTR   PSZ
#  define RXSQL_PRXFUNC    FARPROC
# endif
#endif

#if !defined(RXAUTOBUFLEN)
# define RXAUTOBUFLEN 256L
#endif

#if defined(UNIX)
# include <unistd.h>
# define RXSQL_APIENTRY
/* # define RexxSQLFunctionHandler RexxFunctionHandler*/
#endif


#if !defined(HAVE_SIZE_T)
# define HAVE_SIZE_T
  typedef unsigned int	size_t;
#endif

#if !defined(HAVE_STRERROR)
  char *rxsql_get_sys_errlist( int num );
# define strerror(a)    rxsql_get_sys_errlist(a)
#endif

#ifndef R_OK
# define R_OK 4
#endif


#define RETBUFLEN 250

#if defined(__OS2__) && defined(__IBMC__)
# if defined(__DLL__)
#   define DYNAMIC_LIBRARY 1
# endif
# define RXSQL_APIENTRY
/* # define RexxSQLFunctionHandler RexxFunctionHandler*/
#endif

#if defined(__WATCOMC__)
# if defined(__OS2__) || defined(__WINDOWS__) || defined(__NT__)
#  if defined(__SW_BD)
#    define DYNAMIC_LIBRARY 1
#    if defined(__NT__)
#      define RXSQL_APIENTRY /* __cdecl __stdcall  __export */
#    endif
#    if defined(__OS2__)
#      define RXSQL_APIENTRY __syscall __export
#    endif
#  else
#    define RXSQL_APIENTRY /* APIENTRY */
#  endif
# endif
/*# define RexxSQLFunctionHandler RexxFunctionHandler*/
#endif

#if defined(_MSC_VER)
# include <windows.h>
# if defined(DYNAMIC)
#   define DYNAMIC_LIBRARY 1
#   if defined(WIN32)
#     define RXSQL_APIENTRY APIENTRY /* __declspec(dllexport) */
#   else
#     define RXSQL_APIENTRY
#   endif
# else
#   define RXSQL_APIENTRY APIENTRY
# endif
#endif
/*
 * Create our own typedef for a RexxFunctionHandler
 */

#if defined(USE_OREXX)
# define RexxSQLFunctionHandler RexxFunctionHandler
#else
typedef ULONG RXSQL_APIENTRY RexxSQLFunctionHandler(RXSQL_PUCHAR, ULONG, RXSTRING *, RXSQL_PSZ, RXSTRING *);
#endif

#ifndef TRUE
# define TRUE	1
# define FALSE	0
#endif

/* 
 * Run time modes 
 */
#define MODE_DEBUG	1
#define MODE_VERBOSE	2
/*
 * Defines for REXX/SQL variable types
 */
#define TYPE_INT	0
#define TYPE_STRING	1
#define TYPE_ARRAY	2
#define TYPE_BOOL	3
#define TYPE_DATATYPE	4
/*
 * Defines for default NULL string representation
 */
#define NULLSTRINGOUT ""
#define NULLSTRINGIN ""
/*
 * Used in SetSqlVariable
 */
#define SQLVAL_NULLSTRINGIN           1
#define SQLVAL_NULLSTRINGOUT          2
#define SQLVAL_VERSION                3
#define SQLVAL_SUPPORTSTRANSACTIONS   4
#define SQLVAL_SUPPORTSSQLGETDATA     5
#define SQLVAL_DESCRIBECOLUMNS        6
#define SQLVAL_DATATYPES              7
#define SQLVAL_DBMSNAME               8
#define SQLVAL_DBMSVERSION            9
/*
 * Name of default (implict) statement
 */
#define DEFAULT_STATEMENT "DEFAULT"
/*
 * Name of COMMIT/ROLLBACK (implict) statement
 */
#define TRANS_STATEMENT "TRANS"

/*
 * Default size of LONG data returned
 */
#define DEFAULT_LONG_LIMIT  32768

/*
 * Error value returned for errors returned by database as opposed to
 * those generated by the interface.
 */
#define DB_ERROR	(-1L)
#define DB_WARNING	(1L)

/*
 * Some arbitrary number to ensure it doesn't match a valid
 * internal datatype; ODBC uses negative and positive numbers :-(
 */
#define RXSQL_INVALID_DATATYPE  (-94563)

/* Directory separator is:
 * MS-DOS	'\'
 * OS/2	'\'
 * UNIX		'/'
 * VMS		']' & ':'
 * WIN32	'\'
 */

#ifdef OS2
# define BAD_ARGS	0
# define REXX_FAIL	1
# define DIRSEP(ch) (ch == '\\' && ch == ':')
# define CURRENT_OS "OS/2"
#endif

#ifdef MSDOS
# define BAD_ARGS	0
# define REXX_FAIL	1
# define DIRSEP(ch) (ch == '\\' && ch == ':')
# define CURRENT_OS "DOS"
#endif

#ifdef UNIX
# define BAD_ARGS	2
# define REXX_FAIL	1
# define DIRSEP(ch) (ch == '/')
# define CURRENT_OS "UNIX"
#endif

#ifdef WIN32
# define BAD_ARGS	0
# define REXX_FAIL	1
# define DIRSEP(ch) (ch == '\\' && ch == ':')
# define CURRENT_OS "WIN32"
#endif

#ifdef VMS
# define BAD_ARGS	0
# define REXX_FAIL	0
# define DIRSEP(ch) (ch == ']' || ch == ':')
# define CURRENT_OS "VMS"
#endif

#define RXSTRCAT(dst,dstlen,src,srclen) (memcpy((dst)+(dstlen),(src),(srclen)),(dstlen)+=(srclen),*((dst)+(dstlen))='\0')
#define RXSTRCPY(dst,dstlen,src,srclen) (memcpy((dst),(src),(srclen)),(dstlen)=(srclen),*((dst)+(dstlen))='\0')

#if defined(USE_AIXREXX) 
 ULONG SQLVARIABLE(RXSQL_PCSZ,ULONG,PRXSTRING,RXSQL_PCSZ,PRXSTRING);
 ULONG SQLGETINFO(RXSQL_PCSZ,ULONG,PRXSTRING,RXSQL_PCSZ,PRXSTRING);
 ULONG SQLSETINFO(RXSQL_PCSZ,ULONG,PRXSTRING,RXSQL_PCSZ,PRXSTRING);
 ULONG SQLCONNECT(RXSQL_PCSZ,ULONG,PRXSTRING,RXSQL_PCSZ,PRXSTRING);
 ULONG SQLDISCONNET(RXSQL_PCSZ,ULONG,PRXSTRING,RXSQL_PCSZ,PRXSTRING);
 ULONG SQLDEFAULT(RXSQL_PCSZ,ULONG,PRXSTRING,RXSQL_PCSZ,PRXSTRING);
 ULONG SQLCOMMIT(RXSQL_PCSZ,ULONG,PRXSTRING,RXSQL_PCSZ,PRXSTRING);
 ULONG SQLROLLBACK(RXSQL_PCSZ,ULONG,PRXSTRING,RXSQL_PCSZ,PRXSTRING);
 ULONG SQLCOMMAND(RXSQL_PCSZ,ULONG,PRXSTRING,RXSQL_PCSZ,PRXSTRING);
 ULONG SQLPREPARE(RXSQL_PCSZ,ULONG,PRXSTRING,RXSQL_PCSZ,PRXSTRING);
 ULONG SQLDISPOSE(RXSQL_PCSZ,ULONG,PRXSTRING,RXSQL_PCSZ,PRXSTRING);
 ULONG SQLEXECUTE(RXSQL_PCSZ,ULONG,PRXSTRING,RXSQL_PCSZ,PRXSTRING);
 ULONG SQLOPEN(RXSQL_PCSZ,ULONG,PRXSTRING,RXSQL_PCSZ,PRXSTRING);
 ULONG SQLCLOSE(RXSQL_PCSZ,ULONG,PRXSTRING,RXSQL_PCSZ,PRXSTRING);
 ULONG SQLFETCH(RXSQL_PCSZ,ULONG,PRXSTRING,RXSQL_PCSZ,PRXSTRING);
 ULONG SQLGETDATA(RXSQL_PCSZ,ULONG,PRXSTRING,RXSQL_PCSZ,PRXSTRING);
 ULONG SQLDESCRIBE(RXSQL_PCSZ,ULONG,PRXSTRING,RXSQL_PCSZ,PRXSTRING);
 ULONG SQLLOADFUNCS(RXSQL_PCSZ,ULONG,PRXSTRING,RXSQL_PCSZ,PRXSTRING);
 ULONG SQLDROPFUNCS(RXSQL_PCSZ,ULONG,PRXSTRING,RXSQL_PCSZ,PRXSTRING);
#else
 RexxSQLFunctionHandler SQLVARIABLE;
 RexxSQLFunctionHandler SQLGETINFO;
 RexxSQLFunctionHandler SQLSETINFO;
 RexxSQLFunctionHandler SQLCONNECT;
 RexxSQLFunctionHandler SQLDISCONNECT;
 RexxSQLFunctionHandler SQLDEFAULT;
 RexxSQLFunctionHandler SQLCOMMIT;
 RexxSQLFunctionHandler SQLROLLBACK;
 RexxSQLFunctionHandler SQLCOMMAND;
 RexxSQLFunctionHandler SQLPREPARE;
 RexxSQLFunctionHandler SQLDISPOSE;
 RexxSQLFunctionHandler SQLEXECUTE;
 RexxSQLFunctionHandler SQLOPEN;
 RexxSQLFunctionHandler SQLCLOSE;
 RexxSQLFunctionHandler SQLFETCH;
 RexxSQLFunctionHandler SQLGETDATA;
 RexxSQLFunctionHandler SQLDESCRIBE;
 RexxSQLFunctionHandler SQLLOADFUNCS;
 RexxSQLFunctionHandler SQLDROPFUNCS;
#endif

/*
 * Structure to define a REXX/SQL variable descriptor entry. Note that this
 * describes the variable but does not define storage for it!
 * NB! The field; name, MUST be the first entry in the structure.
 */
typedef struct _SQLVAL {
    struct _SQLVAL *next;
    struct _SQLVAL *prev;
    char  name[MAX_IDENTIFIER+1];
    char  user_update;
    char  dtype;
    int   option;
    int   maxlen;
    void  *value;
    int   valtype;
} SQLVAL;


#ifdef HAVE_PROTO
 int memcmpi(char *, char *, int);
 char *make_upper(char *);
 char *AllocString(char *, size_t);
 int SetIntError(int, char *, char *, long);
 char *MkAsciz(char *, size_t, char *, size_t);
 void SetSQLCA(RXSQL_SQLCODE_TYPE, RXSQL_SQLSTATE_TYPE *, RXSQL_SQLERRM_TYPE *, char *);
 void SetRowCount(RXSQL_ROWCOUNT_TYPE);
#if defined(USES_COMPUTE_COUNT)
 void SetComputeCount(RXSQL_COMPUTECOUNT_TYPE);
#endif
 void ClearDBError(void);
 void ClearIntError(void);
 int SelectStatement(char *,long);
 int SetRexxVariable(char *, size_t, char *, size_t );
 int StrToInt(RXSTRING *, ULONG *);
 int StrToBool(RXSTRING *, ULONG *);
 void FunctionPrologue(RXSQL_PSZ, ULONG, RXSTRING*);
 void InternalFunctionPrologue(char *);
 ULONG PutString(RXSTRING *, char *, size_t);
 ULONG ReturnInt(RXSTRING *, long );
 ULONG ReturnString(RXSTRING *, char *, size_t);
 ULONG ReturnError(RXSTRING *, int, char *);
 int MkIdentifier(RXSTRING, PSZ, size_t);
 int SaveSqlStatement(char **, int *, char *, int);
 void *GetSqlVariableValue(int,void *);
 SQLVAL *InstallSQLVariable(int *,char *, SQLVAL *tbl, int, int, int, int, void *);
 int InstallSQLVariables(void);
 int InitRexxSQL(RXSQL_PSZ,int);
 int TerminateRexxSQL(RXSQL_PSZ);
 int DBInitialise(void);
 int ArrayToArgv(RXSTRING*, RXSTRING*, ULONG *, RXSTRING *);
 int ArgvToArgv(ULONG, RXSTRING *, ULONG *, RXSTRING *);
 RXSTRING *FreeArgv(ULONG *, RXSTRING *);
 void DisposeInfo(SQLVAL *);
 int ReleaseDbEnvironment(void);
 SQLVAL *ll_add(SQLVAL *,SQLVAL *);
 SQLVAL *ll_free(SQLVAL *);
 SQLVAL *ll_find(SQLVAL *, char *);
#else
 int memcmpi();
 char *make_upper();
 char *AllocString();
 int SetIntError();
 char *MkAsciz();
 void SetSQLCA();
 void SetRowCount();
#if defined(USES_COMPUTE_COUNT)
 void SetComputeCount();
#endif
 void ClearDBError();
 void ClearIntError();
 int SelectStatement();
 int SetRexxVariable();
 int StrToInt();
 int StrToBool();
 void FunctionPrologue();
 void InternalFunctionPrologue();
 ULONG PutString();
 ULONG ReturnInt();
 ULONG ReturnString();
 ULONG ReturnError();
 int MkIdentifier();
 int SaveSqlStatement();
 void *GetSqlVariableValue();
 SQLVAL *InstallSQLVariable();
 int InstallSQLVariables();
 int InitRexxSQL();
 int TerminateRexxSQL();
 int DBInitialise();
 int ArrayToArgv();
 int ArgvToArgv();
 RXSTRING *FreeArgv();
 void DisposeInfo();
 int ReleaseDbEnvironment();
 SQLVAL *ll_add();
 SQLVAL *ll_free();
 SQLVAL *ll_find();
#endif

#define OPT_DYNAMIC   0001
#define OPT_STATIC    0002

/*
 * Structure to define datatypes supported by the database
 */
typedef struct 
{
 char  *ext_datatype; /* external datatype name */
 int   int_datatype;  /* internal datatype */
 char  long_datatype; /* indicates if column data needs to be accessed via SqlGetData() */
} REXXSQL_DT;

/*
 * Structure to define datatypes supported by the database
 */
typedef struct 
{
 int   strlength;  /* length of the strptr */
 char  *strptr;    /* datatype string */
 int   internal;   /* internal datatype */
} RXSTRING_DT;

#if !defined(max)
# define max(a,b)        (((a) > (b)) ? (a) : (b))
#endif

#if !defined(min)
# define min(a,b)        (((a) < (b)) ? (a) : (b))
#endif

#define REXXSQL_VERSION "2.3"
#define REXXSQL_DATE    "30 Jun 1998"

#define MAGIC_NUMBER 78678932
