dnl ---------------------------------------------------------------------------
dnl Check REXX library and header files
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_REXX],
[
if test "$with_regina" = yes; then
	AC_DEFINE(USE_REGINA)
	rexx_h="rexxsaa.h"
	rexx_l="regina"
	extra_libs=""
else
	if test "$with_rexximc" = yes; then
		AC_DEFINE(USE_REXXIMC)
		rexx_h="rexxsaa.h"
		rexx_l="rexx"
		extra_libs=""
	else
		if test "$with_rexx6000" = yes; then
			AC_DEFINE(USE_REXX6000)
			rexx_h="rexxtype.h"
			rexx_l="rexx"
			extra_libs=""
		else
			if test "$with_orexx" = yes; then
				AC_DEFINE(USE_OREXX)
				rexx_h="rexx.h"
				rexx_l="rexx"
				extra_libs="-lrexxapi -lpthreads"
			else
				AC_DEFINE(NOREXX)
				rexx_h=""
				rexx_l=""
				extra_libs=""
			fi
		fi
	fi
fi

dnl look for REXX header and library, exit if not found

if test "xx$rexx_h" = "xx" ; then
	MH_REXX_LIB=""
	MH_REXX_INC=""
	AC_SUBST(MH_REXX_INC)
	AC_SUBST(MH_REXX_LIB)
else
dnl look for REXX header and library, exit if not found
	AC_MSG_CHECKING(for location of REXX header file)
	mh_rexx_inc_dir=""
	mh_inc_dirs="\
	    ${HOME}/include           \
	    /usr/local/include        \
	    /usr/contrib/include      \
	    /opt/include              \
	    /usr/include              \
	    /usr/local/orexx          \
	    /usr/unsupported/include"
dnl
dnl Provide for user supplying directory
dnl
	if test "$with_rexxincdir" != no ; then
		mh_inc_dirs="$with_rexxincdir $mh_inc_dirs"
	fi
dnl
dnl Try to determine the directory containing REXX header
dnl
	for ac_dir in $mh_inc_dirs ; do
	  if test -r $ac_dir/$rexx_h; then
	    mh_rexx_inc_dir=$ac_dir
	    break
	  fi
	done
	if test "x$mh_rexx_inc_dir" != "x" ; then
		MH_REXX_INC="-I$mh_rexx_inc_dir"
		AC_MSG_RESULT(found in $mh_rexx_inc_dir)
		AC_SUBST(MH_REXX_INC)
	else
		AC_MSG_ERROR(Cannot find REXX header file: $rexx_h; THE cannot be configured)
	fi
	AC_MSG_CHECKING(for location of REXX library file)
	mh_rexx_lib_dir=""
	mh_lib_dirs="\
	    ${HOME}/lib               \
	    /usr/local/lib            \
	    /usr/contrib/lib          \
	    /opt/lib                  \
	    /usr/lib                  \
	    /usr/local/orexx/lib      \
	    /usr/unsupported/lib"
dnl
dnl Provide for user supplying directory
dnl
	if test "$with_rexxlibdir" != no ; then
		mh_lib_dirs="$with_rexxlibdir $mh_lib_dirs"
	fi
dnl
dnl Try to determine the directory containing REXX library
dnl
	for ac_dir in $mh_lib_dirs ; do
		for mh_ext in lib${rexx_l}.a lib${rexx_l}.so lib${rexx_l}.sl lib${rexx_l}.so.1 ; do
		  if test -r $ac_dir/$mh_ext; then
		     mh_rexx_lib_dir=$ac_dir
		     break 2
		  fi
		done
	done
	if test "x$mh_rexx_lib_dir" != "x" ; then
		MH_REXX_LIB="-L$mh_rexx_lib_dir -l$rexx_l $extra_libs"
		AC_MSG_RESULT(found in $mh_rexx_lib_dir)
		AC_SUBST(MH_REXX_LIB)
	else
		AC_MSG_ERROR(Cannot find REXX library file: $rexx_l; Rexx/SQL cannot be configured)
	fi
fi
])dnl

dnl ---------------------------------------------------------------------------
dnl Check if C compiler supports -o -c
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_CC_O],
[
AC_MSG_CHECKING(if compiler supports -c -o flags)
dnl
dnl override existing value of $ac_compile so we use the correct compiler
dnl SHOULD NOT NEED THIS
dnl
ac_compile='$ac_cv_prog_CC conftest.$ac_ext $CFLAGS $CPPFLAGS -c -o conftest.o 1>&5 2>&5'
AC_TRY_COMPILE([#include <stdio.h>],
[extern int xxx(int, char *);],
  mh_cc_o=yes, mh_cc_o=no )
AC_MSG_RESULT($mh_cc_o)
if test "$mh_cc_o" = yes; then
	CCO="-o '$@'"
	AC_SUBST(CCO)
	OHASH="echo ignoring command -"
else
	CCO=""
	OHASH=""
	AC_SUBST(OHASH)
fi
AC_SUBST(CCO)
AC_SUBST(OHASH)
])dnl

dnl ---------------------------------------------------------------------------
dnl Check if various types have been typedefed by database header files
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_TYPE],
[
dnl
dnl override existing value of $ac_compile so we use the correct compiler
dnl SHOULD NOT NEED THIS
dnl
ac_compile='$ac_cv_prog_CC conftest.$ac_ext $MH_DB_INC $CFLAGS $CPPFLAGS -c -o conftest.o 1>&5 2>&5'
for mh_type in $1; do
	AC_MSG_CHECKING(if $mh_type defined)
AC_TRY_COMPILE([#include <${DBINC}>],
[${mh_type} var1;],
  mh_type_found=yes, mh_type_found=no )
	AC_MSG_RESULT($mh_type_found)
	if test "$mh_type_found" = yes; then
	AC_DEFINE_UNQUOTED(${mh_type}_TYPEDEFED)
	fi
done
])dnl

dnl ---------------------------------------------------------------------------
dnl Check for presense of various libraries
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_LIB],
[
MH_EXTRA_LIBS=''
for mh_lib in $1; do
#	AC_MSG_CHECKING(for library -l${mh_lib})
	AC_CHECK_LIB($mh_lib,main,mh_lib_found=yes,mh_lib_found=no)
	if test "$mh_lib_found" = yes; then
#		AC_MSG_RESULT(found)
		MH_EXTRA_LIBS="${MH_EXTRA_LIBS} -l${mh_lib}"
#	else
#		AC_MSG_RESULT(not found)
	fi
done
])dnl

dnl ---------------------------------------------------------------------------
dnl Setup all Oracle stuff
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_ORACLE],
[
DBINC="oci.h"
DBLIB1=""
DBLIB2=""
DBLIB3=""
DBLIB4=""
INCLUDE_DB_MAKEFILE=""
if test -n "$ORACLE_HOME" ; then
	if test -f "$ORACLE_HOME/lib/libclntsh.so" -o -f "$ORACLE_HOME/lib/libclntsh.sl"; then
		DBLIB1="-L$ORACLE_HOME/lib -lclntsh"
		AC_MSG_RESULT(using Oracle client library -lclntsh)
	else
		grep libclntsh $ORACLE_HOME/rdbms/lib/*.mk > /dev/null
		if test $? -eq 0 ; then
			AC_MSG_WARN(This version of Oracle supports a shared library of client code)
			AC_MSG_WARN(used by OCI programs.  The shared library; libclntsh.[so,sl] in)
			AC_MSG_WARN($ORACLE_HOME/lib has not been built.  See your DBA to build this)
			AC_MSG_WARN(library and then run this configuration script again.)
			AC_MSG_WARN(You will need to include $ORACLE_HOME/lib in your LD_LIBRARY_PATH.)
			AC_MSG_ERROR(configure aborted.)
		else
			if test -f "$ORACLE_HOME/rdbms/lib/oracle.mk" ; then
				INCLUDE_DB_MAKEFILE="include $ORACLE_HOME/rdbms/lib/oracle.mk"
				DBLIB1="-L$ORACLE_HOME/lib $(OCILDLIBS)"
				AC_MSG_RESULT(using $ORACLE_HOME/rdbms/lib/oracle.mk)
			else
				AC_MSG_WARN(Unable to configure Rexx/SQL for Oracle.)
				AC_MSG_WARN(Rexx/SQL needs one of the following files to be available:)
				AC_MSG_WARN()
				AC_MSG_WARN($ORACLE_HOME/lib/libclntsh.[so,sl])
				AC_MSG_WARN($ORACLE_HOME/rdbms/lib/oracle.mk)
				AC_MSG_WARN(or)
				AC_MSG_WARN(rules to make libclntsh.[so,sl] in)
				AC_MSG_WARN($ORACLE_HOME/rdbms/lib/*.mk)
			AC_MSG_ERROR(configure aborted.)
			fi
		fi
	fi
else
	AC_MSG_ERROR(ORACLE_HOME not set, cannot continue)
fi
])dnl

dnl ---------------------------------------------------------------------------
dnl Setup all Sybase stuff
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_SYBASE],
[
DBINC="ctpublic.h"
DBLIB1=""
DBLIB2=""
DBLIB3=""
DBLIB4=""
if test -n "$SYBASE" ; then
	if test "$with_dbincdir" = no; then
		MH_DB_INC="-I${SYBASE}/include"
	else
		MH_DB_INC="-I${with_dbincdir}"
	fi
	if test "$with_dblibdir" = no; then
		MH_DB_LIB="-L${SYBASE}/lib -lctlib"
	else
		MH_DB_LIB="-L${with_dblibdir} -lctlib"
	fi
else
	AC_MSG_ERROR(SYBASE not set, cannot continue)
fi
])dnl

dnl ---------------------------------------------------------------------------
dnl Setup all mSQL 1.x stuff
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_MSQL],
[
DBINC="msql.h"
DBLIB1=""
DBLIB2=""
DBLIB3=""
DBLIB4=""
mh_db_inc_dir=""
mh_db_lib_dir=""
AC_MSG_CHECKING(location of mSQL header file)
if test "$with_dbincdir" = no; then
	if test -f "/usr/local/Minerva/include/msql.h"; then
		mh_db_inc_dir="/usr/local/Minerva/include"
	else
		AC_MSG_ERROR(msql.h not found in /usr/local/Minerva/include; you MUST specify directory where msql.h resides using --with-dbincdir=)
	fi
else
	if test -f "$with_dbincdir/msql.h"; then
		mh_db_inc_dir="${with_dbincdir}"
	else
	AC_MSG_ERROR(msql.h not found in $with_dbincdir)
	fi
fi
MH_DB_INC="-I$mh_db_inc_dir"
AC_MSG_RESULT(found in $mh_db_inc_dir)

AC_MSG_CHECKING(location of mSQL library file)
if test "$with_dblibdir" = no; then
	if test -f "/usr/local/Minerva/lib/libmsql.a"; then
		mh_db_lib_dir="/usr/local/Minerva/lib"
	else
		AC_MSG_ERROR(libmsql.a not found in /usr/local/Minerva/lib; you MUST specify directory where libmsql.a resides using --with-dblibdir=)
	fi
else
	if test -f "$with_dblibdir/libmsql.a"; then
		mh_db_lib_dir="${with_dblibdir}"
	else
	AC_MSG_ERROR(libmsql.a not found in $with_dblibdir)
	fi
fi
MH_DB_LIB="-L$mh_db_lib_dir -lmsql"
AC_MSG_RESULT(found in $mh_db_lib_dir)
])dnl

dnl ---------------------------------------------------------------------------
dnl Setup all mSQL 2.x stuff
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_MSQL2],
[
DBINC="msql.h"
DBLIB1=""
DBLIB2=""
DBLIB3=""
DBLIB4=""
mh_db_inc_dir=""
mh_db_lib_dir=""
AC_MSG_CHECKING(location of mSQL header file)
if test "$with_dbincdir" = no; then
	if test -f "/usr/local/Hughes/include/msql.h"; then
		mh_db_inc_dir="/usr/local/Hughes/include"
	else
		AC_MSG_ERROR(msql.h not found in /usr/local/Hughes/include; you MUST specify directory where msql.h resides using --with-dbincdir=)
	fi
else
	if test -f "$with_dbincdir/msql.h"; then
		mh_db_inc_dir="${with_dbincdir}"
	else
	AC_MSG_ERROR(msql.h not found in $with_dbincdir)
	fi
fi
MH_DB_INC="-I$mh_db_inc_dir"
AC_MSG_RESULT(found in $mh_db_inc_dir)

AC_MSG_CHECKING(location of mSQL library file)
if test "$with_dblibdir" = no; then
	if test -f "/usr/local/Hughes/lib/libmsql.a"; then
		mh_db_lib_dir="/usr/local/Hughes/lib"
	else
		AC_MSG_ERROR(libmsql.a not found in /usr/local/Hughes/lib; you MUST specify directory where libmsql.a resides using --with-dblibdir=)
	fi
else
	if test -f "$with_dblibdir/libmsql.a"; then
		mh_db_lib_dir="${with_dblibdir}"
	else
	AC_MSG_ERROR(libmsql.a not found in $with_dblibdir)
	fi
fi
MH_DB_LIB="-L$mh_db_lib_dir -lmsql"
AC_MSG_RESULT(found in $mh_db_lib_dir)
])dnl

dnl ---------------------------------------------------------------------------
dnl Setup all mySQL stuff
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_MYSQL],
[
DBINC="mysql.h"
DBLIB1=""
DBLIB2=""
DBLIB3=""
DBLIB4=""
mh_db_inc_dir=""
mh_db_lib_dir=""
AC_MSG_CHECKING(location of mySQL header file)
if test "$with_dbincdir" = no; then
	if test -f "/usr/local/include/mysql/mysql.h"; then
		mh_db_inc_dir="/usr/local/include/mysql"
	else
		AC_MSG_ERROR(mysql.h not found in /usr/local/include/mysql; you MUST specify directory where mysql.h resides using --with-dbincdir=)
	fi
else
	if test -f "$with_dbincdir/mysql.h"; then
		mh_db_inc_dir="${with_dbincdir}"
	else
	AC_MSG_ERROR(mysql.h not found in $with_dbincdir)
	fi
fi
MH_DB_INC="-I$mh_db_inc_dir"
AC_MSG_RESULT(found in $mh_db_inc_dir)

AC_MSG_CHECKING(location of mySQL library file)
if test "$with_dblibdir" = no; then
	if test -f "/usr/local/lib/mysql/libmysqlclient.a"; then
		mh_db_lib_dir="/usr/local/lib/mysql"
	else
		AC_MSG_ERROR(libmysqlclient.a not found in /usr/local/lib/mysql; you MUST specify directory where libmysqlclient.a resides using --with-dblibdir=)
	fi
else
	if test -f "$with_dblibdir/libmysqlclient.a"; then
		mh_db_lib_dir="${with_dblibdir}"
	else
	AC_MSG_ERROR(libmysqlclient.a not found in $with_dblibdir)
	fi
fi
MH_DB_LIB="-L$mh_db_lib_dir -lmysqlclient"
AC_MSG_RESULT(found in $mh_db_lib_dir)
])dnl

dnl ---------------------------------------------------------------------------
dnl Setup all Openlink ODBC stuff
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_OPENLINK],
[
DBINC="isql.h"
DBLIB1=""
DBLIB2=""
DBLIB3=""
DBLIB4=""
AC_MSG_CHECKING(location of Openlink header and library files)
if test "$with_dbincdir" = no; then
	AC_MSG_ERROR(you MUST specify directory where isql.h resides using --with-dbincdir=)
else
	if test -f "$with_dbincdir/isql.h"; then
		MH_DB_INC="-I${with_dbincdir}"
	else
	AC_MSG_ERROR(isql.h not found in $with_dbincdir)
	fi
fi
if test "$with_dblibdir" = no; then
	AC_MSG_ERROR(you MUST specify directory where libiodbc.${shlib_ext} or libiodbc.a resides using --with-dblibdir=)
else
	if test -f "$with_dblibdir/libiodbc.${shlib_ext}" -o -f "$with_dblibdir/libiodbc.a"; then
	MH_DB_LIB="-L${with_dblibdir} -liodbc"
	else
	AC_MSG_ERROR(libiodbc.${shlib_ext} not found in $with_dblibdir)
	fi
fi
AC_MSG_RESULT(found)
])dnl

dnl ---------------------------------------------------------------------------
dnl Setup all Openlink UDBC stuff
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_OPENLINK_UDBC],
[
DBINC="libudbc.h"
DBLIB1=""
DBLIB2=""
DBLIB3=""
DBLIB4=""
AC_MSG_CHECKING(location of Openlink UDBC header and library files)
if test "$with_dbincdir" = no; then
	AC_MSG_ERROR(you MUST specify directory where libudbc.h resides using --with-dbincdir=)
else
	if test -f "$with_dbincdir/libudbc.h"; then
		MH_DB_INC="-I${with_dbincdir}"
	else
	AC_MSG_ERROR(libudbc.h not found in $with_dbincdir)
	fi
fi
if test "$with_dblibdir" = no; then
	AC_MSG_ERROR(you MUST specify directory where libudbc.${shlib_ext} or libudbc.a resides using --with-dblibdir=)
else
	if test -f "$with_dblibdir/libudbc.${shlib_ext}" -o -f "$with_dblibdir/libudbc.a"; then
	MH_DB_LIB="-L${with_dblibdir} -ludbc"
	else
	AC_MSG_ERROR(libudbc.${shlib_ext} or libudbc.a not found in $with_dblibdir)
	fi
fi
AC_MSG_RESULT(found)
])dnl

dnl ---------------------------------------------------------------------------
dnl Setup all Solid ODBC stuff
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_SOLID],
[
DBINC="cli0defs.h"
DBLIB1=""
DBLIB2=""
DBLIB3=""
DBLIB4=""
if test "${solid_os}x" = "x"; then
	AC_MSG_ERROR(Solid Server not supported on this platform)
fi
AC_MSG_CHECKING(location of Solid header and library files)
if test "$with_dbincdir" = no; then
	AC_MSG_ERROR(you MUST specify the directory where cli0defs.h resides using --with-dbincdir=)
else
	if test -f "$with_dbincdir/cli0defs.h"; then
		MH_DB_INC="-I${with_dbincdir}"
	else
	AC_MSG_ERROR(cli0defs.h not found in $with_dbincdir)
	fi
fi
if test "$with_dblibdir" = no; then
	AC_MSG_ERROR(you MUST specify the directory where scl${solid_os}nn.a {nn is version number} resides using --with-dblibdir=)
else
	if test -d "$with_dblibdir"; then
		mh_here=`pwd`
		cd "$with_dblibdir"
		sclf=`ls scl*.a`
		cd "$mh_here"
		if test "${sclf}x" = "x"; then
			AC_MSG_ERROR(directory $with_dblibdir does not have Solid Server client library)
		fi
		scl=`basename $sclf .a`
		MH_DB_LIB="${with_dblibdir}/${sclf}"
#		MH_DB_LIB="-L${with_dblibdir} -lscl${solid_os}"
	else
		AC_MSG_ERROR(directory $with_dblibdir not found)
	fi

#	if test -f "$with_dblibdir/libscl${solid_os}.a"; then
#	MH_DB_LIB="-L${with_dblibdir} -lscl${solid_os}"
#	else
#	AC_MSG_ERROR(libscl${solid_os}.a not found in $with_dblibdir)

fi
AC_MSG_RESULT(found)
])dnl

dnl ---------------------------------------------------------------------------
dnl Setup all SqlAnywhere stuff
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_SQLANYWHERE],
[
DBINC="unixodbc.h"
DBLIB1=""
DBLIB2=""
DBLIB3=""
DBLIB4=""
if test -n "$SQLANY" ; then
	if test "$with_dbincdir" = no; then
		MH_DB_INC="-I${SQLANY}/include"
	else
		MH_DB_INC="-I${with_dbincdir}"
	fi
	if test "$with_dblibdir" = no; then
		DBLIB1="${SQLANY}/lib/saodbc.so"
	else
		DBLIB1="${with_dblibdir}/saodbc.so"
	fi
else
	AC_MSG_ERROR(SQLANY not set, cannot continue)
fi
])dnl

dnl ---------------------------------------------------------------------------
dnl Setup all DB2 stuff
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_CHECK_DB2],
[
DBINC="sqlcli.h"
DBLIB1=""
DBLIB2=""
DBLIB3=""
DBLIB4=""
AC_MSG_CHECKING(location of DB2 header and library files)
if test "$with_dbincdir" = no; then
	AC_MSG_ERROR(you MUST specify directory where sqlcli.h resides using --with-dbincdir=)
else
	if test -f "$with_dbincdir/sqlcli.h"; then
		MH_DB_INC="-I${with_dbincdir}"
	else
	AC_MSG_ERROR(sqlcli.h not found in $with_dbincdir)
	fi
fi
if test "$with_dblibdir" = no; then
	AC_MSG_ERROR(you MUST specify directory where libdb2.${shlib_ext} or libdb2.a resides using --with-dblibdir=)
else
	if test -f "$with_dblibdir/libdb2.${shlib_ext}" -o -f "$with_dblibdir/libdb2.a"; then
	MH_DB_LIB="-L${with_dblibdir} -ldb2"
	else
	AC_MSG_ERROR(libdb2.${shlib_ext} or libdb2.a not found in $with_dblibdir)
	fi
fi
AC_MSG_RESULT(found)
])dnl

dnl ---------------------------------------------------------------------------
dnl Setup all Makefile variables
dnl ---------------------------------------------------------------------------
AC_DEFUN([MH_SETUP_MAKEFILE],
[
case "$dbtouse" in
	oracle)
		DBH="ora"
		DBC="ora"
		LDB="ora"
		BDB="ORA"
		SDB=""
		dbsrc="ora"
		MH_CHECK_ORACLE
		;;
	openlink)
		DBH="odbc"
		DBC="cli-odbc"
		LDB="odbc"
		BDB="ODBC"
		SDB="-DOPENLINK"
		dbsrc="rexxcli"
		MH_CHECK_OPENLINK
		;;
	udbc)
		DBH="udbc"
		DBC="cli-odbc"
		LDB="udbc"
		BDB="UDBC"
		SDB="-DUDBC"
		SDB=""
		dbsrc="rexxcli"
		MH_CHECK_OPENLINK_UDBC
		;;
	intersolv)
		DBH="odbc"
		DBC="cli-odbc"
		LDB="odbc"
		BDB="ODBC"
		SDB="-DINTERSOLV"
		dbsrc="rexxcli"
		;;
	sybase)
		DBH="syb"
		DBC="syb"
		LDB="syb"
		BDB="SYB"
		SDB=""
		dbsrc="syb"
		MH_CHECK_SYBASE
		;;
	sqlanywhere)
		DBH="saw"
		DBC="cli-odbc"
		LDB="saw"
		BDB="SAW"
		SDB=""
		dbsrc="rexxcli"
		MH_CHECK_SQLANYWHERE
		;;
	msql)
		DBH="min"
		DBC="min"
		LDB="min"
		BDB="MIN"
		SDB=""
		dbsrc="min"
		MH_CHECK_MSQL
		;;
	msql2)
		DBH="min2"
		DBC="min2"
		LDB="min"
		BDB="MIN"
		SDB=""
		dbsrc="min"
		MH_CHECK_MSQL2
		;;
	mysql)
		DBH="my"
		DBC="my"
		LDB="my"
		BDB="MY"
		SDB=""
		dbsrc="my"
		MH_CHECK_MYSQL
		;;
	db2)
		DBH="db2"
		DBC="cli-odbc"
		LDB="db2"
		BDB="DB2"
		SDB=""
		dbsrc="rexxcli"
		MH_CHECK_DB2
		;;
	solid)
		DBH="sol"
		DBC="cli-odbc"
		LDB="sol"
		BDB="SOL"
		SDB="-DSS_UNIX -DSOLID_SERVER"
		dbsrc="rexxcli"
		MH_CHECK_SOLID
		;;
	*)
		AC_MSG_ERROR("No database specified to be configured")
		;;
esac
AC_SUBST(DBH)
AC_SUBST(DEFS)
AC_SUBST(DBC)
AC_SUBST(LDB)
AC_SUBST(BDB)
AC_SUBST(SDB)
AC_SUBST(dbsrc)
AC_SUBST(MH_DB_LIB)
AC_SUBST(MH_DB_INC)
AC_SUBST(DBLIB1)
AC_SUBST(DBLIB2)
AC_SUBST(DBLIB3)
AC_SUBST(DBLIB4)
AC_SUBST(INCLUDE_DB_MAKEFILE)
])dnl
