/*
  Ŀ
   MSKCHK.C   (C) Copyright 1992, 1994  Bruce E. Hgman               
                  All Rights Reserved.                                
  
  MSKCHK - Function to scan a given area for a match against a mask
  string containing wild cards and constant characters.  This is an
  extension of the usual DOS wild-card filespec matching, as it permits
  imbedded '*' and '?' and the mask is an arbitrary length.

  Input:  mask, mask_len, area, area_len, qmark, asterisk
          'qmark' is single-wild-card char, 'asterisk' is 0 to n wild
          chars.

  Calling as REXX function:

     mRC = MaskCheck(mask_string,area_string,
                    [question_mark],[asterisk],
                    [mask_length],[area_length])

     The length arguments are present to permit use of strings
     as arguments.  If the length argument(s) is omitted, then
     the default length value used is the length of the string
     as passed from REXX.

  Function added as an external REXX function returning codes:

     0:  strings match
     1:  strings do not match
     2:  error in input parameters
*/
#define INCL_RXFUNC
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <rexxsaa.h>
#include <string.h>
#define ERROR  -1
#define WARNING 4
#define DONE   0x20 /* Whole mask is complete */
#define MATCH  0x10 /* Whole mask is found/matched */
#define FAIL   0x08 /* Whole mask is not found */
#define FLTFND 0x04 /* Mask float substr found */
#ifndef RXNULLSTRING
#define RXNULLSTRING(r)      (!(r).strptr)
#define RXZEROLENSTRING(r)   ((r).strptr && !(r).strlength)
#define RXVALIDSTRING(r)     ((r).strptr && (r).strlength)
#define RXSTRLEN(r)          (RXNULLSTRING(r)?0L:(r).strlength)
#define RXSTRPTR(r)          (r).strptr
#define MAKERXSTRING(r,p,l)  {(r).strptr=(PCH)p;(r).strlength=(ULONG)l;}
#endif
#ifdef __WATCOMC__
#pragma aux mskchk "mskchk";
#pragma aux MaskCheck "MaskCheck";
#endif
#ifndef FALSE
#define FALSE  0
#endif
#ifndef TRUE
#define TRUE  ~FALSE
#endif
#include "mskchk.h"
  unsigned long  iflg        = 0;
  unsigned long  irc         = 0;
  unsigned long  iAreaOffset = 0;
  unsigned long  iMaskOffset = 0;
           char *cMask       = NULL;
  unsigned long  iMaskLen    = 0;
           char *cArea       = NULL;
  unsigned long  iAreaLen    = 0;
           char *cQ          = NULL;
           char *cA          = NULL;
/*
  MaskCheck
*/
  RexxFunctionHandler MaskCheck;
  ULONG MaskCheck(
     PUCHAR  Name,                      /* name of the function     */
     ULONG   Argc,                      /* number of arguments      */
     RXSTRING Argv[],                   /* list of argument strings */
     PSZ      Queuename,                /* current queue name       */
     PRXSTRING Retstr)                  /* returned result string   */
{
  RXSTRING  RxUQMrk;
  RXSTRING  RxUAstr;

  RXSTRING *Rx_Mask=NULL;
  RXSTRING *Rx_Area=NULL;
  RXSTRING *Rx_QMrk=NULL;
  RXSTRING *Rx_Astr=NULL;
  RXSTRING *Rx_MLen=NULL;
  RXSTRING *Rx_ALen=NULL;

  ULONG RxMLen=0;
  ULONG RxALen=0;

  char QuesMark[]="?";
  char AstrMark[]="*";

  char RetCodes[4]="012";
  ULONG RET_OK=0;
  ULONG RET_NO=1;
  ULONG RET_ARG=2;
  ULONG Return_Code = RET_OK;

  /* initialize default values */
  RxUQMrk.strptr=QuesMark; RxUQMrk.strlength=strlen(QuesMark);
  RxUAstr.strptr=AstrMark; RxUAstr.strlength=strlen(AstrMark);
  Rx_QMrk=&RxUQMrk;  Rx_Astr=&RxUAstr;

  /*
    Notes:  if return code is zero, then the REXX return string
    contains valid data.  If return code is not zero, then the
    REXX interface raises the "invalid call to routine" condition,
    REXX error 40.

    Calling sequence:

    mRC = MaskCheck(mask_string,area_string,
                   [question_mark],[asterisk],
                   [mask_length],[area_length])
  */
  if ( Argc < 2 ) Return_Code = RET_ARG;
  else
  {
    if (!(RXNULLSTRING(Argv[0]) | RXZEROLENSTRING(Argv[0])))
    { Rx_Mask=&(Argv[0]);
      RxMLen =(*Rx_Mask).strlength;
    }
    if (!(RXNULLSTRING(Argv[1]) | RXZEROLENSTRING(Argv[1])))
    { Rx_Area=&(Argv[1]);
      RxALen =(*Rx_Area).strlength;
    }
    if (Argc > 2)
    { if (!(RXNULLSTRING(Argv[2]) | RXZEROLENSTRING(Argv[2])))
      { Rx_QMrk = &(Argv[2]);
      }
      if (Argc > 3)
      { if (!(RXNULLSTRING(Argv[3]) | RXZEROLENSTRING(Argv[3])))
        { Rx_Astr = &(Argv[3]);
        }
        if (Argc > 4)
        { if (!(RXNULLSTRING(Argv[4]) | RXZEROLENSTRING(Argv[4])))
          { RxMLen = strtoul(Argv[4].strptr,NULL,10);
          }
          if (Argc > 5)
          { if (!(RXNULLSTRING(Argv[5]) | RXZEROLENSTRING(Argv[5])))
            { RxALen  = strtoul(Argv[5].strptr,NULL,10);
    } } } } }
    if ((Rx_Mask==NULL) | (Rx_Area==NULL) | (Rx_QMrk==NULL) |
        (Rx_Astr==NULL) | (RxMLen ==0)    | (RxALen ==0))
    { Return_Code = RET_ARG;
    }
    else
    { if ((Return_Code = mskchk((*Rx_Mask).strptr,RxMLen,
        (*Rx_Area).strptr,RxALen, (*Rx_QMrk).strptr,
        (*Rx_Astr).strptr))!=0)
        Return_Code=RET_NO;
    }
  }
  *(Retstr->strptr) = RetCodes[Return_Code];
  *((Retstr->strptr)+1) = '\0';
  Retstr->strlength=1;
  return 0;
}

/*
  AString
  Current mask character is "*" wild card.
  (For "?" that appear after initial "*", process these.)
  We must scan mask string for its terminator.
*/
  static void AString (void)
{ unsigned long ixMaskOffset,      /* ptr '*' 2 in      *XXX* */
      iyMaskOffset;
  unsigned long ixAreaOffset, iyAreaOffset;
  unsigned long iMatchCount, iwMaskLen;
  while (TRUE)                     /* Process '*' and '?' at start */
  { if (iflg & DONE) break;

    if ((*cA != *(cMask+iMaskOffset))
    &&  (*cQ != *(cMask+iMaskOffset))) break;

    while (*cA == *(cMask+iMaskOffset))
    { iMaskOffset++;
      if (iMaskOffset >= iMaskLen) { iflg |= DONE+MATCH; break;}
    }
    while (*cQ == *(cMask+iMaskOffset))
    { if (iAreaOffset >= iAreaLen) { iflg |= DONE+FAIL; break;}
      else iAreaOffset++;
      if ((++iMaskOffset >= iMaskLen) && (iAreaOffset >= iAreaLen))
      { iflg |= DONE+MATCH; break;}
    }
  }
  if (iflg & DONE) return;

    /* Look for mask string terminator. */
    /* if no  terminator:  mask ends:    '*' marks suffix */
    /* if '*' terminator:  mask float:   process floating mask */

  ixMaskOffset=iMaskOffset;
  while (++ixMaskOffset < iMaskLen)
  { if (*cA == *(cMask+ixMaskOffset)) break;}
  if (ixMaskOffset >= iMaskLen)         /* Mask is suffix */
  { iyMaskOffset = ixMaskOffset-1;      /* ptr last char in mask */
    iyAreaOffset = iAreaLen - 1;        /* ptr last char in area */
    while (TRUE)
    { if (iflg & DONE) break;
      if (iyMaskOffset < iMaskOffset) iflg |= DONE+MATCH;
      else
      { if (iyAreaOffset < iAreaOffset) iflg |= DONE+FAIL;
        else
        { if (*(cMask+iyMaskOffset) != *(cArea+iyAreaOffset))
          { if (*(cMask+iyMaskOffset) == *cQ)
            {iyMaskOffset--; iyAreaOffset--;}
            else iflg |= DONE+FAIL;
      } } }
      iyMaskOffset--; iyAreaOffset--;
    }
    goto AStringReturn;                 /* return from AString */
  }

  /* We have case of imbedded *xxx* mask string */

  iwMaskLen=ixMaskOffset-iMaskOffset;   /* length of *xxx* string or zero */
  ixAreaOffset=iAreaOffset;             /* save ptr area */
  iMatchCount=0;                        /* count of matched chars */
  while (ixAreaOffset < iAreaLen)       /* stop at end of area if not sooner */
  { if (iwMaskLen <= 0) break;          /* no-op loop if length is zero */
    if (iMatchCount > 0) break;         /* stop loop if here and not zero */
    iyAreaOffset = ixAreaOffset;
    iyMaskOffset = iMaskOffset;
    while (iyMaskOffset < ixMaskOffset)
    { if (iMatchCount >= iwMaskLen) break; /* stop if matches >= mask length */
      if (*(cMask+iyMaskOffset) == *(cArea+iyAreaOffset))
      { iyMaskOffset++; iyAreaOffset++; iMatchCount++; }
      else
      { if (*(cMask+iyMaskOffset) == *cQ)
        { iMatchCount++; iyAreaOffset++; iyMaskOffset++; }
        else { iMatchCount = 0; break; }
      }
    }
    if (iMatchCount < iwMaskLen) iMatchCount = 0;
    ixAreaOffset++;
  }
  if ((iMatchCount >= iwMaskLen) && (iwMaskLen > 0))
  { iflg |= FLTFND;
    iMaskOffset = ixMaskOffset; iAreaOffset = iyAreaOffset;
    if (iMaskOffset >= iMaskLen) iflg |= DONE+MATCH;
  }
AStringReturn:
  return;
}
/*
  PrefixString
*/
  static void PrefixString (void)
{ unsigned long ipMaskOffset;
  ipMaskOffset = iMaskOffset;
  while (++ipMaskOffset < iMaskLen)
  { if (*cA == *(cMask+ipMaskOffset)) break;}
  if (ipMaskOffset > iAreaLen) { iflg |= DONE+FAIL; return;}
  while (TRUE)
  { if (iflg & DONE) break;
    if (*cA == *(cMask+iMaskOffset)) break;
    if (iAreaOffset >= iAreaLen)
    { if (iMaskOffset >= iMaskLen) iflg |= DONE+MATCH; break;}
    if (iMaskOffset >= iMaskLen)
    { if (iAreaOffset >= iAreaLen) iflg |= DONE+MATCH;
      else iflg |= DONE+FAIL; break;
    }
    if (*(cMask+iMaskOffset) != *(cArea+iAreaOffset))
    { if (*cQ != *(cMask+iMaskOffset))
      { iflg |= DONE+FAIL; break;}
    }
    iMaskOffset++; iAreaOffset++;
  }
  return;
}


/*
  mskchk
*/
  unsigned long mskchk ( char *msk,     /* ptr mask string   */
                unsigned long msklen,   /* length of mask    */
               char *achk,              /* ptr area string   */
               unsigned long alen,      /* length of area    */
               char *q,                 /* ptr qmark char    */
               char *a )                /* ptr asterisk char */

{ cMask=msk; iMaskLen=msklen; cArea=achk; iAreaLen=alen; cQ=q; cA=a;
  irc=0; iflg=0; iMaskOffset=0; iAreaOffset = 0;
  if (msk==NULL||achk==NULL||q==NULL||a==NULL||msklen<=0||alen<=0)
  { return ERROR;}                      /* Error if null argument(s) */

  /* remove block of code here
  while (*(cArea+iAreaOffset) == ' ')*/ /* Scan for 1st non-blank *//*
  { iAreaOffset++; if (iAreaOffset >= iAreaLen) return WARNING;}    */
    /* Scan for last non-blank and non-null */                      /*
  while (*(cArea+iAreaLen-1) == ' ' || *(cArea+iAreaLen-1) == '\0')
  { iAreaLen--; if (iAreaLen <= iAreaOffset) return ERROR;}         */

  while (!(iflg & DONE))
  { if (iMaskOffset >= iMaskLen) break;
    while (*cQ == *(cMask+iMaskOffset)) /* while '?' in mask */
    { if (iflg & DONE) break;
      iMaskOffset++; iAreaOffset++;
      if (iAreaOffset >= iAreaLen)          /* if area is exhausted */
      { if (iMaskOffset >= iMaskLen)        /* and mask is exhausted */
        { iflg |= DONE+MATCH;}               /* we're done and matched */
        else
        { if ((iMaskOffset+1>=iMaskLen) && (*cA == *(cMask+iMaskOffset+1)))
          { iflg |= DONE+MATCH;}            /* if the last mask char is ast */
          else                              /* we're matched */
          { iflg |= DONE+FAIL;}             /* otherwise failed */
        } break;
      }
      if (iMaskOffset >= iMaskLen)
      { iflg |= DONE;
        if (iAreaOffset < iAreaLen)
        { if (*cQ == *(cMask+iMaskOffset-1)) iflg |= FAIL; }
        break;
      }
    }
    if (iflg & DONE) break;
    if (*cA == *(cMask+iMaskOffset))    /* start of float str */
    { iMaskOffset++;
      if (iMaskOffset >= iMaskLen)          /* if mask is exhausted */
      { iflg |= DONE;
        if (iAreaOffset < iAreaLen)         /* but area is not      */
        { if (*cA==*(cMask+iMaskOffset-1))  /* but last mask char is asterisk */
          { iflg |= MATCH;}
        }
        else  iflg |= MATCH;           /* area is complete */
        break;
      }
      AString();
    }
    else PrefixString();
  }
  if (iflg & FAIL) irc = 8;
  else irc = 0;
  /* printf("MSKCHKRC=%i\n",irc); */
  return irc;
}
