/* RXRUN.CMD Copyright (c) Bruce Eric Hogman 1995. All Rights Reserved.

   Run program using DosStartSession

      1. program executable (filespec)
      2. program window list title (up to 32 bytes)
      3. program parameters (up to 1000 bytes)
      4. session type (DEFAULT,OS2,PM,DOS,WINOS2) (default: DEFAULT)
      5  session control (DEFAULT/MAX/MIN)
      6. current working directory on drives
      7. current directory in which to start
      8. updates to environment variables or create new ones

      Alternate command line operands:
      /EXE:   executable filespec
      /TIT:   title of window session in quotes
      /PRM:   parameters to pass to program, in quotes
      /TYP:   type of session: OS2/DOS/PM/WINOS2/DEFAULT
      /CTL:   DEFAULT/MAX/MIN
      /CWD:   drive:\path;drive:\path;...
      /DIR:   drive:\path   (this is STARTUPDIR)
      /ENV:   "varname=+c:\path" "varname=string+"
              append or prepend string to existing variable.
              Use BEGINLIBPATH and ENDLIBPATH to alter LIBPATH.
*/
/* parse source command */
pgm_rc = 0
parse source osname cmdname ourname
ourpath = filespec('d',ourname)||filespec('p',ourname)
i_am_cmd = abbrev(cmdname,'CMD')

/* load rexxutil functions */
if rxfuncquery('sysfiletree') then
   do
      call rxfuncadd 'sysloadfuncs','rexxutil','sysloadfuncs'
      call sysloadfuncs
   end

/* load rxrnx.dll */
if rxfuncquery('RXSESSIONRUN') then
   if rxfuncadd('RXSESSIONRUN','rxrnx','RXSESSIONRUN') then
      if rxfuncadd('RXSESSIONRUN',ourpath'rxrnx.dll','RXSESSIONRUN') then
         do
            bootdrive = left(value('COMSPEC',,'OS2ENVIRONMENT'),2)
            call sysfiletree bootdrive||'\rxrnx.dll','dlls.','FSO'
            if dlls.0 > 0 then
               if rxfuncadd('RXSESSIONRUN',dlls.1,'RXSESSIONRUN') then
                  do
                     say 'RXRUN ERROR:  RXRNX.DLL not found.'
                     exit 255
                  end
         end

if \rxfuncquery('RXSESSIONRUN') then say 'RXRNX .dll loaded'

/* save local session environment */
call setlocal

/* parse command line operands or arguments passed to function */
parse arg command_line
cmd_upper = translate(command_line)

select
   when 0 = arg() then
      do
         if i_am_cmd then
            say 'RXRUN ERROR: no arguments'
         call exit 255
      end
   when i_am_cmd then
      do
         call parse_cmd command_line
      end
   otherwise
      call parse_args arg(1),arg(2),arg(3),arg(4),arg(5),arg(6),arg(7),arg(8)
end

call set_cwd cwd
call directory(startupdir)
call env_string env
say 'call RXSESSIONRUN('pgmname','title','parms','sess','ctl')'
if rxfuncquery('RXSESSIONRUN') then
   do
      myrc = rxfuncadd('RXSESSIONRUN','rxrnx','RXSESSIONRUN')
      say 'Load .dll rc='myrc
   end
pgm_rc = RXSESSIONRUN(pgmname,title,parms,sess,ctl)
call endlocal
call rxfuncdrop 'RXSESSIONRUN'
say 'RXRUN RC='pgm_rc
return pgm_rc

exit: procedure
   call endlocal
   exit arg(1)

/*
Ŀ
 parse_args:                             
                                         
 for FUNCTION invoke of rxrun, parses    
 arguments 1 thru 8 into variables       

*/
parse_args:
   pgmname = translate(arg(1))

   title   = strip(arg(2))
   if '' = title then title = pgmname

   parms = strip(arg(3))

   sess  = strip(translate(arg(4)))
   select
      when 'OS2'   = sess then nop
      when 'OS2FS' = sess then nop
      when 'DOS'   = sess then nop
      when 'DOSFS' = sess then nop
      when 'PM'    = sess then nop
      when abbrev(sess,'WIN') then sess = 'WINOS2'
      otherwise sess = 'DEFAULT'
   end

   ctl   = strip(translate(arg(5)))
   select
      when 'MAX' = ctl then nop
      when 'MIN' = ctl then nop
      otherwise ctl = 'DEFAULT'
   end

   cwd   = strip(translate(arg(6)))

   startupdir = strip(translate(arg(7)))
   if '' = startupdir then startupdir = directory()

   env = strip(arg(8))

   return

/*
Ŀ
 parse_cmd:                              
                                         
 for CMD invoke of rxrun, parse command  
 line arguments into variables           

*/
parse_cmd:
   parse arg command_line
   pgmname = ''
   title   = ''
   sess    = 'DEFAULT'
   ctl     = 'DEFAULT'
   cwd     = ''
   startupdir = directory()
   env     = ''
   parms   = ''

   cmdupper = translate(command_line)

   /* /exe:pgmspec */
   kexe = pos('/EXE:',cmdupper)
   xstr = substr(cmdupper,kexe+5)
   parse var xstr pgmname junk

   /* /tit:" title strings " */
   ktit = pos('/TIT:"',cmdupper)
   if ktit > 0 then
      do
         xstr = substr(command_line,ktit+6)
         parse var xstr title '"' junk
      end
   else title = pgmname

   /* /typ:word */
   ktyp = pos('/TYP:',cmdupper)
   if ktyp > 0 then
      do
         xstr = substr(cmdupper,ktyp+5)
         parse var xstr sess junk
         select
            when 'OS2'   = sess then nop
            when 'OS2FS' = sess then nop
            when 'DOS'   = sess then nop
            when 'DOSFS' = sess then nop
            when 'PM'    = sess then nop
            otherwise sess = 'DEFAULT'
         end
      end

   /* /ctl:word */
   kctl = pos('/CTL:',cmdupper)
   if kctl > 0 then
      do
         xstr = substr(cmdupper,kctl+5)
         parse var xstr ctl junk
         select
            when 'MAX' = ctl then nop
            when 'MIN' = ctl then nop
            otherwise ctl = 'DEFAULT'
         end
      end

   /* /cwd:drive:\path;drive:\path */
   kcwd = pos('/CWD:',cmdupper)
   if kcwd > 0 then
      do
         xstr = substr(cmdupper,kcwd+5)
         parse var xstr cwd junk
      end

   /* /dir:drive:\path */
   kdir = pos('/DIR:',cmdupper)
   if kdir > 0 then
      do
         xstr = substr(cmdupper,kdir+5)
         parse var xstr startupdir junk
      end

   /* /env:("variable=string" "variable=string") */
   kenv = pos('/ENV:["',cmdupper)
   if kenv > 0 then
      do
         xstr = substr(cmdupper,kenv+6)
         kr = pos('"]',xstr)
         env = left(xstr,kr)
      end

   /* /prm:" strings " */
   kprm = pos('/PRM:"',cmdupper)
   if kprm > 0 then
      do
         xstr = substr(cmdupper,kprm+6)
         kr = pos('" ',xstr)
         if kr = 0 then
            do
               kr = pos('"',xstr)
               if kr = 0 then
                  kr = length(xstr)
            end
         xstr = substr(command_line,kprm+6,kr)
         parms = xstr
      end

   return

/*
Ŀ
 env_string                              
                                         
 updates or sets environment variable    

*/
env_string:
   parse arg envstring
   xstr = envstring
   do while xstr <> ''
      parse var xstr . '"' envitem '"' xstr
      envitem = strip(envitem)
      parse upper var envitem word1 others
      if 'SET' = word1 then nop
      else envitem = 'SET' envitem
      parse var envitem set variable '=' junk
      if 0 < pos('+',envitem) then
         do
            prevval = value(variable,,'OS2ENVIRONMENT')
            if 0 < pos('=+',envitem) then isprepend = 0
            else isprepend = 1
            kp = pos('+',envitem)
            if isprepend then
               do
                  envitem = left(envitem,length(envitem)-1)
                  envitem = envitem||prevval
               end
            else
               do
                  lr = left(envitem,kp-1)
                  rr = substr(envitem,kp+1)
                  envitem = lr||prevval||rr
               end
         end
      envitem
   end
   return

/*
Ŀ
 set_cwd:                                
                                         
 sets current directory on a drive       

*/
set_cwd:
   arg xstr
   do while xstr <> ''
      parse var xstr newcwd ';' xstr
      if '' = newcwd then leave
      'CD' newcwd
   end
   return
