/* RxOKBox - REXX program to display a message box to inform the user
   of a long-running task that must be done by the parent REXX program,
   and then disappear once the parent task has completed.
   RxOKBox differs from RxMsgBox because it remains displayed until
   the user hits ENTER key with focus in RxOKBox session window.

Ŀ
                                                                     
 Copyright (C) 1994,1995                                             
                    Bruce E. Hgman All Rights Reserved.             
                    1338 Avocado Isle                                
                    Fort Lauderdale, FL 33315 USA         1995-10-31 
                                                                     
 e-Mail:  compuserve 72050,1327                                      


   Syntax of call to rxokbox:
     call rxokbox queue_name_input queue_name_response bkcolor

   The calling program creates two queues:  one for passing data to
   rxokbox, the other for passing the response back to parent program.

   This removes any need for coordinating queue content.
   The parent task queues data lines to the queue passed to rxokbox,
   then invokes rxokbox using the start command:

   '@start "OK'qnamepassed'" /c /min /win rxokbox' qnamepassed qnameresp

   The rxokbox task starts and displays the lines contained in
   qnamepassed.  rxokbox then waits for user to hit ENTER.
   rxokbox then sets qnameresp as current queue and queues a line of
   data containing qnamepassed 'OK' back to parent task.
*/
if 0 < RxFuncQuery('SysLoadFuncs') then
   do
      Call RxFuncAdd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs';
      Call SysLoadFuncs;
   end

arg QNameInput QNameOutput BKColor

if QNameInput = '' then
   do
      say 'RXOKBOX null queuename input'; return 255
   end

if QNameOutput= '' then
   do
      say 'RXOKBOX null queuename output'; return 255
   end

if BKColor = '' then BKColor = '44'
select
   when BKColor = 'BLACK'    then BKColor = '40'
   when BKColor = 'RED'      then BKColor = '41'
   when BKColor = 'GREEN'    then BKColor = '42'
   when BKColor = 'YELLOW'   then BKColor = '43'
   when BKColor = 'BLUE'     then BKColor = '44'
   when BKColor = 'MAGENTA'  then BKColor = '45'
   when BKColor = 'CYAN'     then BKColor = '46'
   when left(BKColor,1)='4'  then nop;
   otherwise BKColor = '44'
end

/*
  Set named queue as active queue
*/
ZName = RxQueue("Set",QNameOutput);
OName = RxQueue("Get")
if OName \= QNameOutput then
   do
      say 'TName='TName 'QNameOutput='QNameOutput
      say 'Failure in RxQueue Set queue named:' QNameOutput
      Call SysSleep 5
      exit 255
   end
XName = RxQueue("Set",QNameInput)
TName = RxQueue("Get")
if TName \= QNameInput then
   do
      say 'TName='TName 'QNameInput='QNameInput
      say 'Failure in RxQueue Set queue named:' QNameInput
      Call SysSleep 5
      exit 255
   end
j = 0
do while 0 < queued()
   j = j +1
   parse pull MsgString.j
end

call charout ,d2c(27)'[0;1;37;'BKColor'm'/* bright white on  x */
MsgString.0 = j
j = j+2

'@mode 80,'j                          /* make a small window */
call charout ,d2c(27)'[2J'd2c(27)'[2;1H'
do i = 1 to MsgString.0
   say MsgString.i
end

/* Set queue to SESSION queue to pull from keyboard */
Junk = RxQueue("Set",ZName)
if 0 < RxFuncQuery('RXSESSIONFOCUS') then
   do
      Call RxFuncAdd 'RXSESSIONFOCUS','RXRNX','RXSESSIONFOCUS'
   end
if \rxfuncquery('RXSESSIONFOCUS') then call rxsessionfocus '*'
pull reply

/* Set queue to output name to respond to parent task */
/* response line in queue contains original input queuename 'OK' */
Junk = RxQueue("Set",OName)
queue QNameInput 'OK'
'@exit'
