/* IVP.CMD - installation verification program
   tests functional operation of all parts of RXRUN package
*/
if rxfuncquery('syssleep') then
   do
      call rxfuncadd 'sysloadfuncs','rexxutil','sysloadfuncs'
      call sysloadfuncs
   end
parse source osname cmdname ourname
say osname cmdname ourname
say ''
say 'Installation Verification Program'
say ''
say 'Drop all functions.'
call dropfunc 'rxrloadfuncs'
call dropfunc 'rxsessionfocus'
call dropfunc 'rxsessionhide'
call dropfunc 'rxsessionmin'
call dropfunc 'rxsessionqtitle'
call dropfunc 'rxsessionrun'
call dropfunc 'rxsessiontitle'
call dropfunc 'rxsessionvisible'
call syssleep 3
call syscls

call rxfuncadd 'rxrloadfuncs','rxrnx','rxrloadfuncs'
call rxrloadfuncs

call chekfunc 'rxsessionfocus'
call chekfunc 'rxsessionhide'
call chekfunc 'rxsessionmin'
call chekfunc 'rxsessionqtitle'
call chekfunc 'rxsessionrun'
call chekfunc 'rxsessiontitle'
call chekfunc 'rxsessionvisible'
call syssleep 3
call syscls

say ''
say 'TEST:  SET WINDOW LIST SESSION TITLE'
say ''
sesstitle = RXSESSIONQTITLE()
say 'Session title is' sesstitle
say ''
say 'Enter new title for session.'
do while queued()>0;pull reply;end
parse pull title
say 'RXSESSIONTITLE to change title in 5 seconds'
say 'Hit CTRL+ESC to bring up switch window now'
say 'Note that the title on this session title bar may not change.'
call syssleep 5
call rxsessiontitle title
call syssleep 5
say 'Hit ENTER to restore previous title.'
say 'Hit CTRL+ESC to see change in title in window list.'
do while queued()>0;pull reply;end
pull repl
call rxsessiontitle sesstitle
say ''
say 'TEST:  SET FOCUS TO SESSION WINDOW'
say ''
say 'Tests: rxsessionfocus to switch focus to another session by name.'
say 'Please enter a word or phrase found in one of the running sessions.'
say 'Your response will be passed to rxsessionfocus as: *RESPONSE*'
say 'Hit CTRL+ESC to bring up window list to see titles.'
bactive = 0
do while \bactive
   pull reply
   if reply = '' then iterate
   isactive = rxsessionfocus('*'reply'*','/r')
   select
       when isactive = 1 then
          do
             say 'That session is active'
             bactive = 1
          end
       when isactive = 2 then
          do
             say 'Your response of' reply 'matched no session.'
             say 'Bring up window list and check names active.'
             say 'Enter another name.'
          end
       otherwise say 'Internal error:' isactive 'unexpected RC from rxsessionfocus'
   end
end
if isactive = 1 then
   do
      say 'I will now switch focus to that session in 2 seconds.'
      say 'I will return focus to this session after 10 seconds.'
      call syssleep 2
      call rxsessionfocus '*'reply'*'
      call syssleep 10
      call rxsessionfocus '*'
   end
say ''
say 'OK, focus is back here again.'
say ''
say 'TEST:  MINIMIZE SESSION'
say ''
do while queued()>0;pull reply;end
say 'Tests: rxsessionmin to minimize window upon your hitting ENTER'
say 'Bring up window list using CTRL+ESC to see this session name'
say 'Session should be visible in window list.'
say 'The window will return in 10 seconds.'
pull reply
call rxsessionmin  1
call syssleep 10
call rxsessionmin  0
say 'return from rxsessionmin.'
say ''
say 'TEST:  HIDE SESSION WINDOW'
say ''
do while queued()>0;pull reply;end
say 'Tests: rxsessionhide to hide window upon your hitting ENTER'
say 'Bring up window list using CTRL+ESC to see this session name'
say 'Session should not be visible in window list.'
say 'The window will return in 10 seconds.'
pull reply
call rxsessionhide 1
call syssleep 10
call rxsessionhide 0
say 'return from rxsessionhide.'
say ''
say 'TEST:  MAKE SESSION INVISIBLE AND REMOVE FROM WINDOW LIST'
say ''
do while queued()>0;pull reply;end
say 'Tests: rxsessionvisible to hide window upon your hitting ENTER'
say 'Bring up window list using CTRL+ESC to see this session name'
say 'Session should not be visible in window list.'
say 'The window will return in 10 seconds.'
pull reply
call rxsessionvisible 0
call syssleep 10
call rxsessionvisible 1
say 'return from rxsessionvisible'
say ''
say 'TESTING COMPLETED.'
say ''
call rxfuncdrop 'rxsessionfocus'
call rxfuncdrop 'rxsessionhide'
call rxfuncdrop 'rxsessionmin'
call rxfuncdrop 'rxsessionqtitle'
call rxfuncdrop 'rxsessionrun'
call rxfuncdrop 'rxsessiontitle'
call rxfuncdrop 'rxsessionvisible'
say 'IVP processing completed.'
say 'If the window processing was displayed OK, then installation works.'
say ''
say 'Please read the user guide using VIEW RXRUN.'
say 'Article on DosStartSession is readable using VIEW DOSSTART.'
say ''
say 'Please send your comments to the author at: 72050.1327@compuserve.com'
say ''
say 'Have a nice day.'
exit
dropfunc: procedure
   modnm = arg(1)
   if rxfuncquery(modnm) then
      do while 0=rxfuncquery(modnm)
        do while 0=rxfuncdrop(modnm)
           say 'dropped' modnm
        end
      end
   else
      do
         say 'Function' modnm 'not defined'
         if \rxfuncdrop(modnm) then say 'Function' arg(1) 'dropped.'
      end
   return

loadfunc: procedure
   modnm = arg(1)
   if rxfuncadd(modnm,'rxrnx',modnm) then
      say 'rxfuncadd('modnm') failed rc=1'
   else
      say 'rxfuncadd('modnm') OK'
   return

chekfunc: procedure
   modnm = arg(1)
   if rxfuncquery(modnm) then
      say 'Function' arg(1) 'not defined.'
   else say 'function' arg(1) 'defined OK.'
   return

