/*
   RxMP:  REXX Multiprocessing Package

   INPATH   REXX to search PATH for given file name.
   Version 2.0 - uses RXRUN package RXRNX.DLL functions

Ŀ
                                                                     
 Copyright (C) 1994 Bruce E. Hgman    All Rights Reserved.          
                    1338 Avocado Isle                                
                    Fort Lauderdale, FL 33315 USA         1995-10-31 
                                                                     
 e-Mail:  compuserve 72050,1327                                      


   See the .doc file for the RXMP package for license details.
*/
bRXRNX = 0
MsgStrings.0 = 2
MsgStrings.2 = 'Hit ENTER to close this window.'
MsgStringLast= MsgStrings.2
FileSepChar = '&'

/*
   Load REXXUTIL functions if not already
*/
if 0 < RxFuncQuery('SysLoadFuncs') then
   do;
      Call RxFuncAdd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs';
      Call SysLoadFuncs;
   end;
else nop
if 0 < RxFuncQuery('RXSESSIONFOCUS') then
   do
      urc = rxfuncadd('RXRLOADFUNCS','RXRNX','RXRLOADFUNCS')
      if urc = 0 then
         do
            call rxrloadfuncs
            bRXRNX = 1
         end
   end
else bRXRNX = 1

/*
  Get our location in the file system
*/
parse source OSName CmdName OurName
BKColor='BLUE'

/*
  Parse the input arguments into variables
  NOTE:  The code following supports use of this program as both command
         line and external function, with or without commas between
         arguments passed.
*/
arg arg1,arg2,arg3;  narg=arg()
if narg > 1 then
   do
      arga=arg1;  argb=arg2;  argc=arg3;
   end
else
if 0<pos(',',arg1) then parse var arg1 arga ',' argb ',' argc
else                    parse var arg1 arga     argb     argc

FileNameSought = arga;  PATHVARIABLE = argb;  OTHERARGS = argc;

/* arg FileNameSought PATHVARIABLE OTHERARGS */
if 0 < pos('?',FileNameSought||PATHVARIABLE||OTHERARGS) then
   do
      call Syntax
      return ''
   end

bSilent = 0
if 0 < pos('/S',PATHVARIABLE||OTHERARGS) then
   do
      bSilent=1
      qpos = pos('/S',PATHVARIABLE)
      if qpos > 0 then
         do
            lstr = left(PATHVARIABLE,qpos-1)
            rstr = substr(PATHVARIABLE,qpos+2)
            PATHVARIABLE=lstr||rstr
         end
   end

bDoALL = 0
if 0 < pos('/A',PATHVARIABLE||OTHERARGS) then
   do
      bDoALL =1
      qpos = pos('/A',PATHVARIABLE)
      if qpos > 0 then
         do
            lstr = left(PATHVARIABLE,qpos-1)
            rstr = substr(PATHVARIABLE,qpos+2)
            PATHVARIABLE=lstr||rstr
         end
   end

if FileNameSought = '' then
   do
      Call Syntax
      return ''
   end

if PATHVARIABLE = '' then PATHVARIABLE = 'PATH'

bMultipleFiles=0
BuildString = ''
MsgHighwater=0
FileNameResult=SysSearchPath(PATHVARIABLE,FileNameSought)
if 0 < pos('*',FileNameResult) | ,
   0 < pos('?',FileNameResult) | ,
   bDoALL then
   do
      Call ParsePath
      do j = 1 to ParsePath.0
         Call SysFileTree ParsePath.j,'FileStem','FO'
         if FileStem.0 > 0 then bMultipleFiles=1
         do i=1 to FileStem.0
            if BuildString = '' then BuildString = FileStem.i
            else BuildString = BuildString || FileSepChar || FileStem.i
         end
         k = MsgHighWater+1
         do i = 1 to FileStem.0
            MsgStrings.k = FileStem.i
            MsgHighWater = k
            k = k + 1
         end
      end
   end

if \bMultipleFiles then MsgStrings.1 = FileNameResult
else
   do
      k = MsgHighWater + 1
      MsgStrings.0 = k
      MsgStrings.k = MsgStringLast
      FileNameResult = BuildString
   end

if FileNameResult = '' then
   do
      if \bSilent then
         do
            MsgStrings.1 = FileNameSought 'not found in ' ||,
                           PATHVARIABLE 'variable.'
            Call PutMessage
         end
      return ''
   end

if \bSilent then
   do
      Call PutMessage
   end
return FileNameResult

PutMessage:
   Call CreateQueueForSubtask
   do i = 1 to MsgStrings.0
      queue MsgStrings.i
   end
   MMMsgQueueName = RxQueue("Set",OutputQueueName)
   if MMMsgQueueName <> MessageQueueName then
      do
         say 'Error in REXX RxQueue "Set" queue processing.'
         say 'Processing may not terminate successfully.'
      end
   if bRXRNX then sMin = '/min'; else sMin = '';
   '@start "OK' MessageQueueName'" /c /win' sMin 'RxOKBox ' ||,
      MessageQueueName OutputQueueName BKColor
   ncnt = 0
   if bRXRNX then
      do
         call rxsessionmin 1
         do while (ncnt < 10)& (rxsessionfocus('*'MessageQueueName'*') <> 0)
            ncnt = ncnt+1
         end
      end
   do while 1>queued()
      Call SysSleep 1
   end
   if bRXRNX then urc=RXSESSIONFOCUS('*')
   JunkQName = RxQueue('Set',PreviousQueueName)
   urc = RxQueue("Delete",MessageQueueName)
   urc = RxQueue("Delete",OutputQueueName)
   return

/* Create a unique queue for communication with our subtask */
CreateQueueForSubtask:
   /* Rexx will create a MessageQueueName for us */
   MessageQueueName  = RxQueue("Create")
   OutputQueueName   = RxQueue("Create")
   PreviousQueueName = RxQueue("Set",MessageQueueName);
   CurrentQueueName  = RxQueue("Get")
   if CurrentQueueName \= MessageQueueName then
      do
         say 'Failure in RxQueue "Set"'
         say 'Processing may be unsuccessful.'
      end
   return

ParsePATH:
   ParseFileName = FileSpec('n',FileNameResult)
   ParsePath.0 = 0
   bParseLoop = 1
   ParseCnt = 0
   currparse = value(PATHVARIABLE,,'OS2ENVIRONMENT')
   do while bParseLoop
      ParseCnt = ParseCnt +1
      parse var currparse partparse ';' remainder
      if '\' <> right(partparse,1) then partparse = partparse||'\'
      ParsePath.ParseCnt = partparse||ParseFileName
      currparse = remainder
      if currparse = '' then leave
   end
   ParsePath.0 = ParseCnt
   return

Syntax:
   MsgStrings.1 = d2c(27)'[2J'd2c(27)'[2;1H'
   zstr = ' RxMP InPATH  Find File in path  '||,
   '(C) Bruce E. Hgman 1994,1995'
   MsgStrings.2 = zstr
   MsgStrings.3 = 'Syntax:'
   MsgStrings.4 = '         'Ourname '  file_name ' '[ '||,
       'path_name ]'
   MsgStrings.5 = ''
   MsgStrings.6 = 'file_name:       simple name of file'
   MsgStrings.7 = ''
   MsgStrings.8 = ''
   MsgStrings.9 = 'path_name:       name of environment variable.'
   MsgStrings.10 = ''
   MsgStrings.11 = '   If omitted, then PATH is searched.'
   MsgStrings.12 = ''
   MsgStrings.13 = 'Example:  inpath  cmd.exe       Example:  inpath mydat.dat dpath'
   MsgStrings.14 = '   Searches PATH for cmd.exe       Searches DPATH for mydat.dat'
   MsgStrings.15 = ''
   MsgStrings.16 = 'Hit ENTER to close this window.'
   MsgStrings.0 = 16
   Call PutMessage
   return
