/* RTrack1.CMD */
/* Sample REXX Program to access AIMS RadioTrack (older version) using RXRTCTRL.DLL */

/* To run this program, the file RXRTCTRL.DLL must be in */
/* the same directory as this file or in a directory */
/* listed in your LIBPATH. */

/* Prerequisites for RXRTCTRL to work properly:

The following two statements must be in your CONFIG.SYS

IOPL=YES,FXPRINT  (or just IOPL=YES)
DEVICE=D:\OS2\BOOT\TESTCFG.SYS

These statements are added by default by Warp 3 and Warp 4.

*/

/*======================*/
/* Load RXRTCTRL.DLL    */
/*======================*/
CALL RXFuncAdd 'RTLoadFuncs', 'RXRTCTRL', 'RTLoadFuncs'
CALL RTLoadFuncs

SAY ''
SAY '--- Sample REXX Program to access RadioTrack FM card (older version).---'
SAY ''
SAY 'CAUTION: This program is capable of writing to I/O directly.'
SAY '         Make sure the rt_Address is set to the same value'
SAY '         as your RadioTrack card.'
SAY '         rt_Address is set to 20C hex by default.'
SAY ''

rt_Address = X2D('20C')    /* enter radio address in hex. rt_address variable is converted from hex to decimal */

keyhit = ""
DO FOREVER
   SAY "---------------------------------------------------"
   SAY "Type 'x' to eXit..."
   SAY "Commands below are for older RadioTrack only"
   SAY "(type commands without the quotes):"
   SAY "Type 'on' for radio on; 'off' for radio off;"
   SAY "'f' to set radio to 90.1 MHz;"
   SAY "'tu' fine tune 90.1 MHz up; 'td' to fine tune 90.1 MHz down;"
   SAY "'vu' for volume up; 'vd' for volume down;"
   SAY "'t' to check if station is tuned; 'v' for DLL version."
   SAY ""
   SAY "--------------------------------------------------"
   SAY 'Enter selection: '
   PARSE PULL keyhit
   keyhit = Translate(keyhit)
   SELECT

      when keyhit = "F" then    /* set frequency  */
        do
          freq_value = 901     /* frequency is MHZ x 10, must be integer!!!! So 90.1 MHz = 901; 101.1 MHz = 1011 */
                               /* valid range is 87.0MHz to 109MHz. There is no range check, so that must be done in the REXX program */

          return_data = RT1Freq( rt_Address, freq_value, '0' )
          SAY "Set freq to 90.1 MHz: " || return_data
          keyhit = ""
        end

      when keyhit = "OFF" then    /* Radio off */
        do
          return_data = RT1Off( rt_Address )    /* rt_address must be decimal */
          SAY "Set Radio off: " || return_data

          keyhit = ""
        end

      when keyhit = "ON" then    /* Radio on */
        do
          return_data = RT1On( rt_Address )    /* rt_address must be decimal */
          SAY "Set Radio on: " || return_data
          keyhit = ""
        end

      when keyhit = "VU" then    /* volume up */
        do
          return_data = RT1Volup( rt_Address )    /* rt_address must be decimal */
          SAY "Set volume up: " || return_data
          keyhit = ""
        end

      when keyhit = "VD" then    /* volume down */
        do
          return_data = RT1VolDn( rt_Address )    /* rt_address must be decimal */
          SAY "Set volume down: " || return_data
          keyhit = ""
        end

      when keyhit = "TU" then    /* tune frequency  */
        do
          freq_value = 901     /* frequency is MHZ x 10, must be integer!!!! So 90.1 MHz = 901 */
                               /* there is no range check, so that must be done in the REXX program */

          fine_tune = fine_tune + 1       /* use this to fine tune the frequency to a resolution of 0.025MHz */
                                          /* No range check takes place and fine_tune should be kept inside this range: */
                                          /* -4, -3, -2, -1, 0, 1, 2, 3, 4 since this corresponds to +/-0.1MHz */
          IF fine_tune > 4 THEN
            fine_tune = 0

          return_data = RT1Freq( rt_Address, freq_value, fine_tune )
          SAY "Tune freq (90.1 MHz+) up: " || return_data

          keyhit = ""
        end

      when  keyhit = "TD" then    /* tune frequency  */
        do
          freq_value = 901     /* frequency is MHZ x 10, must be integer!!!! So 90.1 MHz = 901 */
                               /* there is no range check, so that must be done in the REXX program */

          fine_tune = fine_tune - 1       /* use this to fine tune the frequency to a resolution of 0.025MHz */
                                          /* No range check takes place and fine_tune should be kept inside this range: */
                                          /* -4, -3, -2, -1, 0, 1, 2, 3, 4 since this corresponds to +/-0.1MHz */
          IF fine_tune < -4 THEN
            fine_tune = 0

          return_data = RT1Freq( rt_Address, freq_value, fine_tune )
          SAY "Tune freq (90.1 MHz-) down: " || return_data

          keyhit = ""
        end


      when keyhit = "T" then    /* Radio tuned */
        do
          return_data = RT1Tuned( rt_Address, '150', '100' )    /* rt_address must be decimal */
          SAY "Radio is (1=tuned, 0=not tuned): " || return_data
          keyhit = ""
        end

      when keyhit = "V" then    /* rxRTCtrl.DLL version */
        do
          return_data = RTDLLVersion()    /* no parameters passed on */
          SAY "DLL version is: " || return_data
          keyhit = ""
        end

   otherwise
     DO
       IF keyhit = "X" THEN
         DO
            CALL RTDropFuncs
            SAY 'RXRTCTRL dropped.'
            EXIT
         END
       ELSE
         SAY "Invalid Input."
     END
   end  /* select */
end /* do */

EXIT

