/*** RxRsync REXX procedures ************************************/
/*  rsync_undiff: uses the difference file, and the old version, to
                   build a copy of the new version

     status=rsync_undiff(oldver_file,diff_file,newfile,quiet)
**************************************/

rsync_undiff:
  parse arg afile,dfile,outfile,verbo

if afile='' then return "ERROR no old_version file specified"
if dfile='' then return "ERROR no difference-file specified "
if newfile='' then return "ERROR no new_version file specified "

if verbo<>'' then verbose=verbo
select
   when verbose=0 then verbose=1
   when verbose=1 then verbose=0
   otherwise nop
end

crlf='0d0a'x
a=time('r')

/* read "diff Afile" */
aa=translate(stream(dfile,'c','open read'))
if  abbrev(aa,'READY')=0 then return "ERROR could not open "dfile
idsize=stream(dfile,'c','query size')
if idsize='' | idsize=0 then do
    return 'ERROR 'dfile " is unaccessible"
    exit
end
s1=charin(dfile,1,idsize)
aa=stream(dfile,'c','close')
if verbose>0 then  do
    say "Rsync undiff: read "idsize" bytes in the difference file"
end

/* read "Afile" */
aa=translate(stream(afile,'c','open read'))
if  abbrev(aa,'READY')=0 then return "ERROR could not open "afile
iasize=stream(afile,'c','query size')
if iasize='' | iasize=0 then do
    return 'ERROR 'afile " is unaccessible"
    exit
end
astuff=charin(afile,1,iasize)
aa=stream(afile,'c','close')
if verbose>0 then  do
    say "   "iasize" bytes in the old_version file"
end

amd4=rx_md4(astuff)            /* md4 of old version */

/* get md4 and blocksize from s1 */
parse var s1 smd4 bsize (crlf) s1
if strip(translate(amd4))=strip(translate(smd4)) then do
   if verbose>0 then
       say "   File has not changed! "
   bstuff=astuff
   signal writeme1    
end 

/* start building. Each records starts with a single character identifier,
either a B or a C. Following the identifier is:
   B: a block start: block end number, and then a crlf
   C: a count of bytes (nnn), a ":", a string of length nnn, and a crlf
*/
bstuff=''
noted=0
do forever
   if length(s1)=0 | s1='' then leave
   mbl=lengtH(bstuff)
   if  mbl-noted> reportat then do
      if verbose>0 then say "... Rsync client: # characters recovered "mbl
      noted=mbl
   end /* do */
   parse var s1 atype +1 s1  ; atype=translate(atype)
   select
      when atype='C' then do
         parse var s1 nnn ':' s1
         parse var s1 ccs +(nnn) (crlf) s1
         bstuff=bstuff||ccs
      end /* do */
      when atype='B' then do
         parse var s1 idb1 ':' idb2 (crlf)  s1
         i1=((idb1-1)*bsize)+1
         i2=idb2*bsize
         i2=min(i2,iasize)
         bstuff=bstuff||substr(astuff,i1,1+i2-i1)
      end /* do */
      otherwise do
         return "ERROR in differnce file: unknown type= "atype
     end
   end  /* select */
end /* do */

/* compute md4 of this constructed file */
b2md4=rx_md4(bstuff)
if strip(translate(b2md4)) <> strip(translate(smd4)) then do
   return "ERROR md4 does not match: "b2md4', 'smd4
end /* do */

writeme1:   nop                 /* jump here if no change */
foo=sysfiledelete(outfile)
if foo>2 then return 'ERROR unable to delete output file 'outfile
foo=charout(outfile,bstuff,1)          /* save the computed new file */
foo=stream(outfile,'c','close')
b=time('e')
if verbose>0 then
  say '   Saving duplicate to 'outfile ' [elapsed time='||strip(b,'t','0')

nn=length(bstuff)
drop bstuff; drop astuff

return 'OK 'nn ' bytes written to  'outfile


