/* An example of a MENU Group */

/* Trap ERROR and FAILURE */
SIGNAL ON ERROR
SIGNAL ON FAILURE


/* ====================== 'Main Window' ======================= */
/* MENU Group */
RXTYPE.1 = 'MENU'

/* TotalMenus, REXX variable names for the Headings */
RXINFO.1 = '2 MENU1|MENU2'

/* Give me a HELP menu too */
RXFLAGS.1 = 'HELP'

/* Menu 1 */
MENU1.0 = 'File'
MENU1.1 = 'Open|2'  /* NOTE: 2 subitems */
MENU1.2 = 'Save'
MENU1.3 = ' '  /* End of Menu 1 */

/* Menu 1, Item 1 subitems */
MENU1.1.1 = 'All'
MENU1.1.2 = 'Excerpt'

/* Menu 2 */
MENU2.0 = 'Edit'
MENU2.1 = 'Cut'
MENU2.2 = 'Copy'
MENU2.3 = 'Paste'
MENU2.4 = ' '  /* End of Menu 2 */

/* Default size and position (also gives us sizing and max button) */
RXWINMAIN = ' '

/* Specify NOCLOSE since we want to close the window ourselves.
   No RESULT Flag, so the ESC and ENTER keys do nothing, and we
   don't have to bother checking for those */
RXDLG 1 '"Main Window"' 'RXWINMAIN' 'NOCLOSE'

/* Associate the help file (so that we can use the HELP menu). Note that
   Rexx Dialog automatically displays panels from it when the user
   selects items in the HELP menu */
RXHELP 'CREATE' '""' 'TEST.HLP'

more:
RXDLG

/* IF user clicked upon CLOSE ICON, close Main Window and exit */
IF RXID < 0 THEN EXIT

/* Print out RXID and RXSUBID. RXID should be 1, since we only
  have 1 Group, no timeout, and no KEYS or RESULT Flag set.  RXSUBID is the
  label number, which will depend upon which Item or SubItem was chosen from
  the menu. Since we asked for a HELP menu too, the first 5 label numbers
  correspond to the Help Heading, and the 4 Help Items, "Help index",
  "General Help", "Using Help", and "Keys Help", even though the Help menu
  appears last on the menu bar
*/

RXSAY 'Group = 'RXID 'Menu = 'RXSUBID

SIGNAL more

/* ==================================================== */

FAILURE:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
ERROR:
    /* NOTE: the variable RC contains the returned error message (not a number,
	unless we use RXERR to set up Rexx Dialog to return error numbers instead).
	Because we used the default severity level, Rexx Dialog has already displayed
	this error message to the enduser */
    EXIT
