:userdoc.:title.RexxAutoStart
:docprof toc=123.
.nameit symbol=rxastver text='1.61'
.nameit symbol=rxastdate text='25 May 2000'
.nameit symbol=rxastzip text='RxAST161'
.***************************************************
.*** IPF-Generator Version 0.82 for Framework IV ***
.***************************************************

:h1 res=100.&rbl.0.  Introduction

:font facename='Default' size=0x0.:artwork align=center name='RXAUTOST.BMP' .
:lines align=left.:font facename='Helv' size=36x20.RexxAutoStart:font facename='Default' size=0x0.
Version &rxastver. (&rxastdate.) by :link  reftype=hd refid=herwig.Herwig Bauernfeind:elink. and :link reftype=hd refid=chuck.Chuck McKinnis:elink.
============================================================================================
:elines.
:p.This program is basically a workaround for timing problems that may lead to a WPS hang
on startup on certain OS&slr.2 versions and fixlevels. 
:p.What is more it provides the following features&colon.
:ul compact.
:li.The possibility to start objects from a startup folder in any desired order (as long as
you are able to handle E.EXE and have some basic understanding of REXX).
:li.Declare any folder as your startup folder. You even could use different folders for
different startup sequences.
:li.RexxAutoStart may (slightly) speed up boot process&comma. because hard drive activity
is reduced (a bit).
:eul.
:i1.what is it

:h1 res=200.&rbl.1.  License

:font facename='Default' size=0x0.
:p.:hp8.From version 1.41 onward&comma. this program is free software (hmmm&comma. it was
always free&comma. but now it is GPLed); you can redistribute it and&slr.or modify it
under the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License&comma. or (at your option) any later version.:ehp8.
:p.This program is distributed in the hope that it will be useful&comma. but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
:p.You should have received a :link reftype=launch object='E.EXE' data='COPYING'.copy of the
GNU General Public License:elink. along with this program; if not&comma. write to the Free
Software Foundation&comma. Inc.&comma. 675 Mass Ave&comma. Cambridge&comma. MA 02139&comma. USA.
:p.So&comma. in short&colon.  No money&comma. no warranty.  Use at your own risk.  Pay nothing.
 Be happy.
:p.You are not allowed to think nasty about the authors!
:i1.warranty
:i1.copyright
:i1.distribution
:i1.responsibility

:h1 res=300.&rbl.2.  Requirements

:font facename='Default' size=0x0.
:p.This program was designed and developed on a system that runs OS&slr.2 Warp 4 German&comma.
FixPack 06&comma. which did not boot any more after some WPS extensions were installed
(especially Object Desktop 2.0 and CandyBarZ).  Therefore the "recommended" platform
is&colon.
:ul.
:li.OS&slr.2 Warp 4&comma. FP6&comma. also tested to work on FP8&comma. FP10&comma. FP12&comma. and FP13.
:li.OS&slr.2 Warp Server for e-Business with or without FP1.
:li.OS&slr.2 Warp 3 (almost fully supported from version 1.40 onward&comma. see :link
reftype=hd refid=known_problems.Known Problems:elink.&comma. see :link reftype=hd
refid=command_line_switches.Command Line Switches:elink.).
:li.Fixpack 35 or higher (FP38 tested) recommended on OS&slr.2 Warp 3.
:li.REXX (Classic REXX or Object REXX) installed.
:li.WPTools from Henk Kelder (:link reftype=launch object='NETSCAPE.EXE' data='http://www.os2ss.com/information/kelder/wptool32.zip'.http&colon.&slr.&slr.www.os2ss.com&slr.information&slr.kelder&slr.wptool32.zip:elink.)
:eul.
:warning.RexxAutoStart will not work on OS&slr.2 version 2.xx (at least the
executables&comma. and starting the plain script was not tested on 2.xx due to lack of
testing platform)!:ewarning.
:i1.requirements
:i1.version of OS&slr.2
:i1.fixpack
:i1.WPTools
:i1.Kelder&comma. Henk
:i1.OS&slr.2 Warp 3
:i1.OS&slr.2 Warp 4
:i1.WSeB

:h1 res=400.&rbl.3.  Installation

:font facename='Default' size=0x0.
:p.There are 2 ways to install RexxAutoStart. The following steps are common to both ways&colon.
:sl.
:li.Unzip :hp2.&rxastzip..Zip.:ehp2. into a directory of your choice.
:nt.There are 3 executables enclosed in the archive that
works both for REXX and Object REXX.:ent.
:li.Change to the directory where you unzipped :hp2.&rxastzip..zip.:ehp2..
:li.If you want to use :hp2.WARPCENTER:ehp2. or :hp2.LAUNCHPAD:ehp2. place them (or a shadow of them) into your startup folder.
:esl.
:nt.If you are updating from a previous release&comma. just
copy the new files over the old ones.:ent.
:i1.installation&comma. common steps
:i1.CONFIG.SYS
:i1.WPTools
:i1.location for files
:i1.updating
:i1.Classic REXX
:i1.Object REXX

:h2 res=420.3.1  The integrated installation
:font facename='Default' size=0x0.
:sl.
:li.Run install.
:li.A RexxAutoStart folder will be created on your desktop and opened.
:li.Open the RxAutoStart Utility and select the Install option.
You will be asked to select your startup options, your config.sys will be updated, and
the 'START' command for RexxAutoStart will be added to/or updated in your startup.cmd file.
:li.You do not have to change your way of handling programs that startup on boot in any
way&colon.
:sl.
:li.Just drop them (or a shadow of them) into your startup folder&comma. the startup
folder folder will be parsed at every boot&comma. and the objects there will be opened.
:esl.
:li.The order of starting programs in startup folder is the same as if you used startup
folder normally.
:li.If you want to change any of the RexxAutoStart options, update the SET RXAUTOST= parameter
in your config.sys file, and/or update the 'START' command for RexxAutoStart in your
startup.cmd file, just run the RexxAutoStart Utility again and select the Install option.
:li.Additional considerations&colon.
:sl.
:li.From version 1.60 onward RexxAutoStart checks whether the environment variable RXAUTOST exists and reads switches from it
and uses those switches when executing RexxAutoStart.
:li.From version 1.60 onward RexxAutoStart contains code that attachs an icon to the RexxAutoStart file.
:esl.
:esl.
:i1.installation&comma. integrated

:h2 res=430 Name=RxAutoSt_[3__Installatio.3.2  The standalone installation

:font facename='Default' size=0x0.
:sl.
:li.Open the RexxAutoStart Utility and select the Build option.
:li.You will be asked to select your startup options, your config.sys will be updated, a Rexx
script named AutoStrt.CMD will be generated in the directory where RexxAutoStart is installed, and
the 'START' command for AutoStrt.CMD will be added to/or updated in your startup.cmd file.
:li.Any time you change the content of your startup folder&comma. you will need to run the
RexxAutoStart Utility again and select the Build option to pick up changes in your startup folder.
:sl.
:li.Look into :link  reftype=hd refid=known_problems.Known Problems:elink. section before doing so.
:esl.
:li.You can edit AutoStrt.CMD in your RexxAutoStart directory and change the order as you desire.
:li.Additional considerations&colon.
:sl.
:li.Use the &slr.S switch to insert code into
AutoStrt.CMD that will delay execution of AutoStrt.CMD until
desktop is populated (may need manual modification on Warp 3).
:li.From version 1.60 onward RexxAutoStart checks whether the environment variable RXAUTOST exists and reads switches from it
and uses those switches when generating the AutoStrt.CMD script.
:li.From version 1.60 onward RexxAutoStart contains code that attachs an icon to the AutoStrt.CMD file.
:esl.
:esl.
:i1.installation&comma. standalone
:i1.icon

:h1 res=500 Name=command_line_switches.&rbl.4.  Command Line Switches

:font facename='Default' size=0x0.:p.Command line switches can be divided into the following groups&colon.
:ol.
:li.:hp2.Switches to get help&colon.:ehp2.
:parml tsize=15 break=fit.
:pt.&slr.?
:pd.Simple list of valid switches with a short explanation.
:pt.&slr.H
:pd.Open this manual.
:eparml.
:li.:hp2.Generally used switches&colon.:ehp2.
:parml tsize=15 break=fit.
:pt.&slr.X
:pd.e:hp2.X:ehp2.ecute RxAutoSt.
:pt.&slr.WPS
:pd.Delay the starting of objects in the startup folder until the desktop is populated.
:pt.&slr.OD[&colon.n]
:pd.Delay the starting of objects in the startup folder until Object Desktop's features
(Tab LaunchPad and/or Control Center) have started.  The n option is the number of times
to check for the Object Desktop tasks (default = 30).
:pt.&slr.D&colon.n
:pd.:hp2.D:ehp2.elay further processing after the desktop is populated and/or the Object
Desktop feature(s) have started by n seconds (default = 2).
:pt.&slr.F&colon."<id>"
:pd.Use <id> as startup :hp2.F:ehp2.older instead of the default of <WP_START>.  This
feature enables the user to have his very own private startup folder&comma. which will not
be known to any other program.
:pt.&slr.P&colon.n
:pd.:hp2.P:ehp2.ause between the starting of objects in the startup folder by n seconds
(default = 2).
:pt.&slr.R&colon.n
:pd.Number of attempts (:hp2.R:ehp2.etries) to open an object in the startup folder
(default = 2).
:pt.&slr.V
:pd.:hp2.V:ehp2.erbose. Give us some hints what we are doing right now.
:pt.&slr.L
:pd.:hp2.L:ehp2.og the results of the execution to the RxAutoSt.log file in the directory
where RexxAutoStart resides.
:eparml.
:note.Command line switches will override the values specified in the environmental variable
:hp2.RXAUTOST:ehp2..
:li.:hp2.Utility switches&colon.:ehp2.
:parml tsize=15 break=fit.
:pt.&slr.I
:pd.:hp2.I:ehp2.nitialize and/or update the RexxAutoStart execution parameters.
:pt.&slr.S
:pd.Generate a :hp2.S:ehp2.tandalone script named AutoStrt.CMD that will be stored in the
directory where RexxAutoStart resides.
:pt.&slr.C
:pd.:hp2.C:ehp2.reate a folder on your desktop to use as
an alternate startup folder instead of the default of <WP_START>.
:pt.&slr.U
:pd.:hp2.U:ehp2.ninstall RexxAutoStart.
:eparml.
:eol.
:i1.environment variable
:i1.switches
:i1.command line
:i1.topic

:h1 res=600.&rbl.5.  What it does (and what it does not do)

:font facename='Default' size=0x0.:p.:hp2.What it does:ehp2.&colon.

:p.RexxAutoStart:
:ul.
:li.If requested, waits for the desktop to be populated.
:li.If Object Desktop is installed and if requested, waits for the selected Object Desktop tasks to start.
:li.If requested, delays opening of the objects in the startup folder by a selected number of seconds.
:li.Reads the contents of the startup folder and opens the objects there in order
with a delay of a few seconds (2 as default) between opens.
:li.On my system this cures the startup problem (almost) completely.
:eul.

:p.:hp2.What it does not do:ehp2.&colon.

:p.RexxAutoStart does not pollute your system in any way&comma. except it
needs some space on your harddisk.

:p.It has been tested on systems running OS&slr.2 Warp 4 Build 9.030 (FP6)&comma. 9.032 (FP8)&comma.
9.034 (FP10) and 9.036 (FP12) and OS&slr.2 Warp 3 Connect Build 8.262 (FP#38)&comma. all of them German.
:p.It has also been tested on the US English systems running OS&slr.2 Warp 4 Build 9.036 (FP12) and WSeB Build 14.040_SMP.
:i1.pollution
:i1.INI-entries
:i1.tested systems
:i1.startup folder

:h1 res=700 Name=known_problems.&rbl.6.  Known Problems

:font facename='Default' size=0x0.
:ul.
:li.Executing RexxAutoStart immediately after placing objects into the Startup 
folder may fail to properly read the object ids (they have not been updated in os2.ini). An invalid script is created 
in this case.

:li.Generally&comma. I do not use RxAutoSt.CMD except for debugging and compiling. This may
sound strange&comma. there is no need to compile it&comma. but I think (and this is my own personal
philosophy) that every program&comma. which is bigger than a handfull of lines should be
a "real" executable&comma. which cannot be changed (and&slr.or damaged) so easily.

:li.Do not compress the executables with LxLite&comma. it will be damaged by doing so!

:li.Testing under OS&slr.2 Warp 3 was rather short. It appears to work nicely&comma. but there 
might be problems that I am not aware of...

:li.My English is not the best. Sorry folks... (That's a permanent restriction;-)
Maybe not, if Chuck checks through everything again;-)

:li.No other problems are known at this time.
:eul.
:i1.known problems
:i1.problems
:i1.restrictions

:h1 res=800 Name=to_do_list.&rbl.7.  To Do List

:font facename='Default' size=0x0.
:p.I was working on a GUI-version of the program itself, but this is temporarily 
suspended until I recover from an MS attack (and that were not those guys from Redmond)...
:p.During the last few months Chuck has taken over almost the complete
development of RexxAutoStart and this will stay this way for at least another 
few months.
:p.In fact, all the new features were his ideas and were coded by him.
:p.The installation GUI has been dropped, because there was absolutely
no feedback on this issue, so obviously nobody needs it...
:p.I have various ideas&comma. but they all have certain drawbacks and
would violate :link reftype=fn refid=1.KISS:elink. principle(s).
:p.I wanted do some more testing on OS&slr.2 Warp 3&comma. but I won't.
Bye&comma. bye&comma. OS&slr.2 Warp 3!
:fn id=1.:p.KISS = Keep it simple stupid!
:p.KISS = Keep it stable stupid!:efn.
:i1.KISS principles
:i1.to-do-list
:i1.ideas
:i1.future

:h1 res=900.&rbl.8.  History

:font facename='Default' size=0x0.:lines align=left.
:parml tsize=20 break=fit compact.
:pt.:hp5.1.61:ehp5.&rbl.25.05.2000:pd.
:hp8.Bugfix:ehp8.&colon. Setting of the current directory was being done too late to locate necessary dll modules.
:hp8.Bugfix:ehp8.&colon. Corrected the updating of various parameters by RxAutoUt.
:pt.:hp5.1.60:ehp5.&rbl.15.05.2000:pd.:hp4.Feature:ehp4.&colon. Removed any requirement for Object Rexx and/or RxExtras.
:hp4.Feature:ehp4.&colon. Added the install.exe to build and open the RexxAutoStart folder (Chuck McKinnis).
:hp4.Feature:ehp4.&colon. Added RexxAutoStart Utility (Chuck McKinnis).
:hp4.Feature:ehp4.&colon. Added Warp Server for e-Business support (Chuck McKinnis).
:hp4.Feature:ehp4.&colon. RexxAutoStart no longer generates a REXX script for each execution.  Objects
          in the startup folder are opened directly by RexxAutoStart. (Chuck McKinnis).
:hp4.Feature:ehp4.&colon. The standalone installation (AutoStrt.CMD) supports all the same options
          as RexxAutoStart (Chuck McKinnis).
:hp4.Feature:ehp4.&colon. Added &slr.L&comma. log information to a log file (Chuck McKinnis).
:hp4.Feature:ehp4.&colon. Added &slr.I&comma. install/modify RexxAutoStart (Chuck McKinnis).
:hp4.Feature:ehp4.&colon. Added &slr.U&comma. uninstall RexxAutoStart (Chuck McKinnis).
:hp4.Feature:ehp4.&colon. Added &slr.C&comma. create a folder on the desktop (Chuck McKinnis).
:hp8.Bugfix:ehp8.&colon. Removed the /NI parameter.  The icon attachment issue is solved.
:hp8.Bugfix:ehp8.&colon. Parameter parsing permits any value to be entered after a semi-colon.
        Removed the &slr.EV parameter. Removed the &slr.A[&colon.n] parameter.
:pt.:hp5.1.50:ehp5.&rbl.15.02.2000:pd.:hp4.Feature:ehp4.&colon. Object Desktop support (by Chuck McKinnis) and &slr.OD switch!
&slr.EV switch.  Nonfunctional GUI draft enclosed.
:pt.1.43&rbl.28.08.1999:pd.:hp8.Bugfix:ehp8.&colon. Small letters were not properly recognized on some parameters.
:pt.:hp5.1.42:ehp5.&rbl.10.06.1999:pd.:hp4.Feature:ehp4.&colon. Source code publicly available.
Program under GNU GPL.
:pt.1.41&rbl.20.03.1999:pd.Little (mostly cosmetic) changes in AutoStrt.CMD code.
:hp8.Bugfix:ehp8.&colon. &slr.A&colon.n switch was parsed wrongly.
Code cleaned and beautified.
:pt.:hp5.1.40:ehp5.&rbl.01.03.1999:pd.:hp4.Feature:ehp4.&colon. Executables for Classic REXX and Object REXX.
New &slr.H[&colon.topic]-switch.Added &slr.F and &slr.NI switches.
&slr.WPS switch supported under OS&slr.2 Warp 3.
:hp8.Bugfix:ehp8.&colon. Blanks and ' in ObjectIDs or ShadowIDs led to an invalid script.
Missing ID was recognized correctly&comma. but led to an invalid script.
Completed necessary modifictions in CONFIG.SYS (SET AUTOSTART line was missing).
:pt.:hp5.1.35:ehp5.&rbl.5.22.02.1999:pd.:hp4.Feature:ehp4.&colon. Added &slr.E switch&comma. i.e. even less pollution&colon.-)
:pt.1.34&rbl.21.02.1999:pd.:hp4.Feature:ehp4.&colon. Removed &slr.H(istory) switch (this page)&comma. some little (partly cosmetic) enhancements&comma.
AutoStrt script code slightly changed. Manual in INF-format.
:pt.:hp5.1.33:ehp5.&rbl.10.02.1999:pd.:hp4.Feature:ehp4.&colon. Self extracting&comma. self attaching icon upon first start.
:pt.1.32&rbl.08.02.1999:pd.:hp8.Bugfix:ehp8.&colon. Program checks whether it runs on OS&slr.2 Warp 3 or 4.
:pt.1.31&rbl.07.02.1999:pd.:hp8.Bugfix:ehp8.&colon. Did not run on OS&slr.2 Warp 3. Ouch!
:pt.1.30&rbl.29.01.1999:pd.:hp4.Feature:ehp4.&colon. Enhanced standalone code&comma. enhanced &slr.A switch.
:pt.1.20&rbl.26.01.1999:pd.:hp8.Bugfix:ehp8.&colon. Modified code to read ShadowID&comma. if no ObjectID is available.
Now really all kinds of objects should be startable..
:pt.1.15&rbl.24.01.1999:pd.:hp4.Feature:ehp4.&colon. Added &slr.A switch.
:pt.1.14&rbl.21.01.1999:pd.:hp4.Feature:ehp4.&colon. Added &slr.R parameter for number of retries. New retry code.
:pt.1.13&rbl.21.01.1999:pd.:hp4.Feature:ehp4.&colon. Added &slr.S parameter and code to run AutoStrt.CMD standalone.
Changed code so that &slr.WPS and &slr.D switch can be used together
sensibly to provide a delay after desktop has been populated.
:pt.1.12&rbl.21.01.1999:pd.:hp4.Feature:ehp4.&colon. Added code for 1 retry&comma.
if 1st attempt to open an object failed.
:pt.1.11&rbl.19.01.1999:pd.:hp4.Feature:ehp4.&colon. Changed standard behaviour and &slr.NV switch to &slr.V.
Some little (cosmetic) enhancements.
:pt.1.10&rbl.10.01.1999:pd.:hp4.Feature:ehp4.&colon. Shortened the created script by using a subroutine.
:pt.1.02&rbl.10.01.1999:pd.:hp8.Bugfix:ehp8.&colon. Changed view to open from RUNNING (4) to DEFAULT (0).
Now all kinds of objects should be startable.
:pt.1.01&rbl.07.01.1999:pd.:hp4.Feature:ehp4.&colon. Enhanced method to determine bootdrive&comma.
&slr.WPS-switch to wait for populated desktop&comma. display current REXX-Version on help.
:pt.:hp5.1.00:ehp5.&rbl.28.12.1998:pd.Initial release in Fidonet echo OS2.WPS.GER.
:eparml.

:elines.:i1.history
:i1.features
:i1.fixed bugs
:i1.bugs&comma. fixed
:i1.random features&comma. fixed
:i1.releases

:h1 res=1000.&rbl.9.  Thanks go to ...

:font facename='Default' size=0x0.:ul.
:li.IBM for creating OS&slr.2. Shame on them for neglecting us this way by now!
:li.:link reftype=hd refid=chuck.Chuck McKinnis:elink. for adding Object Desktop support into RexxAutoStart and all
those other things you have put in, for which I would never have been capable of.
:li.:link reftype=launch object='NETSCAPE.EXE' data='http://www.os2ss.com/information/kelder'.Henk Kelder:elink. for creating WPTools (and other valuable utilities for OS&slr.2).
:li.:link reftype=launch object='NETSCAPE.EXE' data='http://www.ozemail.com.au/~dbareis'.Dennis Bareis:elink. for his Rexx compiler.
:li.Bernd Schemmer for his Rexx Tips and Tricks!
:li.Andrew Zabolotny for creating lxLite. Great tool&comma. really!
:li.Jeff Glatt for his way writing disclaimers!
:li.Additional thanks go to Martin Binder&comma. Burkhard Schneider&comma. Wilfried Brinkmann&comma.
Stephen Worthington and (once more) Martin Binder.
:eul.
:i1.Thanks

:h1 res=1100 name=authors.10.  Authors

:h2 res=1110 name=herwig.10.1  Herwig Bauernfeind

:font facename='Default' size=0x0.
:p.My name is Herwig Bauernfeind and I am from :link reftype=fn refid=10.Austria:elink.. I'm working in 
the accounting business. My programming skills are very limited&comma. but 
I have been working with OS&slr.2 for about 8 years and I really learned 
a lot from this. REXX is a great language for someone like me (IMHO it's one
of the killer features of OS&slr.2) and that's why I chose it...

:p.Versions of RexxAutoStart from 1.41 onward come under the GNU GPL license with 
full source. If you think source still looks ugly and style is bad and&comma. heck&comma. this 
or that construction is ridiculous&comma. beautify it&comma. streamline it and send it back 
to me. I will be happy to enclose the changes and mention your name in the next release;-)

:p.If you find bugs&comma. just email me. If you think it runs fine&comma. just email me&comma. too.
Any feedback is appreciated.
:p.You can reach me&colon.
:lines align=left.
By email&colon. :link reftype=launch object='NETSCAPE.EXE' data='mailto:herwig.bauernfeind@aon.at'.herwig.bauernfeind@aon.at:elink.
FidoNet&colon.  :link reftype=fn refid=3.Herwig Bauernfeind:elink.&comma. 2&colon.313&slr.41.5
:elines.
:fn id=2.:p.herwig.bauernfeind@aon.at:efn.
:fn id=3.:p.You got me!:artwork align=left name='E:\DEV\INF\HERWIG.BMP'.:efn.
:fn id=10.:p.:font facename='Helv' size=8x4.A few words to my home country...
:p.Like many Austrians in these days&comma. I feel uncomfortable&comma. very uncomfortable.
:p.I never did vote for Mr. H. and I never will do so. I am member of a minority 
that was forced to commit suicide by the Nazis some 60 years ago.
:p.I have absolutely no sympathies for the Freedom Party.
:p.But I am in favour of the coalition we have now.
:p.My intention was to explain exactly what's going on here in Austria&comma. but that 
would have been a rather  long writing&comma. which needs carefull preparation. So this 
statement is a just a short comprehension and as such might be simplyfied and leaving 
some points open. So&comma. if you have questions about Austria&comma. just ask me. I'll try to answer 
any question.
:p.But please keep in mind the following things about Austria&colon.
:ul compact.
:li.We had peaceful&comma. democratic elections in last October.
:li.Freedom Party is a democratic party of the right wing&comma. but they are democratic.
:li.Freedom Party has a 26% share in parlament. So has the Peoples Party.
:li.Mr. H. is no Nazi.
:li.Mr. H. made verbal statements about our Nazi-past that cannot be accepted at all.
:li.Mr. H. is not a member of the government&comma. but a local governor of a province&comma. Carinthia&comma.
that's were I live.
:li.The coalition between Peoples Party and Freedom Party was the only way to overcome 
30 years of a Socialist dominated government.
:li.There are only very few Nazis here&comma. there are (almost) no riots against slovenians&comma. immigrants&comma. 
jews or any other minority. At least there are substantially fewer riots of this kind than in Sweden&comma. 
in Germany or in Spain; countries that were so eager to point with their fingers on us.
:li.Right extreme parties (i.e Nazi-parties) are prohibited by law.
:li.There are many&comma. many refugees from Bosnia&comma. Yugoslavia and Kosova here and they are save here.
:li.The probability that some sort of dictatorship will be erected in Austria is 0. Zero. Nada. Rien.
:eul.
:p.My personal opinion is&comma. that it is better to have Freedom Party participate in a government
when they have 26%&comma. than have a Socialist dominated government for another 4 years and then
have the Freedom Party at 30% to 35%. The following 4 years will show of what kind the Freedom party
really is.
:p.From my point of view&comma. we will see that Freedom Party is not better or worse than any other 
party in our parlament. The myth of Mr. H.&comma. that was so carefully created by the Socialists during
the last 15 years will vanish&comma. and Mr. H. will turn out to be&comma. what he always was&comma. an impolite braggart.
Believe me&comma. I've seen him for 20 years now...
:p.The sanctions by the 14 in the European Union are so bad for Austria&comma. because these sanctions might 
prevent the myth of Mr. H. to vanish&comma. and Freedom Party might become stronger although their politics
are not different from other partys.
:p.I would not like to see this&comma. and many other people here in Austria won't either...
:efn.
:i1.author
:i1.contacting
:i1.email address
:i1.fidonet address
:i1.source

:h2 res=1120 name=chuck.10.2  Chuck McKinnis

:font facename='Default' size=0x0.
:p.My name is Chuck McKinnis&comma. and I live in New Mexico&comma. USA. I retired from IBM
in 1991 after 26 years as a Senior Systems Engineer.  I currently do some part-time
consulting work for Denver Solutions Group&comma. an IBM Business Partner&comma. and I specialize
in IBM S&slr.390 mainframe operating systems and communications.  I have been using
OS&slr.2 since Version 1.3&comma. and I have been writing REXX code since it was first
introduced by IBM for the VM&slr.370 operating system.
:p.You can reach me&colon.
:lines align=left.
By email&colon. :link reftype=launch object='NETSCAPE.EXE' data='mailto:mckinnis@attglobal.net'.mckinnis@attglobal.net:elink.
:elines.
:p.My web page also contains some interesting code:
:lines align=left.
Via the WWW&colon. :link reftype=launch object='NETSCAPE.EXE' data='http://pws.pwserv.net/mckinnis'.http&colon.&slr.&slr.pws.pwserv.net&slr.mckinnis:elink.
:elines.

:i1.author
:i1.contacting
:i1.email address

:euserdoc.
