/*
package - build a package
Copyright 2000 by Chuck McKinnis,  Sandia Park, NM (USA)
mckinnis@attglobal.net
*/

Trace 'N'

Parse Arg package

Parse Var package package '.' .

package_file = package || '.zip'
config_file = package || '.pak'
zip_norm = '-jXo'
zip_zip = '-jXo0'

Call Rxfuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
Call Rxfuncadd 'RxExtra', 'RxExtras', 'RxExtra'
Call RxExtra 'LOAD'

If RxFileExists(config_file) Then
   Call RxRead 'config.', config_file
Else
   Signal Cleanup

If RxFileExists(package_file) Then
   Call SysFileDelete package_file
Do i = 1 To config.0
   If config.i = '' | Abbrev(config.i, ';') Then
      Iterate i
   Parse Var config.i from_file to_file
   Select
      When Translate(from_file) = 'REXX2EXE' Then
         Address cmd 'rexx2exe' to_file
      When Translate(from_file) = 'ERASE' Then
         Call SysFileDelete to_file
      When Translate(from_file) = 'INF' Then
         Address cmd 'ipfc -i' to_file
      When Translate(from_file) = 'HELP' Then
         Address cmd 'ipfc' to_file
      Otherwise
         Do
            If to_file = '' Then
               to_file = package_file
            If Translate(Substr(from_file, Lastpos('.', from_file) + 1)) <> 'ZIP' Then
               zip_parm = zip_norm
            Else
               zip_parm = zip_zip
            Address cmd 'zip' zip_parm to_file from_file
         End
   End
End

Cleanup:
Return 0
