/* RexxAutoStart by (c) 1998 - 2000 by Herwig Bauernfeind
   with additions for Object Desktop, object id checking, and
   installation by (c) 1999, 2000 by Chuck McKinnis */

/* This program is free software; you can redistribute it and/or modify it
   under the terms of the  GNU General Public License  as published by the
   Free Software Foundation; either version 2 of the License,  or (at your
   option) any later version.

   This  program  is  distributed  in the hope that it will be useful, but
   WITHOUT ANY WARRANTY;  without even the implied  warranty of FITNESS or
   MERCHANTABILITY  FOR  A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   675 Mass Ave, Cambridge, MA 02139, USA. */

/* mainline logic */
Trace 'N'
If _initialize() Then          /* initialize parameters and variables */
   Do
      xrc = 0
      Call SysSetObjectData '<RXAUTOSTART>', 'OPEN=DEFAULT;CCVIEW=NO;'
   End
Else
   xrc = 1
Exit xrc                                                      /* exit */

/* mainline logic routines */

_initialize:
/* Initialize libraries */

/* do parsing */
Parse Source . . prg_file .
Parse Version rxname rxver rxdate
our_dir = Strip(Filespec('d', prg_file) || Filespec('p', prg_file), , '\')
save_dir = Directory(our_dir)

/* initialize */
Call Rxfuncadd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
Call SysLoadFuncs

Address cmd '@echo off'
ver = '1.61'
verdate = '25 May 2000'
os2version = SysOS2Ver()
warp4 = (os2version >= 2.40)
wseb = (os2version = 2.45)
If wseb Then
   Do
      wseb_check = SysSearchPath('PATH', 'SYSLEVEL.OS2')
      wseb_check = Linein(wseb_check)
      wseb = (Pos('5639A6150', wseb_check) <> 0)
   End

If RxSearchLibpath('wptools.dll') = '' Then
   Do
      Say 'Cannot locate wptools.dll in your LIBPATH'
      Say 'Unzipping wptools.zip'
      Address cmd '@unzip -jo' our_dir || '\wptools.zip'
   End
If Stream(our_dir || '\wptools.zip', 'c', 'query exists') <> '' Then
   Call SysFileDelete our_dir || '\wptools.zip'

Call Rxfuncadd 'WPToolsLoadFuncs', 'WPTOOLS', 'WPToolsLoadFuncs'
Call WPToolsLoadFuncs

/* locate the executable */
exe_file = Stream('rxautost.exe', 'c', 'query exists')
If exe_file = '' Then
   exe_file = Stream('rxautost.cmd', 'c', 'query exists')
If exe_file = '' Then
   Do
      Say 'Unable to locate rxautost.exe or rxautost.cmd'
      Return 0
   End

/* locate the utility executable file */
util_file = Stream('rxautout.exe', 'c', 'query exists')
If util_file = '' Then
   util_file = Stream('rxautout.cmd', 'c', 'query exists')
If util_file = '' Then
   Do
      Say 'Unable to locate rxautout.exe or rxautout.cmd'
      Return 0
   End

/* define the log file */
log_file = our_dir || '\RxAutoSt.LOG'

/* locate the icon file */
icon_file = Stream('rxautost.ico', 'c', 'query exists')
If icon_file = '' Then
   Do
      Say 'Unable to locate rxautost.ico'
      Return 0
   End

/* define the enhanced help (INF) file */
inf_file = Stream('rxautost.inf', 'c', 'query exists')
If inf_file = '' Then
   Do
      Say 'Unable to locate rxautost.inf'
      Return 0
   End

/* create/update RexxAutoStart objects */

/* RxAutoStart folder */
class = 'WPFolder'
title = 'RexxAutoStart'
location = '<WP_DESKTOP>'
setup = 'OBJECTID=<RXAUTOSTART>;'
If SysCreateObject(class, title, location, setup, 'U') Then
   Nop
Else
   Do
      Say 'Unable to create or update' title
      Return 0
   End

/* RxAutoStart utility */
class = 'WPProgram'
location = '<RXAUTOSTART>'
title = 'RexxAutoStart^Utility'
obj = 'OBJECTID=<RXAUTOSTART_UTIL>;'
exec = 'EXENAME=' || util_file || ';'
iconfile = 'ICONFILE=' || icon_file ';'
setup = obj || exec || iconfile || 'NOAUTOCLOSE=YES;'
If SysCreateObject(class, title, location, setup, 'U') Then
   Nop
Else
   Do
      Say 'Unable to create or update' title
      Return 0
   End

/* RxAutoStart inf */
class = 'WPProgram'
location = '<RXAUTOSTART>'
title = 'RexxAutoStart^Information'
obj = 'OBJECTID=<RXAUTOSTART_INF>;'
exec = 'EXENAME=VIEW.EXE;'
iconfile = 'ICONFILE=' || icon_file ';'
parm = 'PARAMETERS=' || inf_file || ';'
setup = obj || exec || parm
If SysCreateObject(class, title, location, setup, 'U') Then
   Nop
Else
   Do
      Say 'Unable to create or update' title
      Return 0
   End

/* RxAutoStart log */
class = 'WPProgram'
location = '<RXAUTOSTART>'
title = 'RexxAutoStart^Log File'
obj = 'OBJECTID=<RXAUTOSTART_LOG>;'
exec = 'EXENAME=E.EXE;'
iconfile = 'ICONFILE=' || icon_file ';'
parm = 'PARAMETERS=' || log_file || ';'
setup = obj || exec || iconfile || parm
If SysCreateObject(class, title, location, setup, 'U') Then
   Nop
Else
   Do
      Say 'Unable to create or update' title
      Return 0
   End

Return 1

/* RxSearchLibpath
   search the current libpath for a module
   returns the fully qualified path if found or null if not found
   Copyright 2000 by Chuck McKinnis,  Sandia Park, NM (USA) 04 Feb 2000
   mckinnis@attglobal.net */
Rxsearchlibpath: Procedure
Trace('N')
Parse Arg dll
boot_drive = SysBootDrive()
config_sys = boot_drive || '\config.sys'
xrc = SysFileSearch('libpath', config_sys, 'lib_path.')
If xrc = 0 & lib_path.0 <> 0 Then
   Do i = 1 To lib_path.0
      lib_test = Space(Translate(lib_path.i))
      If Abbrev(lib_test, 'REM') Then
         Iterate i
      If \Abbrev(lib_test, 'LIBPATH') Then
         Iterate i
      lib_equal = Space(Substr(lib_test, 8))
      If \Abbrev(lib_equal, '=') Then
         Iterate i
      Parse Var lib_test . '=' lib_path
   End
lib_path = Space(lib_path)
our_path = SysTempFileName('lib????')
old_value = Value(our_path, lib_path, 'os2environment')
dll_path = SysSearchPath(our_path, dll)
old_value = Value(our_path, old_value, 'os2environment')
Return dll_path
