/* RexxAutoStart by (c) 1998 - 2000 by Herwig Bauernfeind
   with additions for Object Desktop, object id checking, and
   installation by (c) 1999, 2000 by Chuck McKinnis */

/* This program is free software; you can redistribute it and/or modify it
   under the terms of the  GNU General Public License  as published by the
   Free Software Foundation; either version 2 of the License,  or (at your
   option) any later version.

   This  program  is  distributed  in the hope that it will be useful, but
   WITHOUT ANY WARRANTY;  without even the implied  warranty of FITNESS or
   MERCHANTABILITY  FOR  A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   675 Mass Ave, Cambridge, MA 02139, USA. */

/* mainline logic */
Trace 'N'
Parse Arg orgparms                      /* get commandline parameters */
cmdparms = orgparms                       /* to enable check for help */
If _initialize() Then          /* initialize parameters and variables */
   Do
      xrc = 0
      Select
         When do_create_folder Then /* create a folder on the desktop */
            Do
               xrc = _create_folder()
               Call _cleanup xrc
            End
         When do_help Then                               /* give help */
            Do
               xrc = _helpscreen()
               Call _cleanup xrc
            End
         When do_enhancedhelp Then              /* give enhanced help */
            Do
               Call SysSetObjectData '<RXAUTOSTART_INF>', 'OPEN=DEFAULT;CCVIEW=NO;'
               Call _cleanup 0
            End
         When install Then                     /* install RxAutoStart */
            Do
               xrc = _install()
               Call _cleanup xrc
            End
         Otherwise Call _cleanup 100
      End
   End
Else
   xrc = 1
Exit xrc                                                      /* exit */

/* mainline logic routines */

_initialize:
/* Initialize libraries */

/* do parsing */
Parse Source . . prg_file .
Parse Version rxname rxver rxdate
our_dir = Strip(Filespec('d', prg_file) || Filespec('p', prg_file), , '\')
save_dir = Directory(our_dir)

/* initialize */
Call Rxfuncadd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
Call SysLoadFuncs

Call Rxfuncadd 'WPToolsLoadFuncs', 'WPTOOLS', 'WPToolsLoadFuncs'
Call WPToolsLoadFuncs
wptver = WPToolsVersion()

Address cmd '@echo off'
ver = '1.61'
verdate = '25 May 2000'
os2version = SysOS2Ver()
warp4 = (os2version >= 2.40)
wseb = (os2version >= 2.45)
If wseb Then
   Do
      wseb_check = SysSearchPath('PATH', 'SYSLEVEL.OS2')
      wseb_check = Linein(wseb_check)
      wseb = (Pos('5639A6150', wseb_check) <> 0)
   End

/* locate the executable */
exe_file = Stream('rxautost.exe', 'c', 'query exists')
If exe_file = '' Then
   exe_file = Stream('rxautost.cmd', 'c', 'query exists')
If exe_file = '' Then
   Do
      Say 'Unable to locate rxautost.exe or rxautost.cmd'
      Return 0
   End

/* locate our file */
util_file = Stream('rxautout.exe', 'c', 'query exists')
If util_file = '' Then
   util_file = Stream('rxautout.cmd', 'c', 'query exists')

/* locate the base directory for RxAutoSt */
base_dir = Filespec('d', exe_file) || Filespec('p', exe_file)

/* define the log file */
log_file = Filespec('d', base_dir) || Filespec('p', base_dir) || 'RxAutoSt.LOG'

/* locate the icon file */
icon_file = Stream('rxautost.ico', 'c', 'query exists')
If icon_file = '' Then
   Do
      Say 'Unable to locate rxautost.ico'
      Return 0
   End

/* define the enhanced help (INF) file */
inf_file = Stream('rxautost.inf', 'c', 'query exists')
If inf_file = '' Then
   Do
      Say 'Unable to locate rxautost.inf'
      Return 0
   End

/* we need this for /F switch to preserve case of ObjectIDs */
parms = Translate(orgparms)
/* build the option list */
options. = ''
x = 0
x = x + 1; options.x = '/I Set and/or update RexxAutoStart parameters'
x = x + 1; options.x = '/S Build the standalone AutoStrt.CMD file'
x = x + 1; options.x = '/U Uninstall RexxAutoStart'
x = x + 1; options.x = '/C Create a new folder for use as a startup folder'
x = x + 1; options.x = '/? View help'
x = x + 1; options.x = '/H View extended help'
options.0 = x
/* get the user option */
If parms = '' Then
   Do
      Say 'Select an option:'
      Do i = 1 To options.0
         Say i || '.  ' Subword(options.i, 2)
      End
      Parse Upper Pull ans .
      If Datatype(ans, 'w') & (ans >= 1) & (ans <= options.0) Then
         Do
            parms = Word(options.ans, 1)
            orgparms = parms
            cmdparms = parms
         End
   End
/* get some initial parameters */
install = (Pos('/I',parms) <> 0)                  /* install RxAutoSt */
standalone = (Pos('/S',parms) <> 0)   /* generate standalone autostrt */
If standalone Then
   install = 1
uninstall = (Pos('/U',parms) <> 0)              /* uninstall RxAutoSt */
If uninstall Then
   install = 1
verbose = (Pos('/V',parms) <> 0)                    /* verbose output */
log_out = (Pos('/L',parms) <> 0)                           /* logging */
testing = (Pos('/T',parms) <> 0)       /* undocumented test parameter */
If testing Then
   Do
      verbose = 1
      log_out = 1
   End

wps_wait = (Pos('/WPS',parms) <> 0)        /* wait for WPS population */

/* some parameter defaults */
delay_wait_default = 0
od_tries_default = 30
sleepsec_default = 2
startupfolder_default = '<WP_START>'
retries_default = 2

Parse Value('.' parms) With . '/D:' delay_wait '/'.   /* delay switch */
delay_wait = Strip(delay_wait)
If delay_wait = '' | \Datatype(delay_wait, 'W') Then
   delay_wait = delay_wait_default

/* Object Desktop information */
odtest = SysIni('USER','WPTS','TSMasterSetup:StartupFlags')
objdesk = (odtest <> 'ERROR:')            /* object desktop installed */
If objdesk Then             /* determine which facilities to wait for */
   Do
      od_wait = (Pos('/OD',parms) <> 0)    /* wait for Object Desktop */
      odtest = Left(odtest, Length(odtest) - 1)
      od_cc = (odtest >= C2x('28'x))
      od_tlp = (odtest >= C2x('28'x))
      od_tlp = (odtest >= C2x('24'x))
      od_cc = (odtest >= C2x('20'x))
      /* determine number of checks for Object Desktop tasks */
      Parse Value('.' parms) With . '/OD:' od_tries '/'.
      od_tries = Strip(od_tries)
      If od_tries = '' | \Datatype(od_tries, 'W') Then
         od_tries = od_tries_default
   End
Else
   od_wait = 0

/* /P switch (pause between object) */
Parse Value('.' parms) With . '/P:' sleepsec '/' .
sleepsec = Strip(sleepsec)
If sleepsec = '' Then
   sleepsec = sleepsec_default

/* open log file */
Call Stream log_file, 'c', 'open write'

/* /F switch (make any folder your startup folder) */
f_pos = Pos('/F:', parms)
If f_pos <> 0 Then
   Do
      Parse Value('.' orgparms) With . + (f_pos) + 4 startupfolder '/' .
      startupfolder = Strip(Strip(Strip(startupfolder), , '"'), , "'")
   End
Else
   startupfolder = startupfolder_default

/* /R switch (open object retries) */
Parse Value('.' parms) With . '/R:' retries '/' .
retries = Strip(retries)
If retries = '' Then
   retries = retries_default

/* check for install */
If install Then
   Do
      verbose = 1
      log_out = 0
   End

/* Determine location for AutoStrt.CMD and starup command */
If install Then
   Do
      config_sys = Stream(_getbootdrive() || '\config.sys', 'c', 'query exists')
      startup_cmd = Stream(_getbootdrive() || '\startup.cmd', 'c', 'query exists')
      autostrt = base_dir || 'AutoStrt.CMD'
   End

/* Do we need help? */
If Pos('/?', cmdparms) <> 0 | cmdparms = '' Then
   do_help = 1
Else
   do_help = 0
If Pos('/H', Translate(cmdparms)) <> 0 Then
   do_enhancedhelp = 1
Else
   do_enhancedhelp = 0

/* set miscellaneous options */

If Pos('/C', parms) <> 0 Then
   Do
      do_create_folder = 1
      Say 'Enter an object id for the new startup folder'
      Parse Pull ans
      If ans <> '' Then
         orgparms = '/C:' || Space(ans)
      Else
         Do
            Say 'No object id entered, folder creation bypassed'
            do_create_folder = 0
         End
   End
Else
   do_create_folder = 0

Return 1

_create_folder:                 /* create a new folder on the desktop */
verbose = 1
xrc = 0
f_pos = Pos('/C:', parms)
If f_pos <> 0 Then
   Do
      Parse Value('.' orgparms) With . + (f_pos) + 4 startupfolder '/' .
      If startupfolder <> '' Then
         Do
            startupfolder = Strip(Strip(Strip(startupfolder), , '"'), , "'")
            title = startupfolder
            startupfolder = Translate(_objtitle(Translate(startupfolder)), , ' ', '_')
            class = 'WPFolder'
            location = '<WP_DESKTOP>'
            setup = 'OBJECTID=<' || startupfolder || '>;'
            If SysCreateObject(class, title, location, setup, 'U') Then
               Do
                  Call _sayout title 'folder created or updated with setup'
                  Call _sayout setup
               End
            Else
               Do
                  Call _sayout 'Unable to create or update' title
                  xrc = 1
               End
         End
      Else
         Do
            Call _sayout 'Invalid object id entered for folder creation.'
            xrc = 1
         End
   End
Else
   Do
      Call _sayout 'No object id found for folder creation.'
      xrc = 1
   End
Return xrc

_cleanup:
Parse Arg xrc
Call _sayout prg_file 'ended.', 0
If log_out Then
   Call Lineout log_file, ''
Call Stream log_file, 'c', 'close'
Call _seticon log_file, icon_file
Call Directory(save_dir)
Return xrc

/* subroutines */

/* subroutine for objectids */
_getobjectid: Procedure Expose x autostrt. verbose log_out log_file
Parse Arg object, title
title = _objtitle(title)
If object <> '' Then
   Do
      x = x + 1; autostrt.x = "Call OpenObj '" || object || "', '" || title || "'"
   End
Else
   Do
      x = x + 1; autostrt.x = "/*" object || "', '" || title || "' is not valid */"
   End
Return 0

/* translate out carriage control characters */
_objtitle: Procedure Expose autostrt verbose log_out log_file
Parse Arg title
nlcrlf = D2c(94) || D2c(13) || D2c(10)
title = Space(Translate(title, , nlcrlf))
Return title

_objectexists: Procedure Expose autostrt verbose log_out log_file
Parse Arg object
Return WPToolsQueryObject(object)

_helpscreen:                       /* subroutine for commandline help */
verbose = 1
log_out = 0
Call _sayout 'RexxAutoStart Version 'ver' ('verdate') (c) 1998-2000 by Herwig Bauernfeind'
Call _sayout 'This is FREE software under the terms of the GNU General Public License.'
Call _sayout
Call _sayout 'Using 'rxname' Version 'rxver' ('rxdate')'
Call _sayout 'Using WPTools Version 'wptver' (c) copyright by Henk Kelder'
Call _sayout
Call _sayout '/H - Open manual.'
Call _sayout '/C - Create a folder on the desktop for use as a startup folder.'
Call _sayout '/V - Verbose. Give us some hints what we are doing right now.'
Call _sayout '/L - Log results to' log_file || '.'
Call _sayout '/I - Install RexxAutoStart.'
Call _sayout '/U - Uninstall RexxAutoStart.'
Call _sayout '/S - Build the standalone AutoStrt.CMD file.'
verbose = 0
Return 98

/* icon attachment */
_seticon: Procedure Expose verbose log_out log_file testing
save_trace = Trace('N')
Parse Arg file, icon_file
/* let us set the icon */
If testing Then
   Call _sayout "Attaching icon to" file || ".", 1
icon_parm = 'ICONFILE=' || icon_file || ';'
If SysSetObjectData(file, icon_parm) Then
   Do
      If testing Then
         Call _sayout 'Icon attached.', 2
   End
Trace(save_trace)
Return 0

_getbootdrive: Procedure
/*
    Use SysBootDrive (RexxUtils) if it is available, use RxBootDrive
    (RxExtras) if it is available, or use an alternate method to get the
    value if neither is available.  Uncomment following if _getbootdrive
    is imbedded in a routine.
*/
If \Rxfuncquery('SysBootDrive') Then
   bootdrive = SysBootDrive()       /* Object or Updated Classic Rexx */
Else
   Do
      If \Rxfuncquery('RxBootDrive') Then
         bootdrive = RxBootDrive()                        /* RxExtras */
      Else
         Do                       /* Examine various config.sys items */
            Parse Upper Value Value('path', ,'os2environment') ,
               With ':\OS2\SYSTEM' - 1 bootdrive + 2
            If bootdrive = '' Then
               bootdrive = ,
               Substr(Value('runworkplace', ,'os2environment'), 1, 2 )
            If bootdrive = '' Then
               bootdrive = ,
               Substr(Value('comspec', ,'os2environment'), 1, 2)
            If bootdrive = '' Then
               bootdrive = ,
               Substr(Value('os2_shell', ,'os2environment'), 1, 2)
            If bootdrive = '' Then
               bootdrive = ,
               Substr(Value('system_ini', ,'os2environment'), 1, 2)
            If bootdrive = '' Then
               bootdrive = ,
               Substr(Value('user_ini', ,'os2environment'), 1, 2)
            If bootdrive = '' Then                      /* no guesses */
               bootdrive = 0
         End
   End
Return bootdrive               /* Returns BootDrive, letter and colon */

/* set up RxAutoSt */
_install:
/* start the install? */
If uninstall Then
   Do
      xrc = _uninstall()
      Return xrc
   End
Call _sayout 'Setup RxAutoStart on this machine? Y/n'
Parse Upper Pull ans .
If Abbrev(ans, 'N') Then
   Return 0

Call _currentparameters     /* get and display the current parameters */
Call _configwaitfordesktop           /* configure WPS wait parameters */
Call _configdelayswitch                     /* configure delay switch */
Call _configstartupfolder                 /* configure startup folder */
Call _configsleepsec       /* configure delay between opening objects */
Call _configodwait                   /* configure object desktop wait */
Call _configlog                                  /* configure logging */
Call _configverbose                       /* configure verbose output */
Call _confirmparameters                         /* confirm parameters */
If Abbrev(ans, 'OK') Then
   Do
      Call _updateparameters                     /* update parameters */
      If standalone Then                        /* build AutoStrt.CMD */
         Call _standalone
   End
Else
   Call _sayout 'The current parameters will not be changed.'
Return 0                                                  /* complete */

/* get and display current parameters */
_currentparameters:
/* clean out the install switch */
Parse Value('.' parms) With . part_1 '/I' part_2
run_parms = Space(part_1 part_2)

/* get the parameters from the startup.cmd file */
startup_name = ''
If startup_cmd <> '' Then
   Do
      startup_name = 'RxAutoSt'
      Parse Value(Find_file_lines(startup_name, startup_cmd)) With old_startup_line_no 'LINE =' startup_line 'REM =' .
      old_startup_line_no = Space(old_startup_line_no)
      startup_line = Space(startup_line)
      If old_startup_line_no <> 0 Then
         Do
            startup_test = Strip(Strip(Translate(startup_line), , "'"), , '"')
            Parse Var startup_test . '.EXE' old_startup_parms
            If old_startup_parms = '' Then
               Parse Var startup_test . '.CMD' old_startup_parms
            old_startup_parms = Space(old_startup_parms)
         End
      Else
         Do
            startup_name = 'AutoStrt'
            Parse Value(Find_file_lines(startup_name, startup_cmd)) ,
               With old_startup_line_no 'LINE =' startup_line 'REM =' startup_line_rem
            old_startup_line_no = Space(old_startup_line_no)
            startup_line = Space(startup_line)
            If old_startup_line_no <> 0 Then
               Do
                  startup_test = Strip(Strip(Translate(startup_line), , "'"), , '"')
                  Parse Var startup_test . '.EXE' old_startup_parms
                  If old_startup_parms = '' Then
                     Parse Var startup_test . '.CMD' old_startup_parms
                  old_startup_parms = Space(old_startup_parms)
               End
            Else
               old_startup_parms = ''
         End
   End
Else
   old_startup_parms = ''

/* get the parameters from the config.sys file */
Parse Value(Find_file_lines('restartobjects', config_sys)) With restart_objects_no 'LINE =' restart_objects_line 'REM =' restart_objects_rem
If restart_objects_no <> 0 Then
   Do
      restart_objects_no = Space(restart_objects_no)
      restart_objects_line = Space(restart_objects_line)
      restart_objects = Strip(Strip(Translate(restart_objects_line), , "'"), , '"')
      Parse Var restart_objects . '=' restart_objects
   End
Else
   restart_objects = ''
restart_objects = Space(restart_objects)

Parse Value(Find_file_lines('autostart', config_sys)) With autostart_no 'LINE =' autostart_line 'REM =' autostart_rem
If autostart_no <> 0 Then
   Do
      autostart_no = Space(autostart_no)
      autostart_line = Space(autostart_line)
      autostart = Strip(Strip(Translate(autostart_line), , "'"), , '"')
      Parse Var autostart . '=' autostart
   End
Else
   autostart = ''
autostart = Space(autostart)

Parse Value(Find_file_lines('rxautost', config_sys)) With rxautost_parms_no 'LINE =' rxautost_parms_line 'REM =' .
If rxautost_parms_no <> 0 Then
   Do
      rxautost_parms_no = Space(rxautost_parms_no)
      rxautost_parms_line = Space(rxautost_parms_line)
      rxautost_parms = Strip(Strip(Translate(rxautost_parms_line), , "'"), , '"')
      Parse Var rxautost_parms . '=' rxautost_parms
   End
Else
   rxautost_parms = ''
rxautost_parms = Space(rxautost_parms)
new_rxautost_parms = ''

/* report */
Call _sayout 'The current value of your RESTARTOBJECTS'
Call _sayout 'parameter in' config_sys 'is:' restart_objects_line
Call _sayout
Call _sayout 'The current value of your AUTOSTART'
Call _sayout 'parameter in' config_sys 'is:' autostart_line
Call _sayout
If startup_name <> '' Then
   Do
      Call _sayout 'The current command line for RxAutoSt in' startup_cmd 'is:'
      Call _sayout startup_line
   End
Else
   Do
      If startup_cmd = '' Then
         Call _sayout 'There is currently no startup.cmd file on your boot drive'
      Else
         Call _sayout 'There is currently no command line for RxAutoSt in' startup_cmd
   End
Call _sayout
Call _sayout 'The current value of your RXAUTOST'
Call _sayout 'parameter in' config_sys 'is:' rxautost_parms_line
Call _sayout
old_parms = Space(old_startup_parms rxautost_parms)
If uninstall Then
   Do
      Call _sayout
      Return 0
   End
Call _sayout 'The current run parameters for RxAutoSt are:' old_parms
run_parms = ''
Call _sayout
Return 0

/* configure wait for WPS */
_configwaitfordesktop:
Call _check_rxautost_parms 0, '/WPS'
wps_wait = (Pos('/WPS', old_parms) <> 0)
If wps_wait Then
   Call _sayout 'Continue to wait for Desktop to populate before continuing? Y/n'
Else
   Call _sayout 'Wait for Desktop to populate before continuing? Y/n'
Parse Upper Pull ans .
If \Abbrev(ans, 'N') Then
   Do
      run_parms = run_parms '/WPS'
      wps_wait = 1
   End
Else
   wps_wait = 0
Call _check_rxautost_parms wps_wait, '/WPS'
Return 0

/* configure delay switch */
_configdelayswitch:
save_trace = Trace()
Parse Value('.' old_parms) With . '/D:' old_delay_wait '/' .
old_delay_wait = Strip(old_delay_wait)
If old_delay_wait = '' | \Datatype(old_delay_wait, 'W') Then
   old_delay_wait = delay_wait_default
If old_delay_wait <> delay_wait_default Then
   delay_wait_parm = '/D:' || old_delay_wait
Else
   delay_wait_parm = ''
Call _sayout 'Enter time to delay before proceeding, or press enter'
Call _sayout 'to keep the current setting of' old_delay_wait 'second(s).'
Call _sayout '(default =' delay_wait_default || ')'
Parse Upper Pull new_delay_wait .
If Datatype(new_delay_wait, 'W') & ,
   new_delay_wait <> old_delay_wait Then
   Do
      Parse Value('.' run_parms) With part_1 '/D:' . part_2
      run_parms = Space(Strip(part_1, , '.') part_2)
      If new_delay_wait <> delay_wait_default Then
         delay_wait_parm = '/D:' || new_delay_wait
      Else
         delay_wait_parm = ''
   End
If delay_wait_parm <> '' Then
   run_parms = run_parms delay_wait_parm
Call _check_rxautost_parms Value(delay_wait_parm <> ''), delay_wait_parm
Trace(save_trace)
Return 0

/* configure startup folder */
_configstartupfolder:
Parse Value('.' old_parms) With . '/F:' old_startup_folder '/' .
If old_startup_folder <> '' Then
   startup_folder_parm = '/F:' || old_startup_folder
Else
   startup_folder_parm = ''
Call _sayout 'Enter the object id of your startup folder, or press enter'
Call _sayout 'to keep' startupfolder 'as your RxAutoSt startup folder.'
Call _sayout '(default = <WP_START>)'
Parse Upper Pull ans .
If ans <> '' Then
   Do
      ans = '<' || Strip(Strip(ans, , '>'), , '<') || '>'
      If _objectexists(ans) & ,
         ans <> '<WP_START>' & ,
         ans <> old_startup_folder Then
         Do
            Parse Value('.' run_parms) With part_1 '/F:' . part_2
            run_parms = Space(Strip(part_1, , '.') part_2)
            startup_folder_parm = '/F:"' || ans || '"'
            run_parms = run_parms startup_folder_parm
            startupfolder = ans
         End
      Else
         Do
            Call _sayout ans 'does not exist, keeping' startupfolder
            Call _sayout 'as your startup folder.'
         End
   End
If startup_folder_parm <> '' Then
   run_parms = run_parms startup_folder_parm
Call _check_rxautost_parms Value(startup_folder_parm <> ''), startup_folder_parm
Return 0

/* configure delay between opening objects */
_configsleepsec:
Parse Value('.' old_parms) With . '/P:' old_sleepsec '/' .
old_sleepsec = Strip(old_sleepsec)
If old_sleepsec = '' | \Datatype(old_sleepsec, 'W') Then
   old_sleepsec = sleepsec_default
If old_sleepsec <> sleepsec_default Then
   sleepsec_parm = '/P:' || old_sleepsec
Else
   sleepsec_parm = ''
Call _sayout 'Enter the time to delay between the opening of objects in your'
Call _sayout 'startup folder (' || startupfolder || '), or press enter to keep the'
Call _sayout 'current setting of' old_sleepsec 'second(s).'
Call _sayout '(default =' sleepsec_default || ')'
Parse Upper Pull new_sleepsec .
If Datatype(new_sleepsec, 'W') & ,
   new_sleepsec <> old_sleepsec Then
   Do
      Parse Value('.' run_parms) With part_1 '/P:' . part_2
      run_parms = Space(Strip(part_1, , '.') part_2)
      If new_sleepsec <> sleepsec_default Then
         sleepsec_parm = '/P:' || new_sleepsec
      Else
         sleepsec_parm = ''
   End
If sleepsec_parm <> '' Then
   run_parms = run_parms sleepsec_parm
Call _check_rxautost_parms Value(sleepsec_parm <> ''), sleepsec_parm
Return 0

/* configure Object Desktop wait */
_configodwait:
If objdesk Then
   Do
      od_wait = (Pos('/OD', old_parms) <> 0)
      If od_wait Then
         Call _sayout 'Continue to wait for Object Desktop to open before continuing? Y/n'
      Else
         Call _sayout 'Wait for Object Desktop to open before continuing? Y/n'
      Parse Upper Pull ans .
      If \Abbrev(ans, 'N') Then
         Do
            od_wait = 1
            Parse Value('.' old_parms) With . '/OD:' old_od_tries '/' .
            If old_od_tries = '' Then
               old_od_tries = od_tries_default
            Call _sayout 'Enter the number of times to check for Object Desktop,'
            Call _sayout 'or press enter to keep the current setting (' old_od_tries ').'
            Call _sayout '(default =' od_tries_default || ')'
            Parse Upper Pull new_od_tries .
            If Datatype(new_od_tries, 'W') & ,
               new_od_tries <> old_od_tries Then
               od_tries = new_od_tries
            If Pos('/OD:', run_parms) <> 0 Then
               Parse Value('.' run_parms) With part_1 '/OD:' . part_2
            Else
               Parse Value('.' run_parms) With part_1 '/OD' part_2
            run_parms = Space(Strip(part_1, , '.') part_2)
            If od_tries = od_tries_default Then
               od_wait_parm = '/OD'
            Else
               od_wait_parm = '/OD:' || od_tries
            run_parms = run_parms od_wait_parm
         End
      Else
         Do
            od_wait = 0
         End
   End
Else
   Do
      od_wait = 0
      od_tries = 0
   End
Call _check_rxautost_parms od_wait, od_wait_parm
Return 0

/* configure logging */
_configlog:
If Wordpos('/L', old_parms) <> 0 Then
   Do
      log_out_parm = '/L'
      Call _sayout 'Do you want to continue to log to' log_file ||'? Y/n'
      Parse Upper Pull ans .
      ans = \Abbrev(ans, 'N')
   End
Else
   Do
      log_out_parm = ''
      Call _sayout 'Do you want to log to' log_file ||'? y/N'
      Parse Upper Pull ans .
      ans = Abbrev(ans, 'Y')
   End
If ans Then
   Do
      new_log_out = 1
      log_out_parm = '/L'
      run_parms = Space(run_parms log_out_parm)
   End
Else
   new_log_out = 0
Call _check_rxautost_parms new_log_out, log_out_parm
Return 0

/* configure verbose output */
_configverbose:
If Wordpos('/V', old_parms) <> 0 Then
   Do
      verbose_parm = '/V'
      Call _sayout 'Do you want continue to have verbose output to the window? Y/n'
      Parse Upper Pull ans .
      ans = \Abbrev(ans, 'N')
   End
Else
   Do
      verbose_parm = ''
      Call _sayout 'Do you want verbose output to the window? y/N'
      Parse Upper Pull ans .
      ans = Abbrev(ans, 'Y')
   End
If ans Then
   Do
      new_verbose = 1
      verbose_parm = '/V'
      run_parms = run_parms verbose_parm
   End
Else
   new_verbose = 0
Call _check_rxautost_parms new_verbose, verbose_parm
Return 0

/* check for modification of SET RXAUTOST= */
_check_rxautost_parms:
save_trace = Trace()
Parse Arg parm_status, parm_value
If parm_status Then
   Do
      If Wordpos(parm_value, new_rxautost_parms) = 0 Then
         Do
            Call _sayout 'Would you like to modify the SET RXAUTOST= parameter'
            Call _sayout 'in' config_sys 'to include the' parm_value 'parameter? y/N'
            Parse Upper Pull ans .
            If Abbrev(ans, 'Y') Then
               new_rxautost_parms = Space(new_rxautost_parms parm_value)
         End
   End
Else
   Do
      If Wordpos(parm_value, new_rxautost_parms) <> 0 Then
         Do
            Call _sayout
            Call _sayout 'Removing the' parm_value 'parameter from the'
            Call _sayout 'SET RXAUTOST= statement in' config_sys
            test_pos = Wordpos(parm_value, new_rxautost_parms)
            Select
               When test_pos = 1 Then
                  new_rxautost_parms = Subword(new_rxautost_parms, 2)
               When test_pos = Words(new_rxautost_parms) Then
                  new_rxautost_parms = Subword(new_rxautost_parms, 1, test_pos - 1)
               When test_pos <> 0 Then
                  new_rxautost_parms = Subword(new_rxautost_parms, 1, test_pos - 1) ,
                  Subword(new_rxautost_parms, test_pos + 1)
               Otherwise Nop
            End
            new_rxautost_parms = Space(new_rxautost_parms)
         End
   End
Trace(save_trace)
Return 0

/* confirm parameters */
_confirmparameters:
If Pos('/X', Translate(run_parms)) = 0 Then
   run_parms = Space('/X' run_parms)
Else
   run_parms = Space(run_parms)
If new_rxautost_parms <> '' Then    /* parse out duplicate parameters */
   Do
      Do x = 1 To Words(new_rxautost_parms)
         test_rxautost = Word(new_rxautost_parms, x)
         test_rxautost_pos = Wordpos(test_rxautost, run_parms)
         Select
            When test_rxautost_pos = 1 Then
               run_parms = Subword(run_parms, 2)
            When test_rxautost_pos = Words(run_parms) Then
               run_parms = Subword(run_parms, 1, test_rxautost_pos - 1)
            When test_rxautost_pos > 1 Then
               run_parms = Subword(run_parms, 1, test_rxautost_pos - 1) ,
               Subword(run_parms, test_rxautost_pos + 1)
            Otherwise Nop
         End
      End
   End
run_parms = Space(run_parms)
Call _sayout 'You have selected the following parameters for RxAutoSt.'
Call _sayout run_parms
If new_rxautost_parms <> '' Then
   Do
      Call _sayout 'and the following parameters will be used from SET RXAUTOST='
      Call _sayout new_rxautost_parms
   End
Call _sayout
Call _sayout 'Type OK and press enter to continue.'
Parse Upper Pull ans .
Return 0

/* update all parameters */
_updateparameters:
Call _sayout
Call _updateinfo              /* display parameter update information */
If Abbrev(ans, 'OK') Then
   Do
      Call _updateconfigsys           /* update config.sys parameters */
      Call _updatestartupcmd                    /* update startup.cmd */
      Call _sayout 'The processed changes will be active at the next re-boot.'
   End
Else
   Call _sayout 'The current parameters will not be changed.'
Return 0


/* display parameter update information */
_updateinfo:

/* config.sys */
do_restart_objects_rem = 0
do_restart_objects_add = 0
If restart_objects <> 'NO' Then
   Do
      do_restart_objects = 1
      If restart_objects_no <> 0 Then
         Do
            do_restart_objects_rem = 1
            Call _sayout restart_objects_line 'will be REMed out of'
            Call _sayout config_sys 'and replaced by SET RESTARTOBJECTS=NO.'
         End
      Else
         Do
            do_restart_objects_add = 1
            Call _sayout 'SET RESTARTOBJECTS=NO will be added to' config_sys
         End
      Call _sayout
   End
do_restart_objects = do_restart_objects_rem | do_restart_objects_add

do_autostart_rem = 0
do_autostart_add = 0
If Pos('WARPCENTER', autostart) <> 0 | Pos('LAUNCHPAD', autostart) <> 0 Then
   Do
      If autostart_no <> 0 Then
         Do
            do_autostart_rem = 1
            Parse Value('.' autostart) With . part1 'WARPCENTER' part2
            autostart = part1 || part2
            Parse Value('.' autostart) With . part1 'LAUNCHPAD' part2
            autostart = part1 || part2
            autostart = Strip(autostart, , ',')
            If Pos(',,', autostart) <> 0 Then
               Do
                  Parse Value('.' autostart) With . part1 ',,' part2
                  autostart = part1 || ',' || part2
               End
            Call _sayout autostart_line 'will be REMed out of'
            Call _sayout config_sys 'and replaced by SET AUTOSTART=' || autostart
         End
      Call _sayout
   End
do_autostart = do_autostart_rem | do_autostart_add

/* update SET RXAUTOST= */
do_rxautost_repl = 0
do_rxautost_add = 0
If rxautost_parms <> new_rxautost_parms Then
   Do
      do_rxautost = 1
      If rxautost_parms_no <> 0 Then
         Do
            do_rxautost_repl = 1
            Call _sayout rxautost_parms_line 'will be replaced in'
            Call _sayout config_sys 'by SET RXAUTOST=' || new_rxautost_parms || '.'
         End
      Else
         Do
            do_rxautost_add = 1
            Call _sayout 'SET RXAUTOST=' || new_rxautost_parms 'will be added to' config_sys
         End
      Call _sayout
   End
do_rxautost = do_rxautost_repl | do_rxautost_add

/* startup.cmd */
autofile = exe_file
If standalone Then
   autofile = autostrt
rxautost_cmd = 'START "Rexx AutoStart" /C /MIN /I' autofile run_parms
do_startup_new = 0
do_startup_rem = 0
do_startup_add = 0
Select
   When startup_cmd = '' Then               /* build startup.cmd file */
      Do
         do_startup_new = 1
         startup_cmd = _getbootdrive() || '\startup.cmd'
         Call _sayout startup_cmd 'will be created, and'
         Call _sayout rxautost_cmd
         Call _sayout 'will be added to' startup_cmd
      End
   When (old_startup_line_no <> 0) & (startup_line <> rxautost_cmd) Then
      Do
         do_startup_rem = 1
         Call _sayout startup_line
         Call _sayout 'will be REMed out of' startup_cmd 'and replaced with:'
         Call _sayout rxautost_cmd
         Call _sayout
      End
   When old_startup_line_no = 0 Then/* add rxautost cmd to startup.cmd */
      Do
         do_startup_add = 1
         Call _sayout rxautost_cmd
         Call _sayout 'will be added to' startup_cmd
      End
   Otherwise Nop
End
do_startup = do_startup_new | do_startup_rem | do_startup_add

If do_restart_objects | ,
   do_autostart | ,
   do_rxautost | ,
   do_startup | ,
   standalone Then
   Do
      If standalone Then
         Call _sayout 'The standalone' autofile 'will be built.'
      Call _sayout
      Call _sayout 'Type OK and press enter to continue.'
      Parse Upper Pull ans .
   End
Else
   Do
      Call _sayout 'There are no changes required.'
      ans = ''
   End
Return 0

/* update config.sys parameters */
_updateconfigsys:
If do_restart_objects | do_autostart | do_rxautost Then
   Do
      If Stem_utility('lines.', 'r', 1, config_sys) Then
         Do
            Call _sayout 'Updating' config_sys 'in storage.'
            /* do rem out and/or replacement before we insert */
            If do_restart_objects_rem Then
               Do
                  Call _sayout 'REM line' restart_objects_no 'in' config_sys
                  lines.restart_objects_no = 'REM' lines.restart_objects_no
               End
            If do_autostart_rem Then
               Do
                  Call _sayout 'REM line' autostart_no 'in' config_sys
                  lines.autostart_no = 'REM' lines.autostart_no
               End
            If do_rxautost_repl Then
               Do
                  Call _sayout 'Replacing line' rxautost_parms_no 'in' config_sys
                  lines.rxautost_parms_no = 'SET RXAUTOST=' || new_rxautost_parms
               End
            /* now do the inserts */
            Select
               When do_restart_objects_rem & do_autostart_rem Then
                  Do
                     If restart_objects_no < autostart_no Then
                        Do
                           Call Insert_restart_objects
                           autostart_no = autostart_no + 1
                           Call Insert_autostart
                        End
                     Else
                        Do
                           Call Insert_autostart
                           restart_objects_no = restart_objects_no + 1
                           Call Insert_restart_objects
                        End
                  End
               When do_restart_objects_rem & \do_autostart_rem Then
                  Call Insert_restart_objects
               When do_autostart_rem & \do_restart_objects_rem Then
                  Call Insert_autostart
               Otherwise Nop
            End
            /* now do the additions */
            If do_restart_objects_add Then
               Do
                  data = 'SET RESTARTOBJECTS=NO'
                  Call _sayout 'Adding' data 'to' config_sys
                  Call Stem_utility 'lines.', 'i', 0, data
               End
            If do_rxautost_add Then
               Do
                  data = 'SET RXAUTOST=' || new_rxautost_parms
                  Call _sayout 'Adding' data 'to' config_sys
                  Call Stem_utility 'lines.', 'i', 0, data
               End
            temp_file = SysTempFileName('config.???')
            Call _sayout 'Renaming' config_sys 'to' temp_file
            Address cmd '@rename' config_sys temp_file
            If Stem_utility('lines.', 'w', 1, config_sys) Then
               Call _sayout 'Wrote updated' config_sys 'from storage.'
            Else
               Do
                  Call _sayout 'Write of' config_sys 'failed.'
                  temp_file = Filespec('d', config_sys) || Filespec('p', config_sys) || temp_file
                  config_sys = Filespec('n', config_sys)
                  Call _sayout 'Renaming' temp_file 'back to' config_sys
                  Address cmd '@rename' temp_file config_sys
               End
            Call _sayout
         End
      Else
         Call _sayout 'Failed to read' config_sys
   End
Return 0

Insert_restart_objects:
data = 'SET RESTARTOBJECTS=NO'
Call _sayout 'Inserting' data 'into' config_sys
Call Stem_utility 'lines.', 'i', restart_objects_no, data
Return 0

Insert_autostart:
data = 'SET AUTOSTART=' || autostart
Call _sayout 'Inserting' data 'into' config_sys
Call Stem_utility 'lines.', 'i', autostart_no, data
Return 0

/* update startup.cmd */
_updatestartupcmd:
If do_startup_rem | do_startup_add Then
   Do
      Call Stem_utility 'lines.', 'r', 1, startup_cmd
      exit_line_no = 0
      startup_line_rem = ''
      Do x = 1 To lines.0
         test_line = Translate(lines.x)      /* translate for testing */
         /* look for EXIT */
         If \Abbrev(test_line, 'REM') Then
            Do
               If Pos('EXIT', test_line) <> 0 & exit_line_no = 0 Then
                  exit_line_no = x
            End
         /* look for old REMmed rxautost lines */
         Else
            Do
               If Pos('RXAUTOST', test_line) <> 0 Then
                  startup_line_rem = startup_line_rem x
            End
      End
      startup_line_rem = Space(startup_line_rem)
      Call _sayout 'Updating' startup_cmd 'in storage.'
      If do_startup_rem Then
         Do
            Call _sayout 'REM line' old_startup_line_no 'in' startup_cmd
            lines.old_startup_line_no = 'REM' lines.old_startup_line_no
         End
      /* insert line */
      Call _sayout 'Inserting' rxautost_cmd 'into' startup_cmd
      Call Stem_utility 'lines.', 'i', exit_line_no, rxautost_cmd
      If startup_line_rem <> '' Then      /* get rid of old REM lines */
         Do
            rem_lines = ''
            Do x = 1 To Words(startup_line_rem)/* adjust line numbers */
               If Word(startup_line_rem, x) = old_startup_line_no Then
                  Iterate x
               If x = 1 Then
                  rem_lines = Word(startup_line_rem, x)
               Else
                  rem_lines = rem_lines (Word(startup_line_rem, x) - Words(rem_lines))
            End
            If rem_lines <> '' Then
               Do x = 1 To Words(rem_lines)
                  rem_line = Word(rem_lines, x)
                  Call _sayout 'Deleting line' rem_line 'in' startup_cmd
                  Call Stem_utility 'lines.', 'd', rem_line
               End
         End
      temp_file = SysTempFileName('startup.???')
      Call _sayout 'Renaming' startup_cmd 'to' temp_file
      Address cmd '@rename' startup_cmd temp_file
      If Stem_utility('lines.', 'w', 1, startup_cmd) Then
         Call _sayout 'Wrote updated' startup_cmd 'from storage.'
      Else
         Do
            Call _sayout 'Write of' startup_cmd 'failed.'
            temp_file = Filespec('d', startup_cmd) || Filespec('p', startup_cmd) || temp_file
            startup_cmd = Filespec('n', startup_cmd)
            Call _sayout 'Renaming' temp_file 'back to' startup_cmd
            Address cmd '@rename' temp_file startup_cmd
         End
   End
If do_startup_new Then
   Do
      Call _sayout 'Building' startup_cmd
      Call Stream startup_cmd, 'c', 'open write'
      Call Lineout startup_cmd, '@ECHO OFF'
      Call Lineout startup_cmd, rxautost_cmd
      Call Lineout startup_cmd, 'EXIT'
      Call Stream startup_cmd, 'c', 'close'
   End
Call _sayout
Return 0

_uninstall:
/* start the uninstall? */
Call _sayout 'Uninstall RxAutoSt on this machine? y/N'
Parse Upper Pull ans .
If \Abbrev(ans, 'Y') Then
   Return 0

Call _currentparameters     /* get and display the current parameters */
/* select the new restartobjects line in config.sys */
restart_objects_lines = Space(restart_objects_rem restart_objects_no)
If Wordpos('0', restart_objects_lines) = 0 Then
   restart_objects_lines = restart_objects_lines '0'
Call Stem_utility 'config.', 'r', 1, config_sys
Call _sayout
Call _sayout 'Select the number of the desired SET RESTARTOBJECTS= line,'
Call _sayout 'or enter cancel to abort the changes to' config_sys
ans = ''
Do Until (Datatype(ans, 'W') & (Wordpos(ans, restart_objects_lines) <> 0)) | ,
      ans = 'CANCEL'
   Do x = 1 To Words(restart_objects_lines)
      y = Word(restart_objects_lines, x)
      If y <> 0 Then
         Call _sayout Right(y, 4) config.y
      Else
         Call _sayout Right(y, 4) 'Default'
   End
   Parse Upper Pull ans
   If ans <> 'CANCEL' Then
      Do
         If \Datatype(ans, 'W') | Wordpos(ans, restart_objects_lines) = 0 Then
            Do
               Call _sayout
               Call _sayout 'Invalid response.'
               Call _sayout 'Select the number of the desired SET RESTARTOBJECTS= line,'
               Call _sayout 'or enter cancel to abort the changes to' config_sys
            End
      End
End
Call _sayout
If ans \= 'CANCEL' Then
   Do
      restart_objects_new_no = ans
      If restart_objects_new_no <> restart_objects_no Then
         Do
            If restart_objects_new_no <> 0 Then
               config.restart_objects_new_no = Space(config.restart_objects_new_no)
            Call _sayout 'Line' restart_objects_no 'in' config_sys
            Call _sayout config.restart_objects_no
            Call _sayout 'will be REMmed out of' config_sys
            Call _sayout
            If restart_objects_new_no <> 0 Then
               Do
                  test_line = Translate(config.restart_objects_new_no)
                  Parse Value('.' test_line) With . 'REM' config.restart_objects_new_no
                  config.restart_objects_new_no = Space(config.restart_objects_new_no)
                  Call _sayout 'Line' restart_objects_new_no 'in' config_sys
                  Call _sayout config.restart_objects_new_no
                  Call _sayout 'will be made the active SET RESTARTOBJECT= line'
               End
            Else
               Do
                  Call _sayout config_sys 'will no longer contain'
                  Call _sayout 'a SET RESTARTOBJECTS= line.'
               End
            Call _sayout
            Call _sayout 'Type OK and press enter to continue.'
            Parse Upper Pull ans .
            If Abbrev(ans, 'OK') Then
               Do
                  Call _sayout 'Updating' config_sys 'in storage.'
                  If restart_objects_no <> 0 Then
                     Do
                        Call _sayout 'REM line' restart_objects_no 'in' config_sys
                        config.restart_objects_no = 'REM' config.restart_objects_no
                     End
                  If restart_objects_new_no <> 0 Then
                     Do
                        Call _sayout 'Making line' restart_objects_new_no 'in' config_sys
                        Call _sayout 'the active SET RESTARTOBJECTS= line'
                     End
                  temp_file = SysTempFileName('config.???')
                  Call _sayout 'Renaming' config_sys 'to' temp_file
                  Address cmd '@rename' config_sys temp_file
                  Call _sayout 'Writing updated' config_sys 'from storage.'
                  Call Stem_utility 'config.', 'w', 1, config_sys
                  Call _sayout
               End
         End
      Else
         Call _sayout 'No changes are required to' config_sys
   End
Else
   Call _sayout 'No changes will be made to' config_sys

/* rem out the rxautost line in startup.cmd */
Call _sayout
If startup_line <> '' Then
   Do
      Call _sayout startup_line
      Call _sayout 'will REMmed out of' startup_cmd
      Call _sayout
      Call _sayout 'Type OK and press enter to continue.'
      Parse Upper Pull ans .
      Call _sayout
      If Abbrev(ans, 'OK') Then
         Do
            Call Stem_utility 'startup.', 'r', 1, startup_cmd
            Call _sayout 'Updating' startup_cmd 'in storage.'
            Call _sayout 'REM line' old_startup_line_no 'in' startup_cmd
            startup.old_startup_line_no = 'REM' startup_line
            temp_file = SysTempFileName('startup.???')
            Call _sayout 'Renaming' startup_cmd 'to' temp_file
            Address cmd '@rename' startup_cmd temp_file
            Call _sayout 'Writing updated' startup_cmd 'from storage.'
            Call Stem_utility 'startup.', 'w', 1, startup_cmd
         End
      Else
         Do
            Call _sayout startup_cmd 'will not be changed.'
         End
   End
Else
   Call _sayout 'No changes are required to' startup_cmd
Call _sayout
Return 0

/* build standalone AutoStrt.CMD */
_standalone:

Call _sayout "Creating script" autostrt || ".", 1

auto. = ''
x = 0
/* Init code for AutoStrt.CMD */
x = x + 1; autostrt.x = "/* RexxAutoStart Script (created "Date()" at "Time()" by RxAutoSt "ver")  */"
x = x + 1; autostrt.x = ""
x = x + 1; autostrt.x = "/* Get into current directory */"
x = x + 1; autostrt.x = "Parse Source . . prg_file ."
x = x + 1; autostrt.x = "our_dir = Strip(Filespec('d', prg_file) || Filespec('p', prg_file), , '\')"
x = x + 1; autostrt.x = "save_dir = Directory(our_dir)"
x = x + 1; autostrt.x = ""
x = x + 1; autostrt.x = "/* Register Rexx functions. */"
x = x + 1; autostrt.x = "Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'"
x = x + 1; autostrt.x = "Call SysLoadFuncs"
x = x + 1; autostrt.x = "/* Register WPTools functions. */"
x = x + 1; autostrt.x = "Call Rxfuncadd 'WPToolsLoadFuncs', 'WPTOOLS', 'WPToolsLoadFuncs'"
x = x + 1; autostrt.x = "Call WPToolsLoadFuncs"
x = x + 1; autostrt.x = ""
x = x + 1; autostrt.x = "Parse Upper Arg parms"
x = x + 1; autostrt.x = "parms = parms Translate(Value('rxautost', , 'os2environment'))"
x = x + 1; autostrt.x = "Parse Source . . prgfile ."
x = x + 1; autostrt.x = ""
x = x + 1; autostrt.x = "verbose = (Pos('/V',parms) <> 0) /* verbose output */"
x = x + 1; autostrt.x = "log_out = (Pos('/L',parms) <> 0) /* logging */"
x = x + 1; autostrt.x = ""
x = x + 1; autostrt.x = "log_file = '" || log_file || "'"
x = x + 1; autostrt.x = "Call Stream log_file, 'c', 'open write'"
x = x + 1; autostrt.x = "Call _sayout prgfile 'started.'"
x = x + 1; autostrt.x = "Call _sayout 'Using parameters' parms, 2"
x = x + 1; autostrt.x = ""

Call _sayout "Verbose output is enabled.", 2
Call _sayout "Logging to" log_file "is enabled.", 2

If wps_wait Then
   Do
      Call _sayout "Will wait for population of Desktop.", 2
      x = x + 1; autostrt.x = "/* wait for population of Desktop */"
      x = x + 1; autostrt.x = "Call _sayout 'Will wait for population of Desktop.', 1"
      If warp4 Then
         Do
            x = x + 1; autostrt.x = "/* Wait for Warp 4 or WSeB */"
            x = x + 1; autostrt.x = "Call SysWaitForShell 'DESKTOPPOPULATED'"
         End
      Else
         Do
            x = x + 1; autostrt.x = "/* Wait for Warp 3 */"
            x = x + 1; autostrt.x = "xrc = SysIni('USER', 'PM_InstallObject', 'ALL:', 'stem')"
            x = x + 1; autostrt.x = "Do While xrc \= 'ERROR:'"
            x = x + 1; autostrt.x = "   Call SysSleep sleepsec"
            x = x + 1; autostrt.x = "   xrc = SysIni('USER', 'PM_InstallObject', 'ALL:', 'stem')"
            x = x + 1; autostrt.x = "End"
         End
      x = x + 1; autostrt.x = "Call _sayout 'Desktop has been populated. Continuing...', 2"
      x = x + 1; autostrt.x = ""
   End
If delay_wait <> 0 Then
   Do
      Call _sayout 'Further processing will be delayed for' delay_wait 'seconds.'
      x = x + 1; autostrt.x = "/* delay processing for" delay_wait "seconds */"
      x = x + 1; autostrt.x = "Call _sayout 'Delay further execution by' delay_wait 'seconds.', 1"
      x = x + 1; autostrt.x = "Call SysSleep" delay_wait
      x = x + 1; autostrt.x = "Call _sayout delay_wait' seconds have passed. Continuing...', 2"
      x = x + 1; autostrt.x = ""
   End

Call _sayout 'The minimum delay between the opening of objects is' sleepsec 'seconds.', 2

If od_wait Then
   Do
      Call _sayout "Will wait for Object Desktop to start.", 2
      Call _sayout 'The status of Object Desktop will be checked up to' od_tries 'times.', 2
      x = x + 1; autostrt.x = '/* wait for Object Desktop */'
      x = x + 1; autostrt.x = "Call _sayout 'Waiting for Object Desktop to start.', 1"
      If od_cc Then
         Do
            x = x + 1; autostrt.x = "Call _sayout 'Waiting for [Control Center]', 2"
            x = x + 1; autostrt.x = "Parse Value(_waitod('Control Center'," sleepsec || "," od_tries || ")) With success tries ."
            x = x + 1; autostrt.x = "If success Then"
            x = x + 1; autostrt.x = "   open_msg = '['Control Center'] has opened after' tries 'check(s).'"
            x = x + 1; autostrt.x = "Else"
            x = x + 1; autostrt.x = "   open_msg = '['Control Center'] has not opened after' tries 'check(s).'"
            x = x + 1; autostrt.x = "Call _sayout open_msg, 3"
         End
      If od_tlp Then
         Do
            x = x + 1; autostrt.x = "Call _sayout 'Waiting for [Tab LaunchPad]', 2"
            x = x + 1; autostrt.x = "Parse Value(_waitod('Tab LaunchPad'," sleepsec || "," od_tries || ")) With success tries ."
            x = x + 1; autostrt.x = "If success Then"
            x = x + 1; autostrt.x = "   open_msg = '['Tab LaunchPad'] has opened after' tries 'check(s).'"
            x = x + 1; autostrt.x = "Else"
            x = x + 1; autostrt.x = "   open_msg = '['Tab LaunchPad'] has not opened after' tries 'check(s).'"
            x = x + 1; autostrt.x = "Call _sayout open_msg, 3"
         End
      x = x + 1; autostrt.x = "If success Then"
      x = x + 1; autostrt.x = "   open_msg = 'Object Desktop is started. Continuing...'"
      x = x + 1; autostrt.x = "Else"
      x = x + 1; autostrt.x = "   open_msg = 'Object Desktop has not started. Continuing...'"
      x = x + 1; autostrt.x = "Call _sayout open_msg, 2"
      x = x + 1; autostrt.x = ""
   End

Call _sayout "Adding objects from startup folder" startupfolder".", 2

x = x + 1; autostrt.x = "/* open objects in" startupfolder "*/"
If WPToolsFolderContent(startupfolder, 'list.', 'F') Then
   Do
      If list.0 > 0 Then
         Do
            list_start = 1
            list_end = list.0
            list_incr = 1
            If wseb Then
               Do
                  list_start = list.0
                  list_end = 1
                  list_incr = -1
               End
            Do i = list_start To list_end By list_incr
               If WPToolsQueryObject(list.i, 'szclass', 'sztitle') Then
                  Do
                     Call _sayout "Adding object '"_objtitle(sztitle)"' of class "szclass'.', 3
                     Call _getobjectid list.i, sztitle
                  End
            End
            Call _sayout 'Object addition completed.', 2
         End
      Else
         Call _sayout 'No objects found in' startupfolder || '.', 3
   End
Else
   Call _sayout 'Query content of' startupfolder 'failed.', 2

/* Exit point of AutoStrt.CMD */
x = x + 1; autostrt.x = ""
x = x + 1; autostrt.x = "Call _sayout prgfile 'ended.'"
x = x + 1; autostrt.x = "If log_out Then"
x = x + 1; autostrt.x = "   Call Lineout log_file, ''"
x = x + 1; autostrt.x = "Call Stream log_file, 'c', 'close'"
x = x + 1; autostrt.x = "Exit 0"
x = x + 1; autostrt.x = ""

/*  The "working" part of AutoStrt.CMD */
x = x + 1; autostrt.x = "/* Wait, try to open object, tell us what happened */"
x = x + 1; autostrt.x = "OpenObj:"
x = x + 1; autostrt.x = "   Parse Arg id, title"
x = x + 1; autostrt.x = "   success = 0"
x = x + 1; autostrt.x = "   open_parm = 'OPEN=DEFAULT;CCVIEW=NO;'"
x = x + 1; autostrt.x = "   Do x = 1 To" retries "Until success"
x = x + 1; autostrt.x = "      Call SysSleep" sleepsec
x = x + 1; autostrt.x = "      success = WPToolsSetObjectData(id, open_parm)"
x = x + 1; autostrt.x = "   End"
x = x + 1; autostrt.x = "   If success Then"
x = x + 1; autostrt.x = "      open_msg = '['Title'] has opened after' x 'attempt(s) of" retries || ".'"
x = x + 1; autostrt.x = "   Else"
x = x + 1; autostrt.x = "      open_msg = '['Title'] failed to open after" retries "attempts.'"
x = x + 1; autostrt.x = "   Call _sayout open_msg, 1"
x = x + 1; autostrt.x = "Return 0 /* End OpenObj */"
x = x + 1; autostrt.x = ""

/* Object Desktop wait subroutine */
If od_wait Then
   Do
      x = x + 1; autostrt.x = "/* wait for Object Desktop */"
      x = x + 1; autostrt.x = "_waitod: Procedure Expose verbose log_out log_file"
      x = x + 1; autostrt.x = "   Parse Arg title, sleep, od_tries"
      x = x + 1; autostrt.x = "   rc_task = 0"
      x = x + 1; autostrt.x = "   attempts = 0"
      x = x + 1; autostrt.x = "   If \Rxfuncquery('SysQuerySwitchList') Then"
      x = x + 1; autostrt.x = "      Do i = 1 To od_tries Until rc_task"
      x = x + 1; autostrt.x = "         attempts = attempts + 1"
      x = x + 1; autostrt.x = "         Call SysSleep sleep"
      x = x + 1; autostrt.x = "         Call SysQuerySwitchList 'tasks.', 'IGN'"
      x = x + 1; autostrt.x = "         Do j = 1 To tasks.0 Until rc_task"
      x = x + 1; autostrt.x = "            rc_task = (Pos(title, tasks.j) <> 0)"
      x = x + 1; autostrt.x = "         End"
      x = x + 1; autostrt.x = "      End"
      x = x + 1; autostrt.x = "   Else"
      x = x + 1; autostrt.x = "      Call _sayout 'SysQuerySwitchList not available, returning...'"
      x = x + 1; autostrt.x = "Return rc_task attempts"
      x = x + 1; autostrt.x = ""
   End

x = x + 1; autostrt.x = "/* console and log file output procedure */"
x = x + 1; autostrt.x = "_sayout: Procedure Expose verbose log_out log_file"
x = x + 1; autostrt.x = "Parse Arg msg, level"
x = x + 1; autostrt.x = "If \Datatype(level, 'W') Then level = 0"
x = x + 1; autostrt.x = "msg = copies(' ', level) || msg"
x = x + 1; autostrt.x = "If verbose Then"
x = x + 1; autostrt.x = "   Call Lineout , msg"
x = x + 1; autostrt.x = "If log_out Then"
x = x + 1; autostrt.x = "   Call Lineout log_file, Date() Time() msg"
x = x + 1; autostrt.x = "Return 0"
x = x + 1; autostrt.x = ""

/* script complete, delete any existing script and write out the new one */
autostrt.0 = x
If Stem_utility('autostrt.', 'w', 1, autostrt) Then
   Do
      Call _sayout autostrt 'created.', 1
      Call _seticon autostrt, icon_file
   End
Else
   Call _sayout 'Failed to write' autostrt
Return 0

/* find a line in a file and return the number, line, and all remmed out lines */
Find_file_lines: Procedure
save_trace = Trace('N')
Parse Arg phrase, file
xrc = SysFileSearch(phrase, file, 'lines.', 'N')
found_line_no = 0
found_line = ''
line_rem_no = ''
If xrc = 0 & lines.0 <> 0 Then
   Do i = 1 To lines.0
      Parse Var lines.i line_no line
      line_test = Strip(Strip(Translate(line), , "'"), , '"')
      If Abbrev(line_test, 'REM') Then
         Do
            line_rem_no = line_rem_no line_no
            Iterate i
         End
      Else
         Do
            found_line_no = line_no
            found_line = line
         End
   End
Trace (save_trace)
Return found_line_no 'LINE =' found_line 'REM =' line_rem_no

/* manipulate stems */
/* parameters
   stem_utility('stem', 'action', pos, 'data/file')
   where stem      = the name of a stem to be operated upon
         action    = Insert, Delete, Read, Write
            Insert = insert data into stem at pos
            Delete = delete data from stem at pos
            Read   = Read file into stem.
            Write  = Write file from stem.
         pos       = position in the stem for the action
            pos =  0, add data to the end of the stem
            pos <> 0, insert data at stem.pos
            pos =  stem.0, insert data before the last item in the stem
            position has no meaning for actions read or write
         data/file = data to be inserted or a file name for read or write
   stem must be a valid single level stem with stem.0 containing the number
      of entries in the stem.
   stem.0 will be updated to reflect any action taken on stem.
   returns 1, if successful, or 0, if failure
*/
Stem_utility:
save_trace = Trace('N')
Parse Arg stem_utility_stem, stem_utility_action, stem_utility_pos, stem_utility_data
stem_utility_stem = Strip(stem_utility_stem, , '.')      /* stem name */

/* test parameters */
/* action parameter */
stem_utility_action = Left(Translate(stem_utility_action), 1)
/* stem length */
Interpret 'stem_utility_entries =' stem_utility_stem || '.0'
/* set up position parameter for stem reads or writes */
Select
   When stem_utility_action = 'W' Then          /* write stem to file */
      Do
         stem_utility_pos = 1
      End
   When stem_utility_action = 'R' Then         /* read file into stem */
      Do
         stem_utility_pos = 0
         Interpret stem_utility_stem || '.0 =' stem_utility_pos
      End
   Otherwise Nop
End
/* check action codes, stem positions, and data/file */
Select
   When stem_utility_action = 'I' Then
      stem_utility_return = ((Datatype(stem_utility_pos, 'W')) & ,
      (Datatype(stem_utility_entries, 'W')) & ,
      (0 <= stem_utility_pos) & ,
      (stem_utility_pos <= stem_utility_entries))
   When stem_utility_action = 'D' Then
      stem_utility_return = ((Datatype(stem_utility_pos, 'W')) & ,
      (Datatype(stem_utility_entries, 'W')) & ,
      (1 <= stem_utility_pos) & ,
      (stem_utility_pos <= stem_utility_entries))
   When stem_utility_action = 'R' Then
      Do
         If stem_utility_stem <> '' Then
            stem_utility_return = (Stream(stem_utility_data, 'c', 'query exists') <> '')
         Else
            stem_utility_return = 0
      End
   When stem_utility_action = 'W' Then
      Do
         If stem_utility_stem <> '' Then
            stem_utility_return = ((Datatype(stem_utility_entries, 'W')) & ,
            (1 <= stem_utility_entries))
         Else
            stem_utility_return = 0
      End
   Otherwise stem_utility_return = 0
End

If stem_utility_return Then
   Do
      /* queue the stem for the subroutine */
      stem_utility_new_queue = Rxqueue('create')
      stem_utility_current_queue = Rxqueue('set', stem_utility_new_queue)
      stem_utility_do_queue = 'Do i = 1 To' stem_utility_stem || '.0 ;' ,
         'Queue' stem_utility_stem || '.i ;' ,
         'End'
      Interpret stem_utility_do_queue

      /* invoke the stem utility subroutine */
      stem_utility_new_queue = Stem_utility_subroutine(stem_utility_new_queue, stem_utility_action, stem_utility_pos, stem_utility_data)

      /* pass the updated stem back to the caller */
      Call Rxqueue 'set', stem_utility_new_queue
      If stem_utility_action <> 'W' Then /* nothing passed on a write */
         Do
            stem_utility_x = 0
            Interpret stem_utility_stem || '.0 =' Queued()
            Do Queued()
               stem_utility_x = stem_utility_x + 1
               Interpret 'Parse Pull' stem_utility_stem || '.' || stem_utility_x
            End
         End
      Call Rxqueue 'set', stem_utility_current_queue
      Call Rxqueue 'delete', stem_utility_new_queue
   End
Else
   Do
      Call _sayout 'Invalid call to Stem_utility:'
      Call _sayout '(' || stem_utility_stem || ',' stem_utility_action || ',' stem_utility_pos || ',' stem_utility_data || ')'
   End
Trace (save_trace)
Return stem_utility_return

/* manipulate stems subroutine */
Stem_utility_subroutine: Procedure Expose verbose log_out log_file
save_trace = Trace()
Parse Arg newqueue, action, pos, data
oldqueue = Rxqueue('set', newqueue)
insert = Abbrev(action, 'I')
delete = Abbrev(action, 'D')
read = Abbrev(action, 'R')
write = Abbrev(action, 'W')
pos = Space(pos)
stem. = ''
stem.0 = Queued()
j = 0
Do Queued()
   j = j + 1
   Parse Pull stem.j
End
If Datatype(pos, 'W') Then
   Do
      Select
         When insert Then                            /* insert a line */
            Do
               Select
                  When pos = stem.0 Then   /* insert before last line */
                     Do
                        stem_end = stem.0 + 1
                        stem.stem_end = stem.pos
                        stem.pos = data
                     End
                  When pos = 0 Then            /* insert as last line */
                     Do
                        stem_end = stem.0 + 1
                        stem.stem_end = data
                     End
                  When pos < stem.0 Then        /* insert at line pos */
                     Do
                        stem_end = stem.0 + 1
                        here = pos
                        Do pos = stem_end To here By - 1
                           prev = pos - 1
                           stem.pos = stem.prev
                        End
                        stem.here = data
                     End
                  Otherwise Nop
               End
            End
         When delete Then                            /* delete a line */
            Do
               stem_end = stem.0 - 1
               Do here = pos To stem_end
                  next = here + 1
                  stem.here = stem.next
               End
            End
         When read Then                    /* read a file into a stem */
            Do
               pos = 0
               stem. = ''
               Call _sayout 'Reading' data
               Call Stream data, 'c', 'open read'
               Do While Lines(data) > 0
                  line = Linein(data)
                  pos = pos + 1
                  stem.pos = line
                  stem_end = pos
               End
               Call Stream data, 'c', 'close'
            End
         When write Then                  /* write a file from a stem */
            Do
               If Stream(data, 'c', 'query exists') <> '' Then
                  Do
                     Call _sayout 'Deleting old' data
                     Call SysFileDelete(data)
                  End
               Call _sayout 'Writing new' data
               Call Stream data, 'c', 'open write'
               stem_end = stem.0
               Do here = pos To stem_end
                  Call Lineout data, stem.here
               End
               Call Stream data, 'c', 'close'
            End
         Otherwise Nop
      End
      stem.0 = stem_end
   End
If \write Then
   Do                              /* nothing to pass back on a write */
      doqueue = "Do i = 1 To stem.0 ;" ,
         "Queue stem.i ;" ,
         "End"
      Interpret doqueue
   End
Call Rxqueue 'set', oldqueue
Trace (save_trace)
Return newqueue

/* console and log file output procedure */
_sayout: Procedure Expose verbose log_out log_file
save_trace = Trace('N')
Parse Arg msg, level
If \Datatype(level, 'W') Then
   level = 0
msg = Copies(' ', level) || msg
If verbose Then
   Call Lineout , msg
If log_out Then
   Call Lineout log_file, Date() Time() msg
Trace (save_trace)
Return
