/* RexxAutoStart by (c) 1998 - 2000 by Herwig Bauernfeind
   with additions for Object Desktop, object id checking, and
   installation by (c) 1999, 2000 by Chuck McKinnis */

/* This program is free software; you can redistribute it and/or modify it
   under the terms of the  GNU General Public License  as published by the
   Free Software Foundation; either version 2 of the License,  or (at your
   option) any later version.

   This  program  is  distributed  in the hope that it will be useful, but
   WITHOUT ANY WARRANTY;  without even the implied  warranty of FITNESS or
   MERCHANTABILITY  FOR  A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   675 Mass Ave, Cambridge, MA 02139, USA. */

/* mainline logic */
Trace 'N'
Parse Arg orgparms                      /* get commandline parameters */
cmdparms = orgparms                       /* to enable check for help */
If _initialize() Then          /* initialize parameters and variables */
   Do
      xrc = 0
      Select
         When do_help Then                               /* give help */
            Do
               xrc = _helpscreen()
               xrc = _cleanup(xrc)
            End
         When autoexec Then                        /* execute program */
            Do
               Call _sayout prgfile 'started.', 0
               Call _sayout "Using parameters" parms || ".", 2
               If wps_wait Then        /* wait for Desktop population */
                  xrc = _wpswait()
               If delay_wait <> 0 Then    /* delay further processing */
                  xrc = _delayswitch()
               If od_wait Then             /* wait for Object Desktop */
                  xrc = _odwait()
               xrc = _autoexec()        /* open startupfolder objects */
               xrc = _cleanup(xrc)
            End
         Otherwise xrc = _cleanup(100)
      End
   End
Else
   xrc = _cleanup(1)
Exit xrc                                                      /* exit */

/* mainline logic routines */

_initialize:
/* Initialize libraries */

/* do parsing */
Parse Source . . prgfile .
Parse Version rxname rxver rxdate
our_dir = Strip(Filespec('d', prgfile) || Filespec('p', prgfile), , '\')
save_dir = Directory(our_dir)

/* initialize */
Call Rxfuncadd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
Call SysLoadFuncs

Call Rxfuncadd 'WPToolsLoadFuncs', 'WPTOOLS', 'WPToolsLoadFuncs'
Call WPToolsLoadFuncs
wptver = WPToolsVersion()

Address cmd '@echo off'
ver = '1.61'
verdate = '25 May 2000'
os2version = SysOS2Ver()
warp4 = (os2version >= 2.40)
wseb = (os2version >= 2.45)
If wseb Then
   Do
      wseb_check = SysSearchPath('PATH', 'SYSLEVEL.OS2')
      wseb_check = Linein(wseb_check)
      wseb = (Pos('5639A6150', wseb_check) <> 0)
   End

/* locate the executable */
exe_file = Stream('rxautost.exe', 'c', 'query exists')
If exe_file = '' Then
   exe_file = Stream('rxautost.cmd', 'c', 'query exists')
If exe_file = '' Then
   Do
      Say 'Unable to locate rxautost.exe or rxautost.cmd'
      Return 0
   End

/* locate the base directory for RxAutoSt */
base_dir = Filespec('d', exe_file) || Filespec('p', exe_file)

/* define the log file */
log_file = Filespec('d', base_dir) || Filespec('p', base_dir) || 'RxAutoSt.LOG'

/* locate the icon file */
icon_file = Stream('rxautost.ico', 'c', 'query exists')
If icon_file = '' Then
   Do
      Say 'Unable to locate rxautost.ico'
      Return 0
   End

/* let commandline parameters override config.sys parameters */
orgparms = Strip(orgparms Value('rxautost', , 'os2environment'))

/* we need this for /F switch to preserve case of ObjectIDs */
parms = Translate(orgparms)
/* get some initial parameters */
verbose = (Pos('/V',parms) <> 0)                    /* verbose output */
log_out = (Pos('/L',parms) <> 0)                           /* logging */
testing = (Pos('/T',parms) <> 0)       /* undocumented test parameter */
If testing Then
   Do
      verbose = 1
      log_out = 1
   End
wps_wait = (Pos('/WPS',parms) <> 0)        /* wait for WPS population */

/* some parameter defaults */
delay_wait_default = 0
od_tries_default = 30
sleepsec_default = 2
startupfolder_default = '<WP_START>'
retries_default = 2

Parse Value('.' parms) With . '/D:' delay_wait '/'.   /* delay switch */
delay_wait = Strip(delay_wait)
If delay_wait = '' | \Datatype(delay_wait, 'W') Then
   delay_wait = delay_wait_default

/* Object Desktop information */
odtest = SysIni('USER','WPTS','TSMasterSetup:StartupFlags')
objdesk = (odtest <> 'ERROR:')            /* object desktop installed */
If objdesk Then             /* determine which facilities to wait for */
   Do
      od_wait = (Pos('/OD',parms) <> 0)    /* wait for Object Desktop */
      odtest = Left(odtest, Length(odtest) - 1)
      od_cc = (odtest >= C2x('28'x))
      od_tlp = (odtest >= C2x('28'x))
      od_tlp = (odtest >= C2x('24'x))
      od_cc = (odtest >= C2x('20'x))
      /* determine number of checks for Object Desktop tasks */
      Parse Value('.' parms) With . '/OD:' od_tries '/'.
      od_tries = Strip(od_tries)
      If od_tries = '' | \Datatype(od_tries, 'W') Then
         od_tries = od_tries_default
   End
Else
   od_wait = 0

/* /P switch (pause between object) */
Parse Value('.' parms) With . '/P:' sleepsec '/' .
sleepsec = Strip(sleepsec)
If sleepsec = '' Then
   sleepsec = sleepsec_default

/* open log file */
Call Stream log_file, 'c', 'open write'

/* /F switch (make any folder your startup folder) */
f_pos = Pos('/F:', parms)
If f_pos <> 0 Then
   Do
      Parse Value('.' orgparms) With . + (f_pos) + 4 startupfolder '/' .
      startupfolder = Strip(Strip(Strip(startupfolder), , '"'), , "'")
   End
Else
   startupfolder = startupfolder_default

/* /R switch (open object retries) */
Parse Value('.' parms) With . '/R:' retries '/' .
retries = Strip(retries)
If retries = '' Then
   retries = retries_default

Call _seticon prgfile, icon_file              /* add icon to our file */

/* Do we need help? */
If Pos('/?', cmdparms) <> 0 | cmdparms = '' Then
   do_help = 1
Else
   do_help = 0

/* set miscellaneous options */

/* are we going to execute RxAutoSt? */
autoexec = (Pos('/X', parms) <> 0)

Return 1

/* /WPS switch logic */
_wpswait:
Call _sayout 'Waiting until the Desktop has been populated.', 1
If warp4 Then
   Do                                               /* Warp 4 or WSeB */
      If (SysWaitForShell("DESKTOPPOPULATED", "QUERY") = 0) Then
         Do
            Call SysWaitForShell "DESKTOPPOPULATED"
         End
   End
Else
   Do              /* Warp 3, taken from RXTT28.INF by Bernd Schemmer */
      xrc = SysIni('USER', 'PM_InstallObject', 'ALL:', 'stem')
      Do While xrc \= 'ERROR:'
         Call SysSleep sleepsec
         xrc = SysIni('USER', 'PM_InstallObject', 'ALL:', 'stem')
      End
   End
Call _sayout 'Desktop has been populated. Continuing...', 2
Call _seticon prgfile, icon_file              /* add icon to our file */
Return 0

/* /D (delay) switch logic */
_delayswitch:
Call _sayout 'Delay further execution by' delay_wait 'seconds.', 1
Call SysSleep delay_wait
Call _sayout delay_wait' seconds have passed. Continuing...', 2
Return 0

/* /OD switch logic */
_odwait:
Call _sayout 'Waiting for Object Desktop to start.', 1
If od_cc Then
   Do
      Call _sayout 'Waiting for [Control Center]', 2
      Parse Value(_waitod('Control Center', sleepsec, od_tries)) With success tries .
      If success Then
         open_msg = '['control center'] has opened after' tries 'check(s).'
      Else
         open_msg = '['control center'] has not opened after' tries 'check(s).'
      Call _sayout open_msg, 3
   End
If od_tlp Then
   Do
      Call _sayout 'Waiting for [Tab LaunchPad]', 2
      Parse Value(_waitod('Tab LaunchPad', sleepsec, od_tries)) With success tries .
      If success Then
         open_msg = '['tab launchpad'] has opened after' tries 'check(s).'
      Else
         open_msg = '['tab launchpad'] has not opened after' tries 'check(s).'
      Call _sayout open_msg, 3
   End
If success Then
   open_msg = 'Object Desktop is started. Continuing...'
Else
   open_msg = 'Object Desktop has not started. Continuing...'
Call _sayout open_msg, 2
Call _seticon prgfile, icon_file              /* add icon to our file */
Return 0

/* open objects in startup folder */
_autoexec:

/* launch startup folder objects */
save_trace = Trace('N')

/* query our startup folder */
If WPToolsFolderContent(startupfolder, 'list.', 'F') Then
   Do
      Call _sayout "Adding objects from startup folder" startupfolder".", 1
      Call _sayout sleepsec "seconds of delay between objects will be inserted.", 2

      /* open objects in startup folder */
      open_parm = 'OPEN=DEFAULT;CCVIEW=NO;'
      list_start = 1
      list_end = list.0
      list_incr = 1
      If wseb Then
         Do
            list_start = list.0
            list_end = 1
            list_incr = -1
         End
      Do i = list_start To list_end By list_incr
         If WPToolsQueryObject(list.i, 'szclass', 'sztitle') Then
            Do
               title = _objtitle(sztitle)
               Call _sayout "Adding object '"title"' of class "szclass'.', 2
               /* try to open object, tell us what happened */
               success = 0
               Do x = 1 To retries Until success
                  Call SysSleep sleepsec
                  success = WPToolsSetObjectData(list.i, open_parm)
               End
               If success Then
                  open_msg = '['title'] has opened after' x 'attempt(s) of' retries || '.'
               Else
                  open_msg = '['title'] failed to open after' retries 'attempts.'
               Call _sayout open_msg, 3
            End
         Else
            Call _sayout 'Could not locate for object' title || '.', 2
      End
      Call _sayout 'Objects in' startupfolder 'have been opened.', 1
   End
Else
   Do
      Call _sayout 'Failure:' startupfolder 'could not be queried. Continuing...', 1
   End
Trace (save_trace)
Return 0

/* subroutines */

_cleanup: Procedure Expose prgfile save_dir verbose log_out log_file
Parse Arg xrc
Call _sayout prgfile 'ended.', 0
If log_out Then
   Call Lineout log_file, ''
Call Stream log_file, 'c', 'close'
Call Directory(save_dir)
Return xrc

/* translate out carriage control characters */
_objtitle: Procedure Expose autostrt verbose log_out log_file
Parse Arg title
nlcrlf = D2c(94) || D2c(13) || D2c(10)
title = Space(Translate(title, , nlcrlf))
Return title

/* subroutine for commandline help */
_helpscreen: Procedure Expose ver verdate rxname rxver rxdate wptver ,
   od_tries_default sleepsec_default delay_wait_default ,
   retries_default startupfolder_default verbose log_out log_file
verbose = 1
log_out = 0
Call _sayout 'RexxAutoStart Version 'ver' ('verdate') (c) 1998-2000 by Herwig Bauernfeind'
Call _sayout 'This is FREE software under the terms of the GNU General Public License.'
Call _sayout
Call _sayout 'Using 'rxname' Version 'rxver' ('rxdate')'
Call _sayout 'Using WPTools Version 'wptver' (c) copyright by Henk Kelder'
Call _sayout
Call _sayout '/X         - eXecute RexxAutoStart.'
Call _sayout '/WPS       - Wait until desktop is populated.'
Call _sayout '/OD[:n]    - Wait until Object Desktop is opened or a maximum'
Call _sayout '             of n times (' || od_tries_default || ') delayed by /P:n secs (' || sleepsec_default || ').'
Call _sayout '/D:n       - Wait n secs before processing objects in the startup folder (' || delay_wait_default || ').'
Call _sayout '/P:n       - Pause between startup folder objects for n secs (' || sleepsec_default || ').'
Call _sayout '/R:n       - Attempt to open a startup folder object n times (' || retries_default || ').'
Call _sayout '/F:"<id>"  - Folder which should be treated as startup folder instead'
Call _sayout '             of the default of' startupfolder_default || '.'
Call _sayout '/V         - Verbose. Give us some hints what we are doing right now.'
Call _sayout '/L         - Log results to' log_file || '.'
verbose = 0
Return 98

/* icon attachment */
_seticon: Procedure Expose verbose log_out log_file testing
save_trace = Trace('N')
Parse Arg file, icon_file
/* let us set the icon */
If testing Then
   Call _sayout "Attaching icon to" file || ".", 1
icon_parm = 'ICONFILE=' || icon_file || ';'
If SysSetObjectData(file, icon_parm) Then
   Do
      If testing Then
         Call _sayout 'Icon attached.', 2
   End
Trace(save_trace)
Return 0

/* wait for Object Desktop to start */
_waitod: Procedure Expose verbose log_out log_file
save_trace = Trace('N')
Parse Arg title, sleep, od_tries
rc_task = 0
attempts = 0
If \Rxfuncquery('SysQuerySwitchList') Then
   Do i = 1 To od_tries Until rc_task
      attempts = attempts + 1
      Call SysSleep sleep
      Call SysQuerySwitchList 'tasks.', 'IGN'
      Do j = 1 To tasks.0 Until rc_task
         rc_task = (Pos(title, tasks.j) <> 0)
      End
   End
Else
   Call _sayout 'SysQuerySwitchList not available, returning...', 2
Trace (save_trace)
Return rc_task attempts

/* console and log file output procedure */
_sayout: Procedure Expose verbose log_out log_file
save_trace = Trace('N')
Parse Arg msg, level
If \Datatype(level, 'W') Then
   level = 0
msg = Copies(' ', level) || msg
If verbose Then
   Call Lineout , msg
If log_out Then
   Call Lineout log_file, Date() Time() msg
Trace (save_trace)
Return
