#makefile for REXXSM2

# Ss  - allow //
# Sm  - use migration libs
# Ti+ - Debug stuff
# W1  - severe warning level
# Gm+ - Multi-thread
# C   - Compile only
# K   - errors
# Q+  - turn off logo
# Rn  - develop subsystem (no RTL)
# Ge- - make a dll
# Ge+ - make an exe

#------------------------------------------------------------------------------
# C parameters
#------------------------------------------------------------------------------
CC         = icc
OPTS       =  /c /Q+ /Kbperc /Ss /W1
MIG        =  /Sm
SUB        =  /Rn
LOPTS      =  /A:16 /NOI /nologo /BASE:0x10000
DLL        =  /Ge-
EXE        =  /Ge+
MT         =  /Gm+

OPTS       = $(OPTS) $(MT)

!IFDEF   opt
OPTS       = $(OPTS) /O+ /Ti-
LOPTS      = $(LOPTS) /PACKCODE /PACKDATA
!ELSE
OPTS       = $(OPTS) /O- /Ti+
LOPTS      = $(LOPTS) /DE
!ENDIF

all: rexxsm2.dll

sm2index.obj: sm2index.c sm2index.h
    $(CC) $(DLL) $(MIG) $(OPTS) sm2index.c

rexxsm2.obj: rexxsm2.c rexxsm2.h sm2index.h
    $(CC) $(DLL) $(MIG) $(OPTS) rexxsm2.c

rexxsm2.dll: rexxsm2.obj sm2index.obj rexxsm2.def 
   link386 $(LOPTS) rexxsm2+sm2index,rexxsm2.dll,,REXX ehsapi, rexxsm2.def
