#define  INCL_REXXSAA
#define  _DLL
#define  _MT
#include <os2.h>
#include <rexxsaa.h>
#include <stdio.h>
#include <string.h>
#include "sm2index.h"
#include "rexxsm2.h"

/*************************************************************************
* Function:  RxSM2ListServers                        
*                                                    
* Syntax:    rc= RxSM2ListServers('ServerStemName')
*                                                    
* Params:    a stem
*                                                    
* Return:    0 
*            - this NEEDS error checking
*************************************************************************/
ULONG RxSM2ListServers(CHAR *name, ULONG numargs, RXSTRING args[],
                       CHAR *queuename, RXSTRING *retstr)
{

  char szServerName[250];
  char buffer[32];
  ULONG rc;
  char **ppszServers;
  int iNumServers=0,j;
   SHVBLOCK shvb;
   SHORT    retc;
   CHAR     szTempStemName[50];
   CHAR     szStemName[50]     ;


  if (numargs > 1)
    return INVALID_ROUTINE;            /* raise an error             */

   strcpy(szStemName,args[0].strptr);
   /* make sure the stem has a . at the end */
   if ((CHAR)  szStemName[(strlen(szStemName) - 1) ] != '.')
      strcat (szStemName, ".");
   /* allocate memory for the pointer to the pointers to the servers */    
   ppszServers=malloc(sizeof(char *));
   /* get the list of servers  */    
   rc = SM2ListServers(&ppszServers,&iNumServers);
   _itoa(rc,buffer,10);
   /* put the servers in the stem */
   for (j=0;j<iNumServers;j++)
   {
     /* remember, at this point pszStemName contains STEMNAME.  */
     /* so append the next number in sequence to create         */
     /* STEMNAME.1, STEMNAME.2,STEMNAME.3 etc                   */
   
      strcpy( szTempStemName,szStemName);
      sprintf(szTempStemName, "%s%d", szStemName,(j+1));
      shvb.shvnext = NULL;
      /* shvname is a RXSTRING - we can set the fields manually or use
         the BUILDRXSTRING macro      */
      /* here we are setting the fields manually */
      shvb.shvname.strptr = szTempStemName;
      shvb.shvname.strlength = (ULONG) strlen (szTempStemName);
      shvb.shvnamelen = shvb.shvname.strlength;
      shvb.shvvalue.strptr = *ppszServers;
      shvb.shvvalue.strlength = strlen(*ppszServers);
      shvb.shvvaluelen = shvb.shvvalue.strlength;
      shvb.shvcode = RXSHV_SYSET;
      shvb.shvret = RXSHV_OK;
   
      rc = RexxVariablePool(&shvb); 
      // should be doing some error checking here!
      if (rc == RXSHV_BADN);
      free(*ppszServers);
      ppszServers++;
   }    
   free(ppszServers);
   /* now give the count of the stem */
   strcpy( szTempStemName,szStemName);
   _itoa(iNumServers,buffer,10);
   sprintf(szTempStemName, "%s%d",szStemName, 0);
   shvb.shvnext = NULL;
   shvb.shvname.strptr = szTempStemName;
   shvb.shvname.strlength = (ULONG) strlen (szTempStemName);
   shvb.shvnamelen = shvb.shvname.strlength;
   shvb.shvvalue.strptr = buffer;
   shvb.shvvalue.strlength = strlen(buffer);
   shvb.shvvaluelen = shvb.shvvalue.strlength;    
   shvb.shvcode = RXSHV_SYSET;
   shvb.shvret = RXSHV_OK;

   // should be doing some error checking here!
   if (RexxVariablePool(&shvb) == RXSHV_BADN);

  /* check the return code          
  switch (rc)
  {
     case  NO_ERROR :
        BUILDRXSTRING(retstr, szServerName);
     break;

     default:
        BUILDRXSTRING(retstr, buffer);
     break;
  }                                 */

  BUILDRXSTRING(retstr, "0");
  return VALID_ROUTINE;
}

/*************************************************************************
* Function:  RxSM2StartSession
*                                                                        *
* Syntax:    call RxSM2StartSession ServerName                            *
*                                                                        *
* Params:    ServerName  - name of server (input)
*                                                                        *
* Return:    NO_ERROR - everything okay
*            or
*            error code returned from EhwStartSession
*************************************************************************/
ULONG RxSM2StartSession(CHAR *name, ULONG numargs, RXSTRING args[],
                       CHAR *queuename, RXSTRING *retstr)
{

  PSZ  pszServerName;
  char buffer[32];
  BOOL bFail=TRUE;
  ULONG rc;

  if (numargs != 1  || !RXVALIDSTRING(args[0]) )
    return INVALID_ROUTINE;            /* raise an error             */


  pszServerName = args[0].strptr;             /* get server name            */

   rc =  SM2StartSession(pszServerName);      /* start the sm2 session */
   _itoa(rc,buffer,10);
   BUILDRXSTRING(retstr, buffer);

  return VALID_ROUTINE;
}
/*************************************************************************
* Function:  RxSM2OpenIndex
*                                                         
* Syntax:    call RxSM2OpenIndex ServerName               
*                                                         
* Params:    ServerName  - name of server (input)
*                                                         
* Return:    NO_ERROR - everything okay
*            or
*            error code returned from EhwOpenIndex
*************************************************************************/
ULONG RxSM2OpenIndex(CHAR *name, ULONG numargs, RXSTRING args[],
                       CHAR *queuename, RXSTRING *retstr)
{

  PSZ  pszServerName;
  char buffer[32];
  BOOL bFail=TRUE;
  ULONG rc;

  if (numargs != 1  || !RXVALIDSTRING(args[0]) )
    return INVALID_ROUTINE;            /* raise an error             */


  pszServerName = args[0].strptr;             /* get server name            */

   rc =  SM2OpenIndex(pszServerName);      /* open the index */
   _itoa(rc,buffer,10);
   BUILDRXSTRING(retstr, buffer);

  return VALID_ROUTINE;
}

/*************************************************************************
* Function:  RxSm2ScheduleDocument
*                                                         
* Syntax:    call RxSM2ScheduleDocument filename
*                                                         
* Params:    filename to be scheduled for indexing (input)
*                                                         
* Return:    NO_ERROR - everything okay
*            or
*            error code returned from EhwScheculeDocument
*************************************************************************/
ULONG RxSM2ScheduleDocument(CHAR *name, ULONG numargs, RXSTRING args[],
                       CHAR *queuename, RXSTRING *retstr)
{

  PSZ  pszFilename;
  char buffer[32];
  BOOL bFail=TRUE;
  ULONG rc;

  if (numargs != 1  ) /*|| !RXVALIDSTRING(args[0]) )*/
    return INVALID_ROUTINE;            /* raise an error             */


  pszFilename = args[0].strptr;             /* get file name            */

   rc =  SM2ScheduleDocument(pszFilename);
   _itoa(rc,buffer,10);
   BUILDRXSTRING(retstr, buffer);

  return VALID_ROUTINE;
}

/*************************************************************************
* Function:  RxSm2UpdateIndex
*                                                         
* Syntax:    call RxSM2UpdateIndex
*                                                         
* Params:    NONE
*                                                         
* Return:    NO_ERROR - everything okay
*            or
*            error code returned from EhwUpdateIndex
*************************************************************************/
ULONG RxSM2UpdateIndex(CHAR *name, ULONG numargs, RXSTRING args[],
                       CHAR *queuename, RXSTRING *retstr)
{

  char buffer[32];
  BOOL bFail=TRUE;
  ULONG rc;

  if (numargs >0 )
    return INVALID_ROUTINE;            /* raise an error             */

   rc =  SM2UpdateIndex();
   _itoa(rc,buffer,10);
   BUILDRXSTRING(retstr, buffer);

  return VALID_ROUTINE;
}

/*************************************************************************
* Function:  RxSm2CloseIndex
*                                                         
* Syntax:    call RxSM2CloseIndex
*                                                         
* Params:    NONE
*                                                         
* Return:    NO_ERROR - everything okay
*            or
*            error code returned from EhwCloseIndex
*************************************************************************/
ULONG RxSM2CloseIndex(CHAR *name, ULONG numargs, RXSTRING args[],
                       CHAR *queuename, RXSTRING *retstr)
{

  char buffer[32];
  BOOL bFail=TRUE;
  ULONG rc;

  if (numargs >0 )
    return INVALID_ROUTINE;            /* raise an error             */

   rc =  SM2CloseIndex();
   _itoa(rc,buffer,10);
   BUILDRXSTRING(retstr, buffer);

  return VALID_ROUTINE;
}

/*************************************************************************
* Function:  RxSm2EndSession
*                                                         
* Syntax:    call RxSM2EndSession
*                                                         
* Params:    NONE
*                                                         
* Return:    NO_ERROR - everything okay
*            or
*            error code returned from EhwEndSession
*************************************************************************/
ULONG RxSM2EndSession(CHAR *name, ULONG numargs, RXSTRING args[],
                       CHAR *queuename, RXSTRING *retstr)
{

  char buffer[32];
  BOOL bFail=TRUE;
  ULONG rc;

  if (numargs >0 )
    return INVALID_ROUTINE;            /* raise an error             */

   rc =  SM2EndSession();
   _itoa(rc,buffer,10);
   BUILDRXSTRING(retstr, buffer);

  return VALID_ROUTINE;
}


/*************************************************************************
* Function:  LoadRxSM2Funcs                                        *
*                                                                        *
* Syntax:    call LoadRxSM2Funcs
*                                                                        *
* Return:    NO_UTIL_ERROR - Successful.                                 *
*************************************************************************/
ULONG LoadRxSM2Funcs(CHAR *name, ULONG numargs, RXSTRING args[],
                           CHAR *queuename, RXSTRING *retstr)
{
   INT    entries;                      /* Num of entries             */
   INT    j;                            /* Counter                    */

   retstr->strlength = 0;               /* set return value           */
                                       /* check arguments            */
   if (numargs > 0)
      return INVALID_ROUTINE;

   entries = sizeof(RxFncTable)/sizeof(PSZ);

   /* register the functions that are named the same */
   /* as their entry point */
   for (j = 0; j < entries; j++)
   {
      RexxRegisterFunctionDll(RxFncTable[j],
                              "REXXSM2",
                               RxFncTable[j]);
   }
   return VALID_ROUTINE;
}


/*************************************************************************
* Function:  UnLoadRxSM2Funcs                                        *
*                                                                        *
* Syntax:    call UnLoadRxSMFuncs
*                                                                        *
* Return:    NO_UTIL_ERROR - Successful.                                 *
*************************************************************************/

ULONG UnLoadRxSM2Funcs(CHAR *name, ULONG numargs, RXSTRING args[],
                          CHAR *queuename, RXSTRING *retstr)
{
   INT     entries;                     /* Num of entries             */
   INT     j;                           /* Counter                    */

   if (numargs != 0)                    /* no arguments for this      */
      return INVALID_ROUTINE;            /* raise an error             */

   retstr->strlength = 0;               /* return a null string result*/

   entries = sizeof(RxFncTable)/sizeof(PSZ);

   for (j = 0; j < entries; j++)
      RexxDeregisterFunction(RxFncTable[j]);


   return VALID_ROUTINE;                /* no error on call           */
}

