#include <stdio.h>                     /* => printf ()                */
#include <stdlib.h>                    /* standard library functions  */
#include <string.h>                   /* String Functions Include File*/
#define INCL_DOS
#include <os2.h>                      /* System Include File          */
#include "ehwapic.h"                  /* SM/2 API definitions for C   */
#include "sm2index.h"      


/* global variables */
   PVOID     pSession        = NULL;      /* API session pointer         */
   ULONG     ulIndexHandle   = 0L;        /* API index handle            */
   USHORT    usNameLength    = 0;         /* length field for DS values  */



/* ****************************************************************** */
/* List Servers                                                       */
/* a pointer to a pointer to a string is passed along with a           */
/* an integer. The pointers to the servername are placed in           */
/* the pointer to the pointer to servernames and the number of        */
/* servers is placed in the integer.  The return code from the        */
/* EhsListServers function is placed in the return                    */
/* ****************************************************************** */

int SM2ListServers(char ***ppszServers,int *iNumServers)
{
   ULONG     ulReturnCode    = RC_DONE;   /* API return code             */
   ULONG     ulDiagnosisInfo = 0L;        /* API diagnosis information   */
   ULONG     ulResultHandle  = 0L;        /* API result handle           */
   ULONG     ulResultSize    = 0L;        /* API result size             */
   ULONG     ulDataLength    = 0L;        /* API datastream length       */
   PCHAR     pDataStream     = NULL;      /* API datastream pointer      */

   USHORT    usValue         = 0;         /* USHORT datastream value     */
   INT       iCount          = 0;         /* loop variable               */
   INT       iStatus         = RC_TRUE;   /* WriteDataItem() status code */

   PCHAR     pArea           = NULL;      /* pointer to work area        */
   PCHAR     pDataEnd        = NULL;      /* pointer after work area     */
   PCHAR     pszServername   = NULL;      /* pointer after work area     */
   char **baseline=*ppszServers;
 


    /* Work area    */
    pArea = malloc(SIZEOF_DATA_AREA);
    /* Provide output buffer     */
    pDataStream = pArea;

    /* ********************************************** */
    /* Get SM/2 Server identifier                     */
    /* ********************************************** */
   ulReturnCode = EhwListServers (&ulDataLength,
                                  &pDataStream,
                                  &ulDiagnosisInfo);
   if (ulReturnCode != RC_DONE)
   {
      free(pArea);
      return ulReturnCode;
   }
   /* set the ptr to end of data  */
   pDataEnd = pDataStream + ulDataLength;
   /* check if eod is not reached */
//   memset(ServerName,0x0,sizeof(ServerName));

   while (pDataStream < pDataEnd)
   {
      /* check the item identifier   */
      switch (((PITEM )pDataStream)->id)
      {
        /* server name item:         */
        case ID(ID_IRSN):
           /* convert big-endian        */
           usNameLength =
                       VAL2(&(((PITEM )pDataStream)->ll))
                     - Offsetof(ITEM, value[0]);
           pszServername=malloc((usNameLength+1)*sizeof(CHAR));
           memset(pszServername,0x0,sizeof(pszServername));
           memcpy(pszServername,
                  ((PITEM )pDataStream)->value,
                  (size_t )usNameLength);
           *ppszServers=realloc(*ppszServers,((*iNumServers)+1)*sizeof(char *));
           baseline=*ppszServers+(*iNumServers);
           *baseline = pszServername;
           (*iNumServers)++;
        break;

        /* skip all unknown data items */
        default:
        break;
      }
      /* skip current data item      */
      pDataStream += VAL2(&(((PITEM )pDataStream)->ll));
   }                  /* endwhile not end of data    */
   free(pArea);
   return(RC_DONE);
}
int SM2StartSession(char *ServerName)
{
   ULONG     ulReturnCode    = RC_DONE;   /* API return code             */
   ULONG     ulDiagnosisInfo = 0L;        /* API diagnosis information   */
   ULONG     ulResultHandle  = 0L;        /* API result handle           */
   ULONG     ulResultSize    = 0L;        /* API result size             */
   ULONG     ulDataLength    = 0L;        /* API datastream length       */
   PCHAR     pDataStream     = NULL;      /* API datastream pointer      */

   USHORT    usValue         = 0;         /* USHORT datastream value     */
   INT       iCount          = 0;         /* loop variable               */
   INT       iStatus         = RC_TRUE;   /* WriteDataItem() status code */

   PCHAR     pArea           = NULL;      /* pointer to work area        */
   PCHAR     pDataEnd        = NULL;      /* pointer after work area     */


   /* Work area    */
   pArea = malloc(SIZEOF_DATA_AREA);

   /* ********************************************** */
   /* Now with Server known, start a SM/2 Session    */
   /* ********************************************** */

   /* Sizeof out-buff*/
   ulDataLength = SIZEOF_DATA_AREA;
   /* Init addr. of out-buffer */
   pDataStream  = pArea;
   iStatus = WriteDataItem (ID_IRSN, IT_ATOMIC,
                            usNameLength,
                            (PCHAR)ServerName,
                            &ulDataLength,
                            &pDataStream);
   ulDataLength = (ULONG )(pDataStream - pArea);
   pDataStream  = pArea;
   ulReturnCode = EhwStartSession (ulDataLength,
                                   pDataStream,
                                   &pSession,
                                   &ulDiagnosisInfo);
   free(pArea);
   return ulReturnCode;
}

   /* ********************************************** */
   /* Open SM/2 Index                                */
   /* ********************************************** */
int SM2OpenIndex(char *ServerName)
{
   ULONG     ulReturnCode    = RC_DONE;   /* API return code             */
   ULONG     ulDiagnosisInfo = 0L;        /* API diagnosis information   */
   ULONG     ulResultHandle  = 0L;        /* API result handle           */
   ULONG     ulResultSize    = 0L;        /* API result size             */
   ULONG     ulDataLength    = 0L;        /* API datastream length       */
   PCHAR     pDataStream     = NULL;      /* API datastream pointer      */

   USHORT    usValue         = 0;         /* USHORT datastream value     */
   INT       iCount          = 0;         /* loop variable               */
   INT       iStatus         = RC_TRUE;   /* WriteDataItem() status code */

   PCHAR     pArea           = NULL;      /* pointer to work area        */
   PCHAR     pDataEnd        = NULL;      /* pointer after work area     */


   /* Work area    */
   pArea = malloc(SIZEOF_DATA_AREA);

   /* ********************************************** */
   /* SM/2 Index will be activated next              */
   /* ********************************************** */
   ulDataLength = SIZEOF_DATA_AREA;
   pDataStream  = pArea;
   iStatus = WriteDataItem (ID_XNAM, IT_ATOMIC,
                            SM2_INDEXNAME_LEN,
                            SM2_INDEXNAME,
                            &ulDataLength,
                            &pDataStream);
   ulDataLength = (ULONG )(pDataStream - pArea);
   pDataStream  = pArea;
   ulReturnCode = EhwOpenIndex (pSession,
                                ulDataLength,
                                pDataStream,
                                &ulIndexHandle,
                                &ulDiagnosisInfo);
   free(pArea);
   return ulReturnCode;
}

   /* ********************************************** */
   /*   Schedule document for indexing              */
   /*    --> Call EhwScheduleDocument()             */
   /* ********************************************** */

int SM2ScheduleDocument(char * szFilename)
{
   ULONG     ulReturnCode    = RC_DONE;   /* API return code             */
   ULONG     ulDiagnosisInfo = 0L;        /* API diagnosis information   */
   ULONG     ulResultHandle  = 0L;        /* API result handle           */
   ULONG     ulResultSize    = 0L;        /* API result size             */
   ULONG     ulDataLength    = 0L;        /* API datastream length       */
   PCHAR     pDataStream     = NULL;      /* API datastream pointer      */

   USHORT    usValue         = 0;         /* USHORT datastream value     */
   USHORT    usFilenameLen   = 0;    
   INT       iCount          = 0;         /* loop variable               */
   INT       iStatus         = RC_TRUE;   /* WriteDataItem() status code */

   PCHAR     pArea           = NULL;      /* pointer to work area        */
   PCHAR     pDataEnd        = NULL;      /* pointer after work area     */

   CHAR      ServerName[32];              /* SM/2 Server Name            */

   /* Work area    */
   pArea = malloc(SIZEOF_DATA_AREA);
   if (strlen(szFilename))
   {
     ulDataLength = SIZEOF_DATA_AREA;/* Sizeof out-buff*/
     pDataStream  = pArea; /* Init addr. of out-buffer */
     usFilenameLen = strlen(szFilename);
     iStatus = WriteDataItem (ID_ADD, IT_ATOMIC, 
                              usFilenameLen,
                              (PCHAR)szFilename,
                              &ulDataLength,
                              &pDataStream);
     ulDataLength = (ULONG )(pDataStream - pArea);
     pDataStream  = pArea;
     ulReturnCode = EhwScheduleDocument(pSession,
                                        ulIndexHandle,
                                        ulDataLength,
                                        pDataStream,
                                        &ulDiagnosisInfo);
   }
  free(pArea);
  return ulReturnCode;
}
int SM2UpdateIndex(void)
{
   ULONG     ulReturnCode    = RC_DONE;   /* API return code             */
   ULONG     ulDiagnosisInfo = 0L;        /* API diagnosis information   */

   /* ********************************************** */
   /*   Start Update Index                          */
   /*    --> Call EhwUpdateIndex()                  */
   /* ********************************************** */
     ulReturnCode = EhwUpdateIndex(pSession,
                                   ulIndexHandle,
                                   &ulDiagnosisInfo);
     if (ulReturnCode != RC_DONE)
     {
        return ulReturnCode;
     }
  return(RC_DONE);
}
int SM2CloseIndex(void)
{
   ULONG     ulReturnCode    = RC_DONE;   /* API return code             */
   ULONG     ulDiagnosisInfo = 0L;        /* API diagnosis information   */
   /* ********************************************** */
   /* Close Index                                    */
   /* ********************************************** */
   if (ulIndexHandle) /* if required, then do it     */
   {
      ulReturnCode = EhwCloseIndex (pSession,
                        ulIndexHandle,
                        &ulDiagnosisInfo);
   }
return(ulReturnCode);
}
   /* ********************************************** */
   /* End SM/2 Session (if applicable)               */
   /* ********************************************** */
int SM2EndSession(void)
{
   ULONG     ulReturnCode    = RC_DONE;   /* API return code             */
   ULONG     ulDiagnosisInfo = 0L;        /* API diagnosis information   */
   if (pSession)      /* if required, then do it     */
   {
      ulReturnCode = EhwEndSession (pSession,
                        &ulDiagnosisInfo);
   }

    return ulReturnCode;
}

/*====================================================================*/
/* internal function WriteDataItem (write datastream item)            */
/*====================================================================*/
INT    WriteDataItem
       (
        USHORT    usItemId,            /* In  -- item identifier      */
        UCHAR     ItemType,            /* In  -- item type            */
        USHORT    usValueLength,       /* In  -- length of item value */
        PCHAR     pValue,              /* In  -- ptr to item value    */
        PULONG    pulAreaLength,       /* In/Out remaining area size  */
        PPCHAR    ppArea               /* In/Out ptr to target area   */
       )
{
   USHORT         usItemLL;            /* total length of data item   */
   PITEM          pItem;               /* pointer to data stream item */

   pItem    = (PITEM )*ppArea;         /* set pointer to target area  */
                                       /* calculate total item length */
   usItemLL = Offsetof(ITEM, value[0]) + usValueLength;
                                       /* check remaining area length */
   if ((ULONG )usItemLL > *pulAreaLength)  return (RC_FALSE);
                                       /* write item ll/id/it to area */
   pItem->ll = VAL2(&usItemLL);        /* invertion to big-endian     */
   pItem->id = VAL2(&usItemId);        /* format using macro VAL2()   */
   pItem->it = ItemType;
                                       /* if provided, write          */
   if (usValueLength)                  /* item value to target area   */
      memcpy(pItem->value, pValue, (size_t )usValueLength);

   *ppArea        += usItemLL;         /* update current area pointer */
   *pulAreaLength -= usItemLL;         /* update remaining area len.  */

   return (RC_TRUE);
}                                      /* end of WriteDataItem()      */
