/**/
PARSE ARG FileSpec SubDirs 
 
ServerName.0=0
IF FileSpec='' THEN
DO    
   SAY "Enter a file spec and /S to index subdirectories index"
   SAY "For example:"
   SAY "INDEX D:\TEST\* /S"

      SAY "will schedule for indexing all the files in d:\TEST"
   SAY "and the subdirectories below it"
   EXIT
END
  
call RxFuncAdd 'LoadRxSM2Funcs', 'REXXSM2', 'LoadRxSM2Funcs'
CALL rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
CALL sysloadfuncs
CALL LoadRxSM2Funcs
   
rc = RxSM2ListServers("ServerName.")
   SAY "Number of servers is " ServerName.0
DO I=1 to ServerName.0
   SAY "Found server: " ServerName.I
END
IF rc > 0 THEN
   SAY "rc from ListServers is " rc
ELSE
DO
   /* just pick the first one */
   server=ServerName.1
   /* start the server */
   'sm2 start ' server
   rc= RxSM2StartSession(server)
   IF rc <> '0' THEN
   DO
      SAY "rc from StartSession is " rc
   END
   ELSE
   DO
      SAY "Started Session " 
      rc= RxSM2OpenIndex(server)
      IF rc <> '0' THEN
      DO
         SAY "OpenIndex failed with rc " rc      
      END   
      ELSE
      DO
         SAY "Opened Index " 
         /* get a list of files */ 
         IF SubDirs='/S' | SubDirs='/s' THEN
            Attr='FOS'
         ELSE
            Attr='FO'
         rc = SysFileTree(FileSpec, 'file', Attr)
         DO i=1 to file.0
            rc= RxSM2ScheduleDocument(file.i)
            IF rc <> '0' THEN
            DO
               SAY "Schedule Document failed"
               SAY "RC=" rc
               SAY "Filename " file.i
               LEAVE
            END
            ELSE
               SAY "Scheduled " file.i " file # " i
         END
         rc= RxSM2CloseIndex()
         IF rc <> '0' THEN
            SAY "rc from Close Index is " rc
      END
      rc= RxSM2EndSession()
      IF rc <> '0' THEN
         SAY "rc from Stop Session is " rc
   END
END