/* Tower of hanoi */

trace o
say starting
parse version ver
say ver
parse source src .

call charout ,"Number of discs (3-12) ? "
parse pull disks .

signal on syntax name ignorerxfuncquery
If Word(ver,1) = 'REXXSAA' & src = 'AIX/6000' Then rc = SysAddFuncPkg('librxcurses.so')
Else Do
if rxfuncquery('CurLoadFuncs') = 1 then do
   if rxfuncadd('CurLoadFuncs','rxcurses','CurLoadFuncs')  then do
      say 'An error occured when trying to load the Rexx/Curses library.'
      if substr(ver, 1, 11) = 'REXX-Regina' Then say 'Error was' rxfuncerrmsg()
      say 'Exiting...'
      exit
      end
   call CurLoadFuncs
   end
end

ignorerxfuncquery:

signal on syntax

call CurInitscr
if lines < 24 | cols < 80 then do
   say 'This program cannot run in a screen with fewer than 24 lines'
   say 'and 80 columns. The size of this screen is' lines 'lines by' cols 'columns.'
   say 'Exiting...'
   end
if CurHasColors() Then
  Do
    call CurStartColor
    call CurInitPair 1, 'COLOR_RED', 'COLOR_BLACK'
    call CurInitPair 2, 'COLOR_BLUE', 'COLOR_BLACK'
    call CurInitPair 3, 'COLOR_WHITE', 'COLOR_BLACK'
    call CurInitPair 4, 'COLOR_GREEN', 'COLOR_BLACK'
    call CurInitPair 5, 'COLOR_YELLOW', 'COLOR_BLACK'
    call CurInitPair 6, 'COLOR_CYAN', 'COLOR_BLACK'
    call CurInitPair 7, 'COLOR_MAGENTA', 'COLOR_BLACK'
    call CurInitPair 8, 'COLOR_RED', 'COLOR_BLACK'
    call CurInitPair 9, 'COLOR_BLUE', 'COLOR_BLACK'
    call CurInitPair 10, 'COLOR_WHITE', 'COLOR_BLACK'
    call CurInitPair 11, 'COLOR_GREEN', 'COLOR_BLACK'
    call CurInitPair 12, 'COLOR_YELLOW', 'COLOR_BLACK'
  End

if CurHasAcs() then platechar = 'ACS_CKBOARD'
else platechar = '#'

call CurCursSet 0  /* turn off cursor */
call CurClear
call CurErase
call CurRefresh

w1 = CurNewwin(3,55,1,10)
call CurBox w1
call CurWmove w1, 1, 2
call CurWaddstr w1, 'Towers of Hanoi:' disks 'disks: '
call CurWrefresh w1

rc = time('E')

pole.1 = "" 
pole.2 = ""
pole.3 = ""
pole.height = disks 

do i=1 to disks 
   pole.1 = space( i pole.1 )
   end

parse value  13 40 66  with pole.pos.1 pole.pos.2 pole.pos.3

call setup_screen 
call move_stack disks 1 3 2
call CurCursSet 1  /* turn on cursor */
call CurWaddstr w1, 'Elapsed time:' Time('E')
call CurWrefresh w1
call CurMove 5, 20
call CurAddstr 'Press any key to continue...'
call CurRefresh
call CurCbreak
call CurNoecho
rc = CurGetch()
call CurDelwin w1
call CurEndwin
return 0

move_stack: procedure expose pole. screen. platechar
   parse arg num from target scratch
   if num <= 0 then 
      return

   call move_stack num-1 from scratch target
   call move_plate from target
   call move_stack num-1 scratch target from
   return 



move_plate: procedure expose pole. screen. platechar
   parse arg from target
   
   plate = word( pole.from, words( pole.from )) 
/* pole.from = subword( pole.from, 1, words( pole.from ) - 1 )  */
   pole.from = reverse( pole.from )
   parse var pole.from . pole.from 
   pole.from = reverse( pole.from ) 
   
   if 0 then
      say 'Moving plate' plate 'from pole' from 'to pole' target
   else
      call draw_a_move plate from target

   pole.target = pole.target plate
   return


draw_a_move: procedure expose pole. screen. platechar
   parse arg plate from target

   top = screen.height - pole.height - 2
   fulllen = plate*2+1
   empty = center('|', plate*2+1)
   real_empty = copies( ' ', plate*2+1)

   do i=words(pole.from) to pole.height+1
      call CurMove screen.height-i-2, pole.pos.from-plate
      if CurHasColors() Then call CurAttrset 'COLOR_PAIR('plate')', 'A_BOLD'
      do fulllen
         call CurAddch platechar
         end
      If CurHasColors() Then call CurAttrset 'A_NORMAL'
      call CurMove screen.height-i-1, pole.pos.from-plate
      if (i>pole.height) then
         call CurAddstr real_empty
      else
         call CurAddstr empty
      call CurRefresh
      end

   top = screen.height - pole.height - 3
   step = sign( pole.pos.target - pole.pos.from )
   do i=pole.pos.from to pole.pos.target-step by step
      if i-step*plate < 0 then trace ?r
      call CurMove top, i-step*plate
      call CurAddch ' '
      call CurMove top, i+step*plate+step
      if CurHasColors() Then call CurAddch platechar, 'COLOR_PAIR('plate')', 'A_BOLD'
      else call CurAddch platechar
      call CurRefresh
      end


   j = screen.height - pole.height - 1
   do i=0 to pole.height + 1 - words(pole.target)
      call CurMove j+i-1, pole.pos.target-plate
      if CurHasColors() Then call CurAttrset 'COLOR_PAIR('plate')', 'A_BOLD'
      do fulllen
         call CurAddch platechar
         end
      If CurHasColors() Then call CurAttrset 'A_NORMAL'
      call CurMove j+i-2, pole.pos.target-plate
      if (i<=1) then
         call CurAddstr real_empty
      else
         call CurAddstr empty
      call CurRefresh
      end

   return 


setup_screen: 
   screen.height = lines-1 /*24*/
   screen.width = cols /*80*/
   

   do i=1 to disks
      call CurMove screen.height-i, pole.pos.1-(disks+1-i)
      fulllen = 2*(disks-i)+3
      if CurHasColors() Then call CurAttrset 'COLOR_PAIR(' || (fulllen-1)/2 || ')', 'A_BOLD'
      do fulllen
         call CurAddch platechar
         end
      end

   If CurHasColors() Then call CurAttrset 'A_NORMAL'
   call CurMove (screen.height-(disks+1)), pole.pos.1
   call CurAddch '|'

   do i=1 to disks+1
      call CurMove screen.height-i, pole.pos.2
      call CurAddch '|'
      call CurMove screen.height-i, pole.pos.3
      call CurAddch '|'
      end

   call CurRefresh

   return

trap_msg:
   say 
   say 'Sorry, this script is not meant to be executed directly from the'
   say 'command line. It is a demonstration of the use of the libregina.a'
   say 'library. Try to compile "hanoi.c", and like with libregina.a, and'
   say 'try to run the "hanoi" program. Enjoy!'
   say 
   exit 0

syntax:
   call CurEndwin
   exit 0
