/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992-1994  Anders Christensen <anders@pvv.unit.no>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/****************************************************************************
*   This code modified for Multithread Win32 port by Les Moull April 1999.  *
****************************************************************************/

/*
 * $Id: types.h,v 1.11 1993/05/10 05:54:59 anders Exp anders $
 */


typedef struct varbox *variableptr ;
typedef struct varbox {
   variableptr next, prev, realbox, *index ;
   struct strengtype *name, *value ;
   int guard ;
   num_descr *num ;
   int flag ;
   long hwired, valid ; /* FGC: at least valid may be too small for many
                                recursions with short instead of long.
                                27.09.98 (09/27/98). */
   variableptr stem ;
} variable ;

/* typedef int bool ; */

typedef struct {
   unsigned int lnum:1 ;
   unsigned int rnum:1 ;
   unsigned int lsvar:1 ;
   unsigned int rsvar:1 ;
   unsigned int lcvar:1 ;
   unsigned int rcvar:1 ;
} compflags ;

typedef struct pparambox *paramboxptr ;
typedef struct tnode *nodeptr ;
typedef struct tnode {
   unsigned int type ;
   int charnr, lineno ;
   int called;
   struct strengtype *name ;
   long now, unow, usec, sec ;
   struct tnode *p[5] ;
   union {
      streng *(*func)(paramboxptr) ;
      streng *strng ;
      struct tnode *node ;
      num_descr *number ;
      compflags flags ;
      variable *varbx ;
   } u ;
   struct tnode *next ;
} treenode ;

typedef struct stackboxtype *stackboxptr ;
typedef struct stackboxtype {
   int whereto, number ;
   void *increment, *tdescr, *stopval ;
   int incrdir ;
   int guard ;
   streng *oldcnt ;
   nodeptr this ;
} stackbox ;

typedef struct pparambox {
   paramboxptr next ;
   int dealloc ;
   struct strengtype *value ;
} parambox ;

typedef struct lineboxx *lineboxptr ;
typedef struct lineboxx {
   lineboxptr next, prev ;
   struct strengtype *line ;
   int lineno ;
} linebox ;

typedef variableptr hashtabl[HASHTABLENGTH] ;

typedef struct labelboxx *labelboxptr ;
typedef struct labelboxx {
   labelboxptr next ;
   nodeptr entry ;
} labelbox ;

typedef struct trap_type  /* index is type of signal */
{
   unsigned on_off:1 ;     /* true if trap is active/on */
/* unsigned trapped:1 ; */ /* true if condition has been raised */
   unsigned def_act:1 ;    /* true if default action is to ignore */
   unsigned delayed:1 ;    /* true if trap is in delay mode */
   unsigned ignored:1 ;    /* true if ignored when in delayed mode */
   unsigned invoked:1 ;    /* true if invoked by SIGNAL */
   streng *name ;          /* label to transfer control to */
} trap ;

typedef struct sig_type
{
   int type ;
   streng *info ;
   streng *descr ;
   int invoke ;     /* is true if invoked with SIGNAL */
   int rc, subrc, lineno ;
} sigtype ;


typedef struct option
{
   char *name ;
   int offset ;
   char *contains ;
} option_type ;



typedef struct proclevelbox *proclevel ;
typedef struct proclevelbox {
   int numfuzz, currnumsize, numform ;
   int mathtype ;
   long sec, usec ;
   proclevel prev, next ;
   variableptr *vars ;
   paramboxptr args ;
   struct strengtype *environment, *prev_env ;
   char tracestat, varflag ;
   sigtype *sig ;
   trap *traps ;
   jmp_buf *buf ;  /* for use by longjmp */
   union {
#ifdef OLD_OPTIONS
      struct {
         unsigned int flushstack : 1 ;
         unsigned int lineouttrunc : 1 ;
         unsigned int close_bif : 1 ;
         unsigned int open_bif : 1 ;
         unsigned int buftype_bif : 1 ;
         unsigned int desbuf_bif : 1 ;
         unsigned int dropbuf_bif : 1 ;
         unsigned int makebuf_bif : 1 ;
         unsigned int cacheext : 1 ;
         unsigned int find_bif : 1 ;
         unsigned int prune_trace : 1 ;
         unsigned int ext_commands_as_funcs : 1 ;
         unsigned int stdout_for_stderr : 1 ;
         unsigned int trace_html : 1 ;
         unsigned int default_lines_bif_is_actual : 1 ;
         unsigned int ansi : 1 ;
         unsigned int unusedbit0 : 1 ;
         unsigned int unusedbit1 : 1 ;
         unsigned int unusedbit2 : 1 ;
         unsigned int unusedbit3 : 1 ;
         unsigned int unusedbit4 : 1 ;
         unsigned int unusedbit5 : 1 ;
         unsigned int unusedbit6 : 1 ;
         unsigned int unusedbit7 : 1 ;
         unsigned char unusedchar3 ;
      } options ;
#endif
      unsigned char flags[4] ;
   } u ;
} proclevbox ;

typedef struct systeminfobox *sysinfo ;
typedef struct systeminfobox {
   struct strengtype *called_as, *input_file ;
   streng *environment ;
   FILE *input_fp;
   int tracing ;
   int interactive ;
   lineboxptr firstline, lastline ;
   labelboxptr firstlabel, lastlabel ;
   jmp_buf *panic ;
   streng *result ;
   proclevbox *currlevel0 ;
   struct systeminfobox *previous ;
   nodeptr rootnode, *callstack ;
   int cstackcnt, cstackmax ;
   int hooks ;
   int invoked ;
   int serial;
   int trace_override;
} sysinfobox ;

struct entrypt {
   char *name ;
   streng *(*addr)() ;
} ;


struct library {
   streng *name ;
   void *handle ;
   short number ;
   struct library_func *first ;
   struct entrypt *funcs ;
   struct library *next, *prev ;
} ;

#ifndef DONT_TYPEDEF_PFN
typedef unsigned long (*PFN)() ;
#endif

struct library_func {
   streng *name ;
   PFN addr  ;
   struct library *lib ;
   struct library_func *next, *prev ;
   struct library_func *forw, *backw ;
} ;

/*struct funcbox {
   struct funcbox *next, *prev ;
   streng *name ;
   int type ;
   int hash1 ;
};
*/
#if defined(HAVE_WINMULTITHREADING)
typedef unsigned int yy_size_t;
struct yy_buffer_state
 {
 FILE *yy_input_file;
 char *yy_ch_buf;
 char *yy_buf_pos;
 yy_size_t yy_buf_size;
 int yy_n_chars;
 int yy_is_our_buffer;
 int yy_is_interactive;
 int yy_at_bol;
 int yy_fill_buffer;
 int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
#define YY_BUFFER_EOF_PENDING 2
 };
typedef struct yy_buffer_state *YY_BUFFER_STATE;
typedef struct stacklinestruct *stacklineptr ;
typedef struct stacklinestruct
{
   stacklineptr next, prev ;
   streng *contents ;
} stackline ;
typedef struct fileboxtype *fileboxptr ;
typedef struct fileboxtype {
   FILE *fileptr ;
   unsigned char oper ;
   size_t readpos, writepos, thispos ;
   int flag, error, readline, writeline, linesleft ;
   fileboxptr prev, next, newer, older ;
   streng *filename0 ;
   streng *errmsg ;
} filebox ;
typedef struct {
   void **Elems;
   unsigned size;
} Pool;
static int sizes[] = {    8,   12,   16,   24,   32,   48,   64,   96,
                        128,  192 , 256,  384,  512,  768, 1024, 1536,
                       2048, 3072, 4096 } ;
typedef struct meminfo_type
{
   char *start ;                /* start of memory's address */
   char *last ;                 /* end of memory's address */
   struct meminfo_type *next ;  /* next ptr in linked list */
   int size ;                   /* size of chunks at that address */
} meminfo ;
#define MAX_MARKERS 100
#define MEMINFO_HASHSIZE (499)
#define CHUNK_SIZE (8192)

typedef struct memhead
{
   int count ;                    /* Size of this piece of memeory */
   struct memhead *prev, *next ;  /* Ptrs in double linked list */
   unsigned short seqv ;          /* Sequential counter */
   unsigned char flag ;           /* What is this memory used for */
   unsigned char magic ;          /* Not really used */
} memheader;

struct envirlist {
   struct envirlist *next ;
   streng *ptr ;
};
struct envir
{
   streng *name ;
   int type ;
   int subtype ;
   struct envir *next, *prev ;
};
typedef struct globalvar {
int InUse;
sysinfo systeminfo ;
proclevel currlevel ;
proclevel mainlevel ;
nodeptr parseroot ;
int listleakedmemory ;
void *CH;
int DaysInYear[12];
int MonthDays[12];
int isvalue;
int countthreads;
int stemidx;
int tailidx ;
int nextline ;
int nextstart;
int var_indicator ;
int isclient ;
int tline ;
int thischar;
int tstart;
int yydebug ;
char *signalnames[6] ;
char *WeekDays[7];
char *months[12];
char *flists[sizeof(sizes)/sizeof(int)] ;
meminfo *hashtable[ MEMINFO_HASHSIZE ];
short hash[ CHUNK_SIZE/4 + 1 ];
int allocated ;
int deallocated ;
int sequence ;
struct memhead *header0;
void (*(markers[MAX_MARKERS]))();
int max_markers_regd;
variableptr first_invalid;
void *indeks_ptr;
Pool NamePool;
Pool ValuePool;
Pool NumPool;
Pool VarPool;
int foundflag;
variable *thespot;
int current_valid;
long next_current_valid;
int subst;
int hashval;
int ignore_novalue;
int notrace;
streng *tmpindex;
streng *ovalue;
streng *xvalue;
num_descr *odescr;
int tellex;
variableptr pstem;
variableptr ptail;
variableptr *table;
lineboxptr first_source_line;
lineboxptr last_source_line;
YY_BUFFER_STATE yy_current_buffer;
YY_CHAR_TYPE *yylastch;
nodeptr currentnode;
FILE *yyin;
FILE *yyout;
short chbuffer[LOOKAHEAD] ;
char ch;
char ech ;
char *interptr;
char yy_hold_char;
char *yy_c_buf_p;
char *interptrmax;
char *yy_full_match;
char *yytext;
char retvalue[1024] ;
int yy_state_buf[16386];
int *yy_state_ptr;
int yy_n_charsa;
int yyleng;
int yy_init;
int yy_start;
int yy_did_buffer_switch_on_eof;
int inEOF;
int singlequote;
int doblequote;
int firstln;
int bufptr;
int ipretflag;
int cch;
int cchmax;
int yy_lp;
int retlength;
int do_level;
int in_numform;
int next_numform;
int obs_with;
int in_do;
int in_then;
int dontlast;
int sum;
int code;
int nexta;
int in_parse;
int in_trace;
int itflag;
int in_signal;
int in_call;
int in_address;
int seek_with;
int preva;
int lasta;
int kill_this_space;
int kill_next_space;
int extnextline;
int extnextstart;
int linenr;
int contline;
int yy_start_stack_ptr;
int yy_start_stack_depth;
int *yy_start_stack;
int tmplno;
int tmpchr;
int yychar;
int yynerrs;
nodeptr yylval;
sigtype *nextsig;
int indentsize;
int loopcnt;
FILE *stddump;
int parse_error_flag;
stacklineptr lastline0;
stacklineptr firstline0;
int buffers;
stacklineptr firstbox;
stacklineptr lastbox;
fileboxptr mrufile;
fileboxptr swappoint;
fileboxptr stdio_ptr[6];
void *rdarea;
void *outptr1;
void *outptr2;
void *outptr3;
void *outptr4;
void *outptr5;
num_descr rdescr;
num_descr sdescr;
num_descr fdescr;
num_descr edescr;
paramboxptr listleaked_params ;
paramboxptr par_stack ;
int totals ;
streng *var_result ;
nodeptr nvar_rc ;
nodeptr nvar_sigl ;
int trace_stat ;
int hepp ;
int guardnumber;
int traceparse ;
streng nullstring;
num_descr rdes;
num_descr ldes;
char *filenamecms;
char buf0[32];
int bufptr0;
int traceflag;
int lasttracedline;
int ctrlcounter;
int notnow;
char tracestr[LINELENGTH+1] ;
int ichan;
int ochan;
int pid;
int oflag;
int comp_stat;
int dead;
int queue;
struct envirlist *first_envirvar;
streng var_rc;
struct envir *firstenvir;
} globalext ;
#endif


