#
# Makefile for Regina REXX Interpreter
#
# Using Sun Pro Compiler on Solaris 2.x
#
# Compile all modules that make up the shared library version of
# libregina with -KPIC
# Link (using ld) the libregina shared library with:
#   ld -G -o libregina.so objs...
# Compile all modules that make up the rxlib shared libraries
# with -KPIC
# Link (using ld) the rxlib shared libraries with:
#   ld -G file.rxlib objs...
SRCDIR=.
CC = cc
CEXTRA = -Xa -DSOLARIS -I/usr/include
EEXTRA =
DYN_COMP = -KPIC -DDYNAMIC
LIBS = -ll -lm
SHLIBS = -ldl
SHL = so
LD_RXLIB1=ld -G
LD_RXLIB2=
SHL_LD=ld -G -o $(LIBPRE)$(LIBFILE).$(SHL).$(VERDOT) $(SHOFILES)
SHL_TARGETS=$(LIBPRE)$(LIBFILE).a $(LIBPRE)$(LIBFILE).$(SHL) curses.rxlib test1.rxlib test2.rxlib
LDEXTRA=
LIBPRE = lib
LIBFILE = regina
OBJECTS = $(OFILES)
OSAVE = .o.save
MV=-mv
#
SHLFILE = regina
OBJ = o
EXE =
LIBPST = a
LIBEXE = ar
LIBFLAGS = cr $(LIBPRE)$(LIBFILE).$(LIBPST)
LIBLINK = -L. -l$(LIBFILE)
LINKSHL = $(LIBPRE)$(SHLFILE).$(SHL)
RXLIB = rxlib
GETOPT =
SHL1 = rm -f $(LIBPRE)$(SHLFILE).$(SHL).$(ABI)
SHL2 = ln -s $(LIBPRE)$(SHLFILE).$(SHL).$(VERDOT) $(LIBPRE)$(LIBFILE).$(SHL).$(ABI)
SHL3 = rm -f $(LIBPRE)$(SHLFILE).$(SHL)
SHL4 = ln -s $(LIBPRE)$(SHLFILE).$(SHL).$(ABI) $(LIBPRE)$(LIBFILE).$(SHL)
#
# If you have installed XCurses, and you want to use it for the hanoi.rex test program
# uncomment the following two lines
#
#CURSESINC=-I../include -DXCURSES
#CURSESLIB=-L../lib -lxcurses -R/usr/openwin/lib   -L/usr/openwin/lib -lXaw -lXmu -lXt -lX11 -lsocket
CURSESINC=
CURSESLIB=-L/usr/ccs/lib -lcurses

RANLIB_LIB=#ranlib $(LIBFILE).a

#
# If your compiler can handle the combination of: -c -o file.sho, then
# uncomment the macro CC2O and comment out the 3 macros before CC2O
#
O2SHO=-mv `basename $@ .sho`.o $@
O2SAVE=-mv `basename $@ .sho`.o `basename $@ .sho`.o.save
SAVE2O=-mv `basename $@ .sho`.o.save `basename $@ .sho`.o
CC2O=#-o $@
#
# Include the common rules for the interpreter
#
include $(SRCDIR)/makefile.com
#
# End of makefile
#
