#ifndef lint
static char *RCSid = "$Id: macros.c,v 1.2 1993/05/10 06:04:06 anders Exp anders $";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1993-1994  Anders Christensen <anders@pvv.unit.no>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/****************************************************************************
*   This code modified for Multithread Win32 port by Les Moull April 1999.  *
****************************************************************************/

#include "rexx.h"
#include "rxiface.h"

#include <stdio.h>
#include <ctype.h>
#include <setjmp.h>
#include <string.h>
#include <assert.h>


struct macro {
   struct macro *prev, *next ;
   streng *name ;
   lineboxptr first, last ;
   labelboxptr firstlabel, lastlabel ;
   nodeptr tree ;
   int serial ;
#if defined(HAVE_WINMULTITHREADING)
   sysinfobox *savedsys;
#endif
};
struct macro *firstmacro = NULL ;
int there_is_no_error ;
int macro_serialno = 0 ;
#if !defined(HAVE_WINMULTITHREADING)
extern nodeptr parseroot ;
REG_FAR extern lineboxptr first_source_line, last_source_line ;
#endif

struct macro *find_macro( streng *name, int serial )  ;

struct macro *find_macro2( streng *name )  ;

void killsystem( sysinfo systm )
{
   labelbox *lptr=NULL, *olptr=NULL ;
#include "multi.h"

   for (lptr=systm->firstlabel; lptr; lptr=olptr )
   {
      olptr = lptr->next ;
      Free( lptr ) ;
   }
   systm->firstlabel = NULL;

   if ( systm->environment )
   {
      Free_string( systm->environment ) ;
      systm->environment = NULL;
   }

   if ( systm->called_as )
   {
      Free_string( systm->called_as ) ;
      systm->called_as = NULL;
   }

   if (systm->input_file )
   {
      Free_string( systm->input_file ) ;
      systm->input_file = NULL;
   }

   if (systm->input_fp )
   {
      fclose( systm->input_fp ) ;
      systm->input_fp = NULL;
   }

   if ( systm->rootnode)
   {
      destroytree( systm->rootnode ) ;
      systm->rootnode = NULL;
   }

   if (systm->currlevel0)
     {
      removelevel( systm->currlevel0 ) ;
      systm->currlevel0 = NULL;
     }

   if (systm->firstline)
   {
      kill_lines( systm->firstline ) ;
      systm->firstline = NULL;
   }

   if (systm->panic)
   {
      Free( systm->panic ) ;
      systm->panic = NULL;
   }

   if ( systm->result)
   {
      Free_string( systm->result ) ;
      systm->result = NULL;
   }

   if (systm->callstack)
   {
      Free( systm->callstack ) ;
      systm->callstack = NULL;
   }

   Free( systm ) ;
#include "unmulti.h"
}

#if defined(HAVE_WINMULTITHREADING)
streng *do_instore( streng *name, paramboxptr args, streng *envir,
               int *RetCode, int hooks, int calltype, int ctype , streng *StrSrc,int *instore_idx)
{
   sysinfobox *newsystem, *tmpsys;
   int count0;
   int oldhooks;
   int oldinvoked;
   jmp_buf *oldpanic;
   paramboxptr oldargs;
   struct macro *mptr ;
   streng *ptr ;
   jmp_buf *jbuf ;
   int Tag=0;
#include "multi.h"

   count0=countthreads;
   if ((ctype==INVO_COMMAND) && (args!=0L) && (args->next==0L) && (args->value->len==2) && (!strncmp(args->value->value,"/T",2)))
   {
      Tag=1;
   }
   if (RetCode)
      *RetCode = 0 ;
   if (calltype==RX_TYPE_SOURCE)
   {
      if(count0==1)
      {
         currentnode = NULL ;
         newsystem = creat_sysinfo( Str_dup(envir)) ;
         newsystem->previous = systeminfo ;
         systeminfo->currlevel0 = currlevel ;
         currlevel = NULL ;
         systeminfo = newsystem ;
         systeminfo->hooks = 0 ;
         systeminfo->panic = (jmp_buf *)0L ;
         systeminfo->invoked = ctype ;
         systeminfo->currlevel0 = currlevel = newlevel( NULL ) ;
         currlevel->args = args ;
         systeminfo->called_as = Str_dup( name ) ;
         systeminfo->input_file = Str_dup( name ) ;
      }
      else
      {
         oldhooks=systeminfo->hooks;
         oldinvoked=systeminfo->invoked;
         oldpanic=systeminfo->panic;
         oldargs=currlevel->args;
         currlevel->args = args ;
      }
   }
   else if (calltype==RX_TYPE_INSTORE)
   {
      if(count0==1)
      {
         int ser;
         char val[21];

         strncpy(val,StrSrc->value,20);
         val[StrSrc->len]='\0';
         ser=atoi(val);
         mptr = find_macro( NULL, ser ) ;
         systeminfo = mptr->savedsys;
         currentnode = NULL ;
         currlevel = systeminfo->currlevel0 ;
         currlevel->args = args ;
      }
      else
      {
         oldhooks=systeminfo->hooks;
         oldinvoked=systeminfo->invoked;
         oldpanic=systeminfo->panic;
         oldargs=currlevel->args;
         currlevel->args = args ;
      }
   }
   there_is_no_error = 0 ;
   jbuf = Malloc( sizeof(jmp_buf) ) ;
   if (setjmp(*jbuf))
   {
      ptr = systeminfo->result ;
      systeminfo->result = NULL ;
      if (!there_is_no_error && RetCode)
         *RetCode = -1 ;
      if ((Tag==0) && systeminfo->hooks & HOOK_MASK(HOOK_TERMIN))//
      {
         ignore_novalue = 1 ;
         hookup( HOOK_TERMIN ) ;
         ignore_novalue = 0 ;
      }
   }
   else
   {
      systeminfo->hooks = hooks ;
      systeminfo->panic = jbuf ;
      systeminfo->invoked = ctype ;
      if ((calltype==RX_TYPE_SOURCE) && (count0==1))
      {
         systeminfo->serial=enter_macro(systeminfo, StrSrc, name ) ;
      }
      *instore_idx=systeminfo->serial;
      Free_string( StrSrc ) ;
      StrSrc=0L;
      if((Tag==0) && (count0==1))
      {
         mptr = find_macro( NULL, systeminfo->serial ) ;
         systeminfo->rootnode = mptr->tree ;
         systeminfo->firstline = mptr->first ;
         systeminfo->lastline = mptr->last ;
         systeminfo->firstlabel = mptr->firstlabel ;
         systeminfo->lastlabel = mptr->lastlabel ;
      }
      if ((Tag==0) && systeminfo->hooks & HOOK_MASK(HOOK_INIT))
      {
         ignore_novalue = 1 ;
         hookup( HOOK_INIT ) ;
         ignore_novalue = 0 ;
      }

      if ((Tag==0) && systeminfo->rootnode)
      {
         ptr = interpret( systeminfo->rootnode ) ;
      }
      else
         ptr = NULL ;
      if ((Tag==0) && systeminfo->hooks & HOOK_MASK(HOOK_TERMIN))
      {
         ignore_novalue = 1 ;
         hookup( HOOK_TERMIN ) ;
         ignore_novalue = 0 ;
      }
   }
   if (count0==1)
   {
      tmpsys = systeminfo ;
      systeminfo = systeminfo->previous ;
      currlevel = systeminfo->currlevel0 ;
      trace_stat = currlevel->tracestat ;
   }
   else
   {
      systeminfo->hooks=oldhooks;
      systeminfo->invoked=oldinvoked;
      systeminfo->panic=oldpanic;
      currlevel->args=oldargs;
   }
   /* Oops, we really ought to handle function-did-not-return-data */
   return (ptr) ? ptr : nullstringptr()  ;
#include "unmulti.h"
}

#else /* !defined(HAVE_WINMULTITHREADING) */
streng *do_instore( streng *name, paramboxptr args, streng *envir,
               int *RetCode, int hooks, int dummy, int serial, int ctype )
{
   sysinfobox *newsystem=NULL, *tmpsys=NULL ;
   extern proclevel currlevel ;
   extern sysinfobox *systeminfo ;
   REG_FAR extern nodeptr currentnode ;
   struct macro *mptr=NULL ;
   streng *ptr=NULL ;
   jmp_buf *jbuf=NULL ;


   if (RetCode)
      *RetCode = 0 ;

   there_is_no_error = 0 ;
   jbuf = Malloc( sizeof(jmp_buf) ) ;
   if (setjmp(*jbuf))
   {
      ptr = systeminfo->result ;
      systeminfo->result = NULL ;
      if (!there_is_no_error && RetCode)
         *RetCode = -1 ;
   }
   else
   {
      currentnode = NULL ;

      newsystem = creat_sysinfo( Str_dup(envir)) ;
      newsystem->previous = systeminfo ;
      systeminfo->currlevel0 = currlevel ;

      currlevel = NULL ;
      systeminfo = newsystem ;
      systeminfo->hooks = hooks ;
      systeminfo->panic = jbuf ;
      systeminfo->invoked = ctype ;
      systeminfo->called_as = Str_dup( name ) ;
      systeminfo->input_file = Str_dup( name ) ;
      systeminfo->currlevel0 = currlevel = newlevel( NULL ) ;

      currlevel->args = args ;
/*
      if (currentnode)
      {
         pushcallstack( currentnode ) ;
         must_pop = 1 ;
      }
 */
      mptr = find_macro( NULL, serial ) ;
      systeminfo->rootnode = mptr->tree ;
      systeminfo->firstline = mptr->first ;
      systeminfo->lastline = mptr->last ;
      systeminfo->firstlabel = mptr->firstlabel ;
      systeminfo->lastlabel = mptr->lastlabel ;
      if (systeminfo->hooks & HOOK_MASK(HOOK_INIT))
         hookup( HOOK_INIT ) ;

      if (systeminfo->rootnode)
         ptr = interpret( systeminfo->rootnode ) ;
      else
         ptr = NULL ;

   }
   if (systeminfo->hooks & HOOK_MASK(HOOK_TERMIN))
      hookup( HOOK_TERMIN ) ;
/*
   if (must_pop)
      popcallstack( -1 ) ;
 */
   tmpsys = systeminfo ;
   systeminfo = systeminfo->previous ;
   currlevel = systeminfo->currlevel0 ;
   trace_stat = currlevel->tracestat ;

   tmpsys->currlevel0->args = NULL ;
   tmpsys->rootnode = NULL ;
   tmpsys->firstline = NULL ;
   killsystem( tmpsys ) ;

   /* Oops, we really ought to handle function-did-not-return-data */
   return (ptr) ? ptr : nullstringptr()  ;
}
#endif

streng *execute_external( streng *command, paramboxptr args, streng *envir,
                          int *RetCode, int hooks, int ctype )
{
   sysinfobox *newsystem=NULL, *tmpsys=NULL ;
   char name[1024] ;
   streng *ptr=NULL ;
   char *cptr=NULL, *eptr=NULL, *start=NULL, *stop=NULL ;
   char path[1024] ;
   FILE *fptr=NULL ;
   jmp_buf *jbuf=NULL ;
#if FGC
   volatile proclevel oldlevel; /* volatile needed at least by GCC 2.7.2 */
#endif
#if !defined(HAVE_WINMULTITHREADING)
   extern proclevel currlevel ;
   extern sysinfobox *systeminfo ;
   extern nodeptr currentnode ;
#else
# include "multi.h"
#endif

   if (RetCode)
      *RetCode = 0 ;

   fptr = NULL ;
   jbuf = Malloc( sizeof(jmp_buf) ) ;
   there_is_no_error = 0 ;

   if (setjmp(*jbuf))
   {
/*      if (fptr != stdin)
         fclose(fptr) ;
*/
      ptr = systeminfo->result ;
      systeminfo->result = NULL ;
      if (!there_is_no_error && RetCode)
         *RetCode = -1 ;
   }
   else
   {
      /* FGC: Check length first to avoid  */
      /*      access of invalid buffer     */
      if ( ( command->len == 7 )
      && ( memcmp("<stdin>",command->value,command->len) == 0 ) )
      {
         fptr = stdin;
         strcpy(name,command->value);
      }
      else
      {
         cptr = command->value ;
         eptr = cptr + command->len ;

         for (start=cptr; start<eptr && isspace(*start); start++) ;
         for (stop=eptr-1;stop>start && isspace(*stop);  stop--) ;

         memcpy( path, start, (stop-start)+1 ) ;
         *(path+(stop-start)+1) = 0x00 ;
         get_external_routine(path,&fptr,name,0);

         if (!fptr)
         {
            Free( jbuf ) ;
            if (RetCode)
            {
               *RetCode = -ERR_PROG_UNREADABLE;
               if ( get_options_flag( currlevel, EXT_STDOUT_FOR_STDERR ) )
               {
                  fprintf(stdout,"REXX: Error %d: %s: \"%s\"\n",
                       ERR_ROUTINE_NOT_FOUND,
                       errortext( ERR_ROUTINE_NOT_FOUND ), name );
                  fflush( stdout );
               }
               else
                  fprintf(stderr,"REXX: Error %d: %s: \"%s\"\n",
                       ERR_ROUTINE_NOT_FOUND,
                       errortext( ERR_ROUTINE_NOT_FOUND ), name );
            }
            return NULL ;
         }
      }
      initexternal( fptr ) ;
      currentnode = NULL ;

      newsystem = creat_sysinfo( Str_dup(envir)) ;
      newsystem->previous = systeminfo ;
#if FGC /* FGC: NOTE: I found that currlevel */
        /*      has changed outside between  */
        /*      calls to this function. I    */
        /*      really don't know, if this   */
        /*      should happen. A typical     */
        /*      change of currlevel is done  */
        /*      in interpret. Maybe, in      */
        /*      interpret is an error caused */
        /*      by an illegal "postrecursed" */
        /*      re-interpret. Somebody with  */
        /*      a higher view of the code    */
        /*      as mine should check the     */
        /*      code there.                  */
        /*      I detected the error in THE  */
        /*      using regina while calling   */
        /*      macros in macros called by   */
        /*      THE in a macro (confusing,   */
        /*      hmm? :-(  )                  */
      oldlevel = currlevel;
#else
      systeminfo->currlevel0 = currlevel ;
#endif

      currlevel = NULL ;
      systeminfo = newsystem ;
      systeminfo->hooks = hooks ;
      systeminfo->invoked = ctype ;
      systeminfo->panic = jbuf ;
      systeminfo->called_as = Str_dup( command ) ;
      systeminfo->input_file = Str_cre( name ) ;
      systeminfo->currlevel0 = currlevel = newlevel( NULL ) ;

      currlevel->args = args ;
/*
      if (currentnode)
      {
         pushcallstack( currentnode ) ;
         must_pop = 1 ;
      }
*/
      parseroot = NULL ;
      if (!yyparse())
      {
         systeminfo->rootnode = parseroot ;
         parseroot = NULL ;
         systeminfo->firstline = first_source_line ;
         systeminfo->lastline = last_source_line ;
         treadit( systeminfo->rootnode ) ;
         if (systeminfo->hooks & HOOK_MASK(HOOK_INIT))
            hookup( HOOK_INIT ) ;

         /* BUGFIX 16/02/1999 - Kris Jacobs - fclose should be here.
          *         After this line fptr is not used anymore.
          */
         /*
          * Don't close fptr if it is stdin!
          */
         if (fptr != stdin)
            fclose(fptr) ;
         ptr = interpret( systeminfo->rootnode ) ;
      }
      else
      {
         /* BUGFIX 16/02/1999 - Kris Jacobs - fclose should be here.
          *         After this line fptr is not used anymore.
          */
         /*
          * Don't close fptr if it is stdin!
          */
         if (fptr != stdin)
            fclose(fptr) ;
         ptr = NULL ;
         exiterror( ERR_YACC_SYNTAX, 0 )  ;
      }
      /* BUGFIX 16/02/1999 - Kris Jacobs - fclose is never reached here,
       *         moved it upwards.
       */
      /*
       * Don't close fptr if it is stdin!
       */
      /*
      if (fptr != stdin)
         fclose(fptr) ;
      */
   }
   if (systeminfo->hooks & HOOK_MASK(HOOK_TERMIN))
      hookup( HOOK_TERMIN ) ;

/*
   if (must_pop)
      popcallstack( -1 ) ;
*/
   tmpsys = systeminfo ;
   systeminfo = systeminfo->previous ;
#if FGC /* FGC: See note above */
   currlevel = oldlevel;
#else
   currlevel = systeminfo->currlevel0 ;
#endif
   trace_stat = currlevel->tracestat ;

   tmpsys->currlevel0->args = NULL ;
   killsystem( tmpsys ) ;

   /* Oops, we really ought to handle function-did-not-return-data */
   return (ptr) ? ptr : nullstringptr()  ;
#include "unmulti.h"
}



struct macro *find_macro( streng *name, int serial )
{
   struct macro *mptr=NULL ;
#include "multi.h"

   assert( name || serial ) ;
   for (mptr=firstmacro; mptr; mptr=mptr->prev)
   {
      if ((!name || !Str_cmp(name, mptr->name)) &&
                                 (!serial || serial==mptr->serial))
          return mptr ;
   }
   return NULL ;
#include "unmulti.h"
}

#if defined(HAVE_WINMULTITHREADING)
struct macro *find_macro2( streng *name )
{
   struct macro *mptr=NULL ;
#include "multi.h"

   assert( name ) ;
   for (mptr=firstmacro; mptr; mptr=mptr->prev)
   {
      if (!Str_cmp(name, mptr->name))
          return mptr ;
   }
   return NULL ;
#include "unmulti.h"
}
#endif



void kill_macro( streng *name, int serial )
{
   struct macro *mptr=NULL ;
#include "multi.h"

   mptr = find_macro( name, serial ) ;
   if (mptr)
   {
      kill_lines( mptr->first ) ;
      destroytree( mptr->tree ) ;
      if (mptr->name)
         Free_string( mptr->name ) ;
      if (mptr->prev)
         mptr->prev->next = mptr->next ;

      if (mptr->next)
         mptr->next->prev = mptr->prev ;
      else
         firstmacro = mptr->prev ;
#if defined(HAVE_WINMULTITHREADING)
      if (mptr->savedsys!=0L)
      {
         /*   mptr->savedsys->currlevel0->args = NULL ; */
         mptr->savedsys->rootnode = NULL ;
         mptr->savedsys->firstline = NULL ;
         mptr->savedsys->lastline = NULL ;
         killsystem( mptr->savedsys ) ;
      }
#endif
   }
#include "unmulti.h"
}


#if defined(HAVE_WINMULTITHREADING)
int enter_macro(sysinfobox *sysinf, streng *source, streng *name )
{
   treenode *newtree=NULL ;
   struct macro *newmacro=NULL ;
   struct macro *mptr ;
   int serial;
#include "multi.h"

   mptr = find_macro2( name ) ;
   if (mptr!=0L)
   {
      serial=mptr->serial;
      kill_macro( NULL, serial) ;
   }

   initmacro( source ) ;
   parseroot = NULL ;
   if (!yyparse())
   {
      newtree = parseroot ;
      parseroot = NULL ;
      treadit( newtree ) ;
      newmacro = Malloc( sizeof( struct macro )) ;
      newmacro->savedsys=sysinf;
      newmacro->next = NULL ;
      newmacro->first = first_source_line ;
      newmacro->last = last_source_line ;
      newmacro->tree = newtree ;
      newmacro->serial = ++macro_serialno ;
      newmacro->name = name ;
      newmacro->prev = firstmacro ;
      if (firstmacro)
         newmacro->prev->next = newmacro ;
      firstmacro = newmacro ;
      return newmacro->serial ;
   }
   else
   {
       exiterror( ERR_YACC_SYNTAX, 0 )  ;
      return 0 ;
   }
#include "unmulti.h"
}
#else
int enter_macro( streng *source, streng *name )
{
   extern labelboxptr first_label, last_label ;
   treenode *newtree=NULL ;
   struct macro *newmacro=NULL ;

   initmacro( source ) ;
   parseroot = NULL ;
   if (!yyparse())
   {
      newtree = parseroot ;
      parseroot = NULL ;
      treadit( newtree ) ;
      newmacro = Malloc( sizeof( struct macro )) ;
      newmacro->next = NULL ;
      newmacro->first = first_source_line ;
      newmacro->last = last_source_line ;
      newmacro->firstlabel = first_label ;
      newmacro->lastlabel = last_label ;
      newmacro->tree = newtree ;
      newmacro->serial = ++macro_serialno ;
      newmacro->name = name ;
      newmacro->prev = firstmacro ;
      if (firstmacro)
         newmacro->prev->next = newmacro ;
      firstmacro = newmacro ;
      return newmacro->serial ;
   }
   else
   {
       exiterror( ERR_YACC_SYNTAX, 0 )  ;
      return 0 ;
   }
}
#endif



/*
 * Takes as input a pointer to a parameter structure, and counts the
 * number of parameters in it, and return that value. The counting
 * can be performed in two different manners, either soft or hard.
 * Soft means that "trailing" ommitted parameters are ignored, hard
 * means that all parameters are counted. (When counting hard, all
 * routines stared from Rexx has at least one parameter: the one that
 * was ommitted. However, when started from C by SAA API, functions
 * can be started with zero parameters.)
 */
int count_params( paramboxptr ptr, int soft )
{
   int scnt=0, hcnt=0 ;

#if !defined(HAVE_WINMULTITHREADING)
   assert( PARAM_TYPE_SOFT && !PARAM_TYPE_HARD ) ;
#endif

   for (hcnt=scnt=0; ptr; ptr=ptr->next, hcnt++)
      if (soft && ptr->value)
         scnt = hcnt ;

   return ((soft) ? scnt : hcnt ) ;

}


/*
 * Takes a pointer to an argument structure as input, together with an
 * integer. Returns the parameter numbered by the number, or NULL if
 * either that parameter is omitted or otherwise non-existing.
 */
streng *get_parameter( paramboxptr ptr, int number )
{
   assert( number>0 ) ;
   for (; ptr && (--number!=0); ptr=ptr->next) ;

   return ((ptr && ptr->value) ? ptr->value : NULL ) ;
}

#if defined(HAVE_WINMULTITHREADING)
#include "header.h"
globalext *Common(void)
{
   extern DWORD dwsysteminfo;
   return ((globalext *)TlsGetValue(dwsysteminfo));
}
#endif

