#ifndef lint
static char *RCSid = "$Id: interp.c,v 1.7 1993/05/07 20:23:38 anders Exp anders $";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992-1994  Anders Christensen <anders@pvv.unit.no>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/****************************************************************************
*   This code modified for Multithread Win32 port by Les Moull April 1999.  *
****************************************************************************/

#include "rexx.h"
#include <stdio.h>
#include <ctype.h>

#if !defined(HAVE_WINMULTITHREADING)
extern nodeptr parseroot ;
#endif

void set_line_nos( treenode *ptr, int lineno, int charno ) 
{
   int i=0 ;

   if (!ptr)
      return ;
 
   if (ptr->lineno >= 0)
   {
      ptr->lineno = lineno ;
      ptr->charnr = charno ;
   }

   for (i=0; i<5; i++)
      if (ptr->p[i])
         set_line_nos( ptr->p[i], lineno, charno ) ;

   if (ptr->next)
      set_line_nos( ptr->next, lineno, charno ) ;
}



static streng *ostring=NULL ;

streng *dointerpret( streng *string )
{
   treenode *newtree=NULL ;
   nodeptr savecurrentnode ;
   streng *ptr=NULL;
#if !defined(HAVE_WINMULTITHREADING)
   REG_FAR extern nodeptr currentnode ;
#else
# include "multi.h"
#endif

   if (ostring)
      Free_string(ostring) ;

   initinterpret( ostring=string ) ;
   parseroot = NULL ;
   if (!yyparse()) {
      newtree = parseroot ;
      parseroot = NULL ;
      kill_lines( first_source_line ) ;
      if (currentnode)
         set_line_nos( newtree, currentnode->lineno, currentnode->charnr ) ;

      treadit( newtree ) ;
      Free_string( string ) ;
      ostring = NULL ;
      /* Save and restore currentnode around interpret. It is set within
       * interpret and may result to illegal memory accesses in case of
       * errors if it is not restored, FGC
       */
      savecurrentnode = currentnode;
      ptr = interpret( newtree ) ;
      currentnode = savecurrentnode;
      if (newtree) 
         destroytree( newtree ) ;
   }
   else
   {
       exiterror( ERR_YACC_SYNTAX, 0 )  ;
   }
#include "unmulti.h"
   return ptr;
}



/* actually, this is rather useless .... */
streng *dovalue( streng *string ) 
{
   treenode *newtree=NULL ;
   streng *tstr=NULL ;
#include "multi.h"

   initvalue( string ) ;
   parseroot = NULL ;
   if (yyparse())
       exiterror( ERR_YACC_SYNTAX, 0 )  ;

   kill_lines( first_source_line ) ;
   newtree = parseroot ;
   parseroot = NULL ;
   tstr = evaluate(newtree->p[0]->p[1]->p[0],NULL) ;
   destroytree(newtree) ;
   return tstr ;
#include "unmulti.h"
}


