/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992-1994  Anders Christensen <anders@pvv.unit.no>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/****************************************************************************
*   This code modified for Multithread Win32 port by Les Moull April 1999.  *
****************************************************************************/

/*
 * $Id: extern.h,v 1.17 1993/05/10 05:54:16 anders Exp anders $
 *     such traceing is anabled.
 */


/*
 * Routines in lexsrc.l
 */
   void initexternal( FILE *fptr ) ;
   void initinterpret( streng *string ) ;
   void initvalue( streng *string ) ;
   void initmacro( streng *str ) ;
   void initscanner( void ) ;


/*
 * Routines in parse.c
 */
   void doparse( streng *source, nodeptr subtree, int end, int point ) ;
   void parseargtree(paramboxptr argbox, nodeptr this, int upper);
   int bmstrstr( streng *heystack, int start, streng *needle ) ;


/*
 * Routines in debug.c
 */
   void dumpvars( variableptr *hashptr ) ;
   void dumptree( treenode *this, int level, int newline ) ;
   int numsourcelines( void ) ;
   streng *sourceline( int line, lineboxptr, lineboxptr ) ;
   streng *getsourceline( int line, int charnr, lineboxptr, lineboxptr ) ;
#ifndef NDEBUG
   char *getsym( int number ) ;
#endif
#ifdef TRACEMEM
   void marksource( lineboxptr ) ;
#endif


/*
 * Routines in files.c
 */
   streng *readkbdline( void ) ;
   void mark_filetable( void ) ;
   void purge_filetable( void ) ;
   void initfiletable( void ) ;
   void fixup_file( streng * ) ;
   void get_external_routine(char *, FILE **, char *, int);
   void find_shared_library(char *, char *, char *);
   streng *ConfigStreamQualified( streng *name );


/*
 * Routines in expr.c
 */
   int isboolean( nodeptr ) ;
   num_descr *calcul( nodeptr, num_descr** ) ;
   void initexpr( void ) ;
   streng *evaluate( nodeptr this, streng **kill ) ;


/*
 * Routines in rexx.h
 */
#ifdef TRACEMEM
#endif /* TRACEMEM */


/* ------------------------------ memory.c ------------------------------ */
#ifdef FLISTS
   void *get_a_chunk( int bytes ) ;
   streng *get_a_streng( int bytes ) ;
   void  give_a_chunk( void *ptr ) ;
   void  give_a_streng( streng *ptr ) ;
   void  init_hash_table( void ) ;
#endif
#ifdef TRACEMEM
   void *mymalloc( int bytes ) ;
   void  myfree( void *ptr ) ;
   void regmarker( void (*func)() ) ;
   int   have_allocated( int flag ) ;
   void  markmemory( void *ptr, int i ) ;
   int   listleaked( int pflag ) ;
   void  memory_stats( void ) ;
   void  mark_listleaked_params( void ) ;
#endif /* TRACEMEM */

#ifdef TRACEMEM
# define Malloc(bytes)     mymalloc(bytes)
# define Free(ptr)         myfree(ptr)
# define Free_string(ptr)  myfree(ptr)
#else
# ifdef FLISTS
#  define Malloc(bytes)     get_a_chunk(bytes)
#  define Free(ptr)         give_a_chunk(ptr)
#  define Free_string(ptr)  give_a_streng(ptr)
# else
#  define Malloc(bytes)     malloc(bytes)
#  define Free(ptr)         free(ptr)
#  ifdef CHECK_MEMORY
    void  give_a_streng( streng *ptr ) ;
#   define Free_string(ptr)  give_a_streng(ptr)
#  else
#   define Free_string(ptr)  free(ptr)
#  endif /* CHECK_MEMORY */
# endif /* FLISTS */
#endif /* TRACEMEM */



/* ------------------------------ stack.c ------------------------------ */
   streng *popline( void ) ;
   void stack_lifo( streng *line ) ;
   void stack_fifo( streng *line ) ;
   int lines_in_stack( void ) ;
   int stack_empty( void ) ;
#ifdef TRACEMEM
   void mark_stack( void ) ;
#endif /* TRACEMEM */
   int drop_buffer( int num ) ;
   int make_buffer( void ) ;
   void type_buffer( void ) ;
   void tmp_stack( streng*, int ) ;
   void flush_stack( int is_fifo ) ;


/*
 * Routines in misc.c
 */
   streng *upcase( streng *text ) ;
   streng *nullstringptr( void ) ;
   char *system_type( void ) ;
   double cpu_time( void ) ;
#if defined(_POSIX_SOURCE) || defined(__WATCOMC__) || defined(_MSC_VER) || defined(__EMX__)
   void getsecs( time_t *secs, time_t *usecs ) ;
#endif
   int convert_date(streng *, char, void *);
   int convert_time(streng *, char, void *,void *);



/*
 * Routines in error.c
 */
   char *errortext( int errorno ) ;
   char *suberrortext( int , int  );
   void exiterror( int errorno , int suberrorno, ... ) ;
   void yyerror( char *errtext ) ;
   char *getsym( int numb ) ;
   int lineno_of( nodeptr ) ;


/*
 * Routines in variable.c
 */
   void detach( variableptr ptr ) ;
   void init_vars( void ) ;
   int var_was_found( void ) ;
   variableptr *create_new_varpool( void ) ;
   void setvalue( streng *name, streng *value ) ;
   num_descr *fix_compoundnum( nodeptr this, num_descr *new ) ;
   void setshortcutnum( nodeptr this, num_descr *value ) ;
   streng *getvalue( streng *name, int trace ) ;
   streng *isvariable( streng *name ) ;
   streng *get_it_anyway( streng *name ) ;
   void expose_var( streng *name ) ;
   void drop_var( streng *name ) ;
   void set_ignore_novalue( void ) ;
   int valid_var_symbol( streng *symbol ) ;
   void clear_ignore_novalue( void ) ;
#ifdef TRACEMEM
   void markvariables( proclevel ) ;
#endif /* TRACEMEM */
   streng *shortcut( nodeptr ) ;
   num_descr *shortcutnum( nodeptr ) ;
   void setshortcut( nodeptr this, streng *value ) ;
   streng *fix_compound( nodeptr this, streng *value ) ;
   void kill_variables( variableptr *array ) ;
   variableptr get_next_variable( int reset ) ;



/*
 * Routines in shell.c
 */
   int posix_do_command( streng *command, int flag, int envir ) ;
   streng *run_popen( streng *command, streng *envir ) ;



/*
 * Routines in tracing.c
 */
   void set_trace( streng * ) ;
   void set_trace_char( char ) ;
   void flush_trace_chars( void ) ;
   void queue_trace_char( char ch ) ;
   void tracenumber( num_descr *num, char type ) ;
   void tracebool( int value, char type ) ;
   int pushcallstack( treenode *this ) ;
   void popcallstack( int value ) ;
   void traceerror( treenode *this, int RC ) ;
   void tracecompound( streng *stem, int length, streng *index, char trch ) ;
   void starttrace( void ) ;
   void tracemsg( void ) ;
   int intertrace( void ) ;
   void tracevalue( streng *str, char type ) ;
   void traceline( treenode *this, char tch, int offset ) ;
   void traceback( void ) ;


/*
 * Routines in interp.c
 */
   streng *dovalue( streng *string ) ;
   streng *dointerpret( streng *string ) ;



/*
 * Routines in interpret.c
 */
   void update_envirs( proclevel level ) ;
   proclevel newlevel( proclevel oldlevel ) ;
   streng *interpret( nodeptr rootnode ) ;
   void removelevel( proclevel level ) ;
   void init_spec_vars( void ) ;
#ifdef TRACEMEM
   void mark_statics( void ) ;
#endif


/*
 * Routines in yaccsrc.y
 */
   int yylex( void ) ;
   extern int yyparse( void ) ;
   void kill_lines( lineboxptr first ) ;
   void destroytree( nodeptr this ) ;
   void purge( void ) ;



/*
 * Routines in funcs.c
 */
   streng *buildtinfunc( nodeptr this ) ;
   void deallocplink( paramboxptr first ) ;
   paramboxptr initplist( nodeptr this ) ;
   int myatol( streng *text ) ;
   paramboxptr getnextp( nodeptr this, paramboxptr lastp ) ;
   void checkparam( paramboxptr params, int min, int max, char *name ) ;
   char getoptionchar( streng *param, char *bif, int argnum, char *options ) ;
   int atozpos( streng *text, char *bif, int argnum ) ;
   int atopos( streng *text, char *bif, int argnum ) ;
   int atoposorzero( streng *text, char *bif, int argnum ) ;
   char getonechar( streng *text, char *bif, int argnum ) ;
   streng *cpy( streng *source ) ;
   streng *param( paramboxptr ptr, int num ) ;
   char getoption( streng * ) ;
   streng *int_to_streng( int input ) ;
   int basedays(int);
#ifdef TRACEMEM
   void mark_param_cache( void ) ;
#endif
   int base2date( long basedate, void *conv_tmdata ) ;
   int leapyear( long year ) ;



   void addtwostrings( char *one, char *two, char *answer ) ;


/*
 Functions in cmath.c
 */
   double myatof( streng *string ) ;
   int myisnumber( streng *string ) ;


/*
 Functions in rexx.c
 */
   void mark_systeminfo( void ) ;
   nodeptr treadit( nodeptr ) ;
   sysinfobox *creat_sysinfo( streng *envir ) ;


/*
 * Functions in signals.h
 */
   trap *gettraps( proclevel level ) ;
   sigtype *getsigs( proclevel level ) ;
   void mark_signals( void ) ;
   int condition_hook( int, int, int, int, streng *) ;
   void signal_setup( void ) ;
   int identify_trap( int type ) ;
   void set_rexx_halt( void ) ;


/*
 * Functions in strings.c
 */
   char *str_trans(char * ,char ,char ) ;
   streng *Str_strp(streng * ,char ,char ) ;
   int mem_cmpic( char *, char *, int );


/*
 * functions in library.c
 */
   int load_package( streng*, streng*, streng* ) ;
   void *loaded_lib_func( streng *name ) ;
   void set_err_message( char *message ) ;
   int loadrxfunc( struct library *lptr, streng *rxname, streng *objnam ) ;
   int rexxsaa_rxfuncdlladd( char*, char*, char* ) ;
   int rex_rxfuncdlldrop( streng* ) ;
   int rex_rxfuncdllquery( streng* ) ;

/*
 * Functions in extlib.c
 */
   int addfunc( streng *name, int type ) ;
   int delfunc( streng *name ) ;
   int external_func( streng *name ) ;


/*
 * functions in macros.c
 */
   void expand_to_str( variableptr ptr ) ;
   void kill_macro( streng *name, int serial )  ;
#if defined(HAVE_WINMULTITHREADING)
   int enter_macro(sysinfobox *, streng *, streng * );
   streng *do_instore(streng *,paramboxptr, streng*, int*, int, int, int, streng *,int *);
#else
   int enter_macro( streng *source, streng *name ) ;
   streng *do_instore(streng *,paramboxptr, streng*, int*, int, int, int, int);
#endif
   streng *execute_external(streng*, paramboxptr, streng*, int*, int, int );
   int count_params( paramboxptr ptr, int soft ) ;
   streng *get_parameter( paramboxptr ptr, int number ) ;


/*
 * Functions in envir.c
 */
   streng *perform( streng *command, streng *envir, nodeptr this ) ;
   void add_envir( streng *name, int type, int subtype ) ;
   void init_envir( void ) ;
   void del_envir( streng *name ) ;


/*
 * Functions in files.c
 */
   void CloseOpenFiles ( void ) ;


/*
 * Functions in client.c
 */
   int hookup( int type ) ;
   int hookup_output( int type, streng *outdata ) ;
   int hookup_input( int type, streng **indata ) ;
   void SetupClient( char *pipes ) ;
   void SetupInternal( char *envir ) ;
   void RunClient( void ) ;
   streng *do_an_external( streng *name, paramboxptr parms, char exitonly, char called ) ;
   streng *do_an_external_dll( void *func, paramboxptr parms, char called ) ;
   streng *SubCom( streng *command, streng *environment, int *rc ) ;


/*
 * Routines in doscmd.c
 */
   int dos_do_command( streng *command, int flag, int envir ) ;
   int my_win32_setenv( char *name, char *value ) ;


/*
 * Routines in options.c
 */
   void do_options( streng *options, int ) ;
   int get_options_flag( proclevel, int ) ;
   void set_options_flag( proclevel, int, int ) ;


/*
 * Routines in rexext.c
 */
   char *mygetenv( char *name, char *buf, int bufsize ) ;


/*
 * global variables
 */

#if !defined(HAVE_WINMULTITHREADING)
extern int trace_stat ;
#endif


