#ifndef lint
static char *RCSid = "$Id: envir.c,v 1.2 1993/05/10 05:52:45 anders Exp anders $";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1993-1994  Anders Christensen <anders@pvv.unit.no>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/****************************************************************************
*   This code modified for Multithread Win32 port by Les Moull April 1999.  *
****************************************************************************/

#include "rexx.h"
#include <string.h>

#ifdef HAVE_CTYPE_H
# include <ctype.h>
#endif

#if defined(VMS)
# define fork() vfork()
# define posix_do_command vms_do_command
#endif

#if defined(DOS) || defined(WIN32) || defined(OS2) || defined(_AMIGA)
# define posix_do_command dos_do_command
#endif

#if !defined(HAVE_WINMULTITHREADING)
static streng var_rc = {2,2,"RC"} ;
struct envir
{
   streng *name ;
   int type ;
   int subtype ;
   struct envir *next, *prev ;
};
struct envir *firstenvir=NULL;
#endif


void add_envir( streng *name, int type, int subtype ) 
{
   struct envir *ptr=NULL ;
#include "multi.h"

   ptr = Malloc( sizeof(struct envir)) ;
   ptr->name = name ;
   ptr->type = type ;
   ptr->subtype = subtype ;
   ptr->prev = firstenvir ;
   ptr->next = NULL ;
   firstenvir = ptr ;
   if (ptr->prev)
      ptr->prev->next = ptr ;
#include "unmulti.h"
}


#ifdef TRACEMEM
void markenvir( void ) 
{
   struct envir *eptr=NULL ;
#include "multi.h"

   eptr = firstenvir ;
   for (; eptr; eptr=eptr->prev )
   {
      markmemory( eptr, TRC_ENVIRBOX ) ;
      markmemory( eptr->name, TRC_ENVIRNAME ) ;
   }
#include "unmulti.h"
}
#endif /* TRACEMEM */


static struct envir *find_envir( streng *name ) 
{
   struct envir *ptr=NULL ;
#include "multi.h"

   for (ptr=firstenvir; ptr; ptr=ptr->prev)
      if (!Str_cmp(ptr->name, name))
         return ptr ;

   return NULL ;
#include "unmulti.h"
}


void del_envir( streng *name ) 
{
   struct envir *ptr=NULL ;
#include "multi.h"
   
   ptr = find_envir( name ) ;
   if (ptr)
   {
      if (ptr->prev)
         ptr->prev->next = ptr->next ;
      if (ptr->next)
         ptr->next->prev = ptr->prev ;
      if (firstenvir==ptr)
         firstenvir = ptr->prev ;
   }
#include "unmulti.h"
}


void init_envir( void )
{
   add_envir( Str_cre("COMMAND"), ENVIR_SHELL, SUBENVIR_COMMAND ) ;
   add_envir( Str_cre("SYSTEM"), ENVIR_SHELL, SUBENVIR_SYSTEM ) ;   
   add_envir( Str_cre("OS2ENVIRONMENT"), ENVIR_SHELL, SUBENVIR_SYSTEM ) ;
   add_envir( Str_cre("ENVIRONMENT"), ENVIR_SHELL, SUBENVIR_SYSTEM ) ;
   add_envir( Str_cre("CMD"), ENVIR_SHELL, SUBENVIR_COMMAND ) ;
   add_envir( Str_cre("PATH"), ENVIR_SHELL, SUBENVIR_PATH ) ;

#ifdef TRACEMEM
   regmarker( markenvir ) ;
#endif
}


int get_io_flag( streng *command )
{
   int length=0, i=0, pos=0 ;
   int flag=0 ;

   flag = REDIR_NONE ;
   if ((length=Str_len(command))>5) 
   {
      if ((!memcmp(command->value,"lifo>",5)) || 
          (!memcmp(command->value,"LIFO>",5)))
               flag |= REDIR_INPUT ;

      if ((!memcmp(command->value+length-5,">lifo",5)) 
      ||  (!memcmp(command->value+length-5,">LIFO",5)))
      {
         flag |= REDIR_OUTLIFO ;
         command->len -= 5;
      }
      else 
      {
         if ( ( !memcmp( command->value+length-5, ">fifo" ,5 ) )
         ||   ( !memcmp( command->value+length-5, ">FIFO", 5 ) ) )
         {
            flag |= REDIR_OUTFIFO ;
            command->len -= 5;
         }
         else 
         {
#ifdef FGC
            if ( length >= 8 )
            {
               int j = 0;

               for ( i = 0, pos = -1; i < length; i++ )
               {
                  if ( *(command->value + i ) == '|' )
                  {
                     pos = i;
                     /* don't break here, as we want the last '|' */
                  }
               }
               if ( pos != -1 )
               {
                  /* allow "|" [whitespace] "rxqueue" [whitespace] */
                  /* "|" already checked */
                  for ( i = pos + 1, j = 0; i < length; i++ )
                  {
                     if ( !isspace(command->value[i] ) )
                        break;
                  }
                  if ( i + 7 <= length )
                  {
                     if (mem_cmpic( command->value + i, "RXQUEUE", 7 ) == 0 )
                     {
                        i += 7;
                        for ( ; i < length; i++ )
                        {
                           if ( !isspace( command->value[i] ) )
                              break;
                        }
                        if ( i == length )
                        {
                            flag |= REDIR_OUTFIFO ;
                            command->len = pos;
                        }
                     }
                  }
               }
            }
#else
            if ( length > 8 )
            {
               char tmp[10];
               int j = 0;

               for ( i = 0, pos = -1; i < length; i++ )
               {
                  if ( *(command->value + i ) == '|' )
                  {
                     pos = i;
                     /* don't break here, as we want the last '|' */
                  }
               }
               if ( pos != -1 )
               {
                  for ( i = pos, j = 0; i < length; i++ )
                  {
                     if ( *(command->value + i ) != ' ' )
                        tmp[j++] = *(command->value + i );
                  }
                  tmp[j] = '\0';
                  if ( j == 8
                  &&  mem_cmpic( tmp, "|rxqueue", 8 ) == 0 )
                  {
                     flag |= REDIR_OUTFIFO ;
                     command->len = pos;
                  }
               }
            }
#endif
         }
      }
   }

   if (flag & REDIR_INPUT)
   {
#if FGC
      for(i=5; i<Str_len(command); i++ ) /* avoid buffer overrun */
#else
      for(i=5; i<=Str_len(command); i++ )
#endif
         command->value[i-5]=command->value[i] ;
       command->len -= 5 ;
   }

   return flag ;
}


streng *perform( streng *command, streng *envir, nodeptr this )
{
   int rc=0, io_flag=0 ;
   struct envir *eptr=NULL ;
   streng *retstr=NULL ;
   streng *cmd=Str_dup(command);
#if !defined(HAVE_WINMULTITHREADING)
   extern proclevel currlevel ;
#else
# include "multi.h"
#endif

#ifdef lint
   retstr = NULL ;
#endif

   eptr = find_envir( envir ) ;
   io_flag = get_io_flag( cmd ) ;

   if (eptr)
   {
      switch (eptr->type)
      {
         case ENVIR_PIPE:
            retstr = SubCom( cmd, envir, &rc ) ;
            break ;

         case ENVIR_SHELL:
            rc = posix_do_command( cmd, io_flag, eptr->subtype ) ;
            retstr = int_to_streng( rc ) ;
            break ;

         default:
             exiterror( ERR_INTERPRETER_FAILURE, 0 )  ;
      }
   }
   else
   {
#if 0
      rc = -3 ;
      retstr = nullstringptr() ;
#else
      retstr = SubCom( cmd, envir, &rc ) ;
#endif
   }

   setvalue(&var_rc,Str_dup(retstr)) ;

   if (rc && this)
   {
      trap *traps ;
      int type ; 

      traceerror( this, rc ) ;
      traps = gettraps( currlevel ) ;
      type = (rc>0) ? SIGNAL_ERROR : SIGNAL_FAILURE ;

      if ((type==SIGNAL_FAILURE) && (traps[type].on_off))
         condition_hook( type, rc, 0, this->lineno, Str_dup(cmd) ) ;
      else if (traps[SIGNAL_ERROR].on_off)
         condition_hook( SIGNAL_ERROR, rc, 0, this->lineno, Str_dup(cmd) ) ;
   }
   
   Free_string( cmd ) ;
   return retstr ;
#include "unmulti.h"
}




